/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.command;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.Key;
import com.aerospike.client.Log;
import com.aerospike.client.cluster.Node;
import com.aerospike.client.command.BatchItem;
import com.aerospike.client.command.BatchNode;
import com.aerospike.client.command.Buffer;
import com.aerospike.client.command.MultiCommand;
import com.aerospike.client.policy.Policy;
import java.io.IOException;
import java.util.HashMap;

public final class BatchCommandExists
extends MultiCommand {
    private final BatchNode.BatchNamespace batchNamespace;
    private final Policy policy;
    private final HashMap<Key, BatchItem> keyMap;
    private final boolean[] existsArray;

    public BatchCommandExists(Node node, BatchNode.BatchNamespace batchNamespace, Policy policy, HashMap<Key, BatchItem> keyMap, boolean[] existsArray) {
        super(node);
        this.batchNamespace = batchNamespace;
        this.policy = policy;
        this.keyMap = keyMap;
        this.existsArray = existsArray;
    }

    @Override
    protected Policy getPolicy() {
        return this.policy;
    }

    @Override
    protected void writeBuffer() throws AerospikeException {
        this.setBatchExists(this.batchNamespace);
    }

    @Override
    protected boolean parseRecordResults(int receiveSize) throws AerospikeException, IOException {
        this.dataOffset = 0;
        while (this.dataOffset < receiveSize) {
            if (!this.valid) {
                throw new AerospikeException.QueryTerminated();
            }
            this.readBytes(22);
            int resultCode = this.dataBuffer[5] & 0xFF;
            if (resultCode != 0 && resultCode != 2) {
                throw new AerospikeException(resultCode);
            }
            byte info3 = this.dataBuffer[3];
            if ((info3 & 1) == 1) {
                return false;
            }
            int fieldCount = Buffer.bytesToShort(this.dataBuffer, 18);
            int opCount = Buffer.bytesToShort(this.dataBuffer, 20);
            if (opCount > 0) {
                throw new AerospikeException.Parse("Received bins that were not requested!");
            }
            Key key = this.parseKey(fieldCount);
            BatchItem item = this.keyMap.get(key);
            if (item != null) {
                int index2 = item.getIndex();
                this.existsArray[index2] = resultCode == 0;
                continue;
            }
            if (!Log.debugEnabled()) continue;
            Log.debug("Unexpected batch key returned: " + key.namespace + ',' + Buffer.bytesToHexString(key.digest));
        }
        return true;
    }
}

