/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.command;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.ScanCallback;
import com.aerospike.client.cluster.Cluster;
import com.aerospike.client.cluster.Node;
import com.aerospike.client.command.ScanCommand;
import com.aerospike.client.policy.ScanPolicy;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicInteger;

public final class ScanExecutor {
    private final ExecutorService threadPool;
    private final ScanThread[] threads;
    private final AtomicInteger completedCount = new AtomicInteger();
    private volatile Exception exception;
    private final int maxConcurrentNodes;
    private boolean completed;

    public ScanExecutor(Cluster cluster, Node[] nodes, ScanPolicy policy, String namespace, String setName, ScanCallback callback, String[] binNames) {
        this.threadPool = cluster.getThreadPool();
        this.threads = new ScanThread[nodes.length];
        for (int i = 0; i < nodes.length; ++i) {
            ScanCommand command = new ScanCommand(nodes[i], policy, namespace, setName, callback, binNames);
            this.threads[i] = new ScanThread(command);
        }
        this.maxConcurrentNodes = policy.maxConcurrentNodes == 0 || policy.maxConcurrentNodes >= this.threads.length ? this.threads.length : policy.maxConcurrentNodes;
    }

    public void scanParallel() throws AerospikeException {
        for (int i = 0; i < this.maxConcurrentNodes; ++i) {
            this.threadPool.execute(this.threads[i]);
        }
        this.waitTillComplete();
        if (this.exception != null) {
            if (this.exception instanceof AerospikeException) {
                throw (AerospikeException)this.exception;
            }
            throw new AerospikeException(this.exception);
        }
    }

    private void threadCompleted() {
        int finished = this.completedCount.incrementAndGet();
        if (finished < this.threads.length) {
            int nextThread = finished + this.maxConcurrentNodes - 1;
            if (nextThread < this.threads.length) {
                this.threadPool.execute(this.threads[nextThread]);
            }
        } else {
            this.notifyCompleted();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopThreads(Exception cause) {
        ScanThread[] scanThreadArray = this.threads;
        synchronized (this.threads) {
            if (this.exception != null) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            this.exception = cause;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            for (ScanThread thread : this.threads) {
                try {
                    thread.stop();
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            this.notifyCompleted();
            return;
        }
    }

    private synchronized void waitTillComplete() {
        while (!this.completed) {
            try {
                super.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private synchronized void notifyCompleted() {
        this.completed = true;
        super.notify();
    }

    private final class ScanThread
    implements Runnable {
        private final ScanCommand command;
        private Thread thread;

        public ScanThread(ScanCommand command) {
            this.command = command;
        }

        @Override
        public void run() {
            this.thread = Thread.currentThread();
            try {
                if (this.command.isValid()) {
                    this.command.execute();
                }
            }
            catch (Exception e) {
                ScanExecutor.this.stopThreads(e);
            }
            if (ScanExecutor.this.exception == null) {
                ScanExecutor.this.threadCompleted();
            }
        }

        public void stop() {
            this.command.stop();
            if (this.thread != null) {
                this.thread.interrupt();
            }
        }
    }
}

