/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.task;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.Info;
import com.aerospike.client.cluster.Cluster;
import com.aerospike.client.cluster.Node;
import com.aerospike.client.query.Statement;
import com.aerospike.client.task.Task;

public final class ExecuteTask
extends Task {
    private final int taskId;
    private final boolean scan;

    public ExecuteTask(Cluster cluster, Statement statement) {
        super(cluster, false);
        this.taskId = statement.getTaskId();
        this.scan = statement.isScan();
    }

    @Override
    public boolean isDone() throws AerospikeException {
        String command = this.scan ? "scan-list" : "query-list";
        Node[] nodes = this.cluster.getNodes();
        boolean done = false;
        for (Node node : nodes) {
            int end;
            String find;
            String response = Info.request(node, command);
            int index2 = response.indexOf(find = "job_id=" + this.taskId + ':');
            if (index2 < 0) {
                done = true;
                continue;
            }
            find = "job_status=";
            int begin = index2 + find.length();
            if ((index2 = response.indexOf(find, begin)) < 0) continue;
            begin = index2 + find.length();
            String status = response.substring(begin, end = response.indexOf(58, begin));
            if (status.equals("ABORTED")) {
                throw new AerospikeException.QueryTerminated();
            }
            if (status.equals("IN PROGRESS")) {
                return false;
            }
            if (!status.equals("DONE")) continue;
            done = true;
        }
        return done;
    }
}

