/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client;

import java.util.List;
import java.util.Map;

public final class Record {
    public final Map<String, Object> bins;
    public final List<Map<String, Object>> duplicates;
    public final int generation;
    public final int expiration;

    public Record(Map<String, Object> bins, List<Map<String, Object>> duplicates, int generation, int expiration) {
        this.bins = bins;
        this.duplicates = duplicates;
        this.generation = generation;
        this.expiration = expiration;
    }

    public Object getValue(String name) {
        return this.bins == null ? null : this.bins.get(name);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(500);
        sb.append("(gen:");
        sb.append(this.generation);
        sb.append("),(exp:");
        sb.append(this.expiration);
        sb.append("),(bins:");
        if (this.bins != null) {
            boolean sep = false;
            for (Map.Entry<String, Object> entry : this.bins.entrySet()) {
                if (sep) {
                    sb.append(',');
                } else {
                    sep = true;
                }
                sb.append('(');
                sb.append(entry.getKey());
                sb.append(':');
                sb.append(entry.getValue());
                sb.append(')');
                if (sb.length() <= 1000) continue;
                sb.append("...");
                break;
            }
        } else {
            sb.append("null");
        }
        sb.append(')');
        return sb.toString();
    }
}

