/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.command.Buffer;
import com.aerospike.client.lua.LuaBytes;
import com.aerospike.client.lua.LuaInstance;
import com.aerospike.client.util.Packer;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.luaj.vm2.LuaInteger;
import org.luaj.vm2.LuaNil;
import org.luaj.vm2.LuaString;
import org.luaj.vm2.LuaValue;

public abstract class Value {
    public static Value get(String value) {
        return value == null ? new NullValue() : new StringValue(value);
    }

    public static Value get(byte[] value) {
        return value == null ? new NullValue() : new BytesValue(value);
    }

    public static Value get(byte[] value, int offset, int length) {
        return value == null ? new NullValue() : new ByteSegmentValue(value, offset, length);
    }

    public static Value get(int value) {
        return new IntegerValue(value);
    }

    public static Value get(long value) {
        return new LongValue(value);
    }

    public static Value get(Value[] value) {
        return value == null ? new NullValue() : new ValueArray(value);
    }

    public static Value getAsBlob(Object value) {
        return value == null ? new NullValue() : new BlobValue(value);
    }

    public static Value getAsList(List<?> value) {
        return value == null ? new NullValue() : new ListValue(value);
    }

    public static Value getAsMap(Map<?, ?> value) {
        return value == null ? new NullValue() : new MapValue(value);
    }

    public static Value getAsNull() {
        return new NullValue();
    }

    public static Value get(Object value) {
        if (value == null) {
            return new NullValue();
        }
        if (value instanceof String) {
            return new StringValue((String)value);
        }
        if (value instanceof byte[]) {
            return new BytesValue((byte[])value);
        }
        if (value instanceof Integer) {
            return new IntegerValue((Integer)value);
        }
        if (value instanceof Long) {
            return new LongValue((Long)value);
        }
        if (value instanceof Value) {
            return (Value)value;
        }
        return new BlobValue(value);
    }

    public abstract int estimateSize() throws AerospikeException;

    public abstract int write(byte[] var1, int var2) throws AerospikeException;

    public abstract void pack(Packer var1) throws IOException;

    public abstract int getType();

    public abstract Object getObject();

    public abstract LuaValue getLuaValue(LuaInstance var1);

    public static final class MapValue
    extends Value {
        private final Map<?, ?> map;
        private byte[] bytes;

        public MapValue(Map<?, ?> map) {
            this.map = map;
        }

        @Override
        public int estimateSize() throws AerospikeException {
            this.bytes = Packer.pack(this.map);
            return this.bytes.length;
        }

        @Override
        public int write(byte[] buffer, int offset) {
            System.arraycopy(this.bytes, 0, buffer, offset, this.bytes.length);
            return this.bytes.length;
        }

        @Override
        public void pack(Packer packer) throws IOException {
            packer.packMap(this.map);
        }

        @Override
        public int getType() {
            return 19;
        }

        @Override
        public Object getObject() {
            return this.map;
        }

        @Override
        public LuaValue getLuaValue(LuaInstance instance) {
            return instance.getLuaMap(this.map);
        }

        public String toString() {
            return this.map.toString();
        }
    }

    public static final class ListValue
    extends Value {
        private final List<?> list;
        private byte[] bytes;

        public ListValue(List<?> list) {
            this.list = list;
        }

        @Override
        public int estimateSize() throws AerospikeException {
            this.bytes = Packer.pack(this.list);
            return this.bytes.length;
        }

        @Override
        public int write(byte[] buffer, int offset) {
            System.arraycopy(this.bytes, 0, buffer, offset, this.bytes.length);
            return this.bytes.length;
        }

        @Override
        public void pack(Packer packer) throws IOException {
            packer.packList(this.list);
        }

        @Override
        public int getType() {
            return 20;
        }

        @Override
        public Object getObject() {
            return this.list;
        }

        @Override
        public LuaValue getLuaValue(LuaInstance instance) {
            return instance.getLuaList(this.list);
        }

        public String toString() {
            return this.list.toString();
        }
    }

    public static final class ValueArray
    extends Value {
        private final Value[] array;
        private byte[] bytes;

        public ValueArray(Value[] array) {
            this.array = array;
        }

        @Override
        public int estimateSize() throws AerospikeException {
            this.bytes = Packer.pack(this.array);
            return this.bytes.length;
        }

        @Override
        public int write(byte[] buffer, int offset) {
            System.arraycopy(this.bytes, 0, buffer, offset, this.bytes.length);
            return this.bytes.length;
        }

        @Override
        public void pack(Packer packer) throws IOException {
            packer.packValueArray(this.array);
        }

        @Override
        public int getType() {
            return 20;
        }

        @Override
        public Object getObject() {
            return this.array;
        }

        @Override
        public LuaValue getLuaValue(LuaInstance instance) {
            return instance.getLuaList(this.array);
        }

        public String toString() {
            return Arrays.toString(this.array);
        }
    }

    public static final class BlobValue
    extends Value {
        private final Object object;
        private byte[] bytes;

        public BlobValue(Object object) {
            this.object = object;
        }

        @Override
        public int estimateSize() throws AerospikeException.Serialize {
            try {
                ByteArrayOutputStream bstream = new ByteArrayOutputStream();
                ObjectOutputStream ostream = new ObjectOutputStream(bstream);
                ostream.writeObject(this.object);
                ostream.close();
                this.bytes = bstream.toByteArray();
                return this.bytes.length;
            }
            catch (Exception e) {
                throw new AerospikeException.Serialize(e);
            }
        }

        @Override
        public int write(byte[] buffer, int offset) {
            System.arraycopy(this.bytes, 0, buffer, offset, this.bytes.length);
            return this.bytes.length;
        }

        @Override
        public void pack(Packer packer) throws IOException {
            packer.packBlob(this.object);
        }

        @Override
        public int getType() {
            return 7;
        }

        @Override
        public Object getObject() {
            return this.object;
        }

        @Override
        public LuaValue getLuaValue(LuaInstance instance) {
            return LuaString.valueOf((byte[])this.bytes);
        }

        public String toString() {
            return Buffer.bytesToHexString(this.bytes);
        }
    }

    public static final class LongValue
    extends Value {
        private final long value;

        public LongValue(long value) {
            this.value = value;
        }

        @Override
        public int estimateSize() {
            return 8;
        }

        @Override
        public int write(byte[] buffer, int offset) {
            Buffer.longToBytes(this.value, buffer, offset);
            return 8;
        }

        @Override
        public void pack(Packer packer) throws IOException {
            packer.packLong(this.value);
        }

        @Override
        public int getType() {
            return 1;
        }

        @Override
        public Object getObject() {
            return this.value;
        }

        @Override
        public LuaValue getLuaValue(LuaInstance instance) {
            return LuaInteger.valueOf((long)this.value);
        }

        public String toString() {
            return Long.toString(this.value);
        }
    }

    public static final class IntegerValue
    extends Value {
        private final int value;

        public IntegerValue(int value) {
            this.value = value;
        }

        @Override
        public int estimateSize() {
            return 8;
        }

        @Override
        public int write(byte[] buffer, int offset) {
            Buffer.longToBytes(this.value, buffer, offset);
            return 8;
        }

        @Override
        public void pack(Packer packer) throws IOException {
            packer.packInt(this.value);
        }

        @Override
        public int getType() {
            return 1;
        }

        @Override
        public Object getObject() {
            return this.value;
        }

        @Override
        public LuaValue getLuaValue(LuaInstance instance) {
            return LuaInteger.valueOf((int)this.value);
        }

        public String toString() {
            return Integer.toString(this.value);
        }
    }

    public static final class StringValue
    extends Value {
        private final String value;

        public StringValue(String value) {
            this.value = value;
        }

        @Override
        public int estimateSize() {
            return Buffer.estimateSizeUtf8(this.value);
        }

        @Override
        public int write(byte[] buffer, int offset) {
            return Buffer.stringToUtf8(this.value, buffer, offset);
        }

        @Override
        public void pack(Packer packer) throws IOException {
            packer.packString(this.value);
        }

        @Override
        public int getType() {
            return 3;
        }

        @Override
        public Object getObject() {
            return this.value;
        }

        @Override
        public LuaValue getLuaValue(LuaInstance instance) {
            return LuaString.valueOf((String)this.value);
        }

        public String toString() {
            return this.value;
        }
    }

    public static final class ByteSegmentValue
    extends Value {
        private final byte[] bytes;
        private final int offset;
        private final int length;

        public ByteSegmentValue(byte[] bytes, int offset, int length) {
            this.bytes = bytes;
            this.offset = offset;
            this.length = length;
        }

        @Override
        public int estimateSize() {
            return this.length;
        }

        @Override
        public int write(byte[] buffer, int targetOffset) {
            System.arraycopy(this.bytes, this.offset, buffer, targetOffset, this.length);
            return this.length;
        }

        @Override
        public void pack(Packer packer) throws IOException {
            packer.packBytes(this.bytes, this.offset, this.length);
        }

        @Override
        public int getType() {
            return 4;
        }

        @Override
        public Object getObject() {
            return this;
        }

        @Override
        public LuaValue getLuaValue(LuaInstance instance) {
            return LuaString.valueOf((byte[])this.bytes, (int)this.offset, (int)this.length);
        }

        public String toString() {
            return Buffer.bytesToHexString(this.bytes, this.offset, this.length);
        }

        public byte[] getBytes() {
            return this.bytes;
        }

        public int getOffset() {
            return this.offset;
        }

        public int getLength() {
            return this.length;
        }
    }

    public static final class BytesValue
    extends Value {
        private final byte[] bytes;

        public BytesValue(byte[] bytes) {
            this.bytes = bytes;
        }

        @Override
        public int estimateSize() {
            return this.bytes.length;
        }

        @Override
        public int write(byte[] buffer, int offset) {
            System.arraycopy(this.bytes, 0, buffer, offset, this.bytes.length);
            return this.bytes.length;
        }

        @Override
        public void pack(Packer packer) throws IOException {
            packer.packBytes(this.bytes);
        }

        @Override
        public int getType() {
            return 4;
        }

        @Override
        public Object getObject() {
            return this.bytes;
        }

        @Override
        public LuaValue getLuaValue(LuaInstance instance) {
            return new LuaBytes(instance, this.bytes);
        }

        public String toString() {
            return Buffer.bytesToHexString(this.bytes);
        }
    }

    public static final class NullValue
    extends Value {
        @Override
        public int estimateSize() {
            return 0;
        }

        @Override
        public int write(byte[] buffer, int offset) {
            return 0;
        }

        @Override
        public void pack(Packer packer) throws IOException {
            packer.packNil();
        }

        @Override
        public int getType() {
            return 0;
        }

        @Override
        public Object getObject() {
            return null;
        }

        @Override
        public LuaValue getLuaValue(LuaInstance instance) {
            return LuaNil.NIL;
        }

        public String toString() {
            return null;
        }
    }
}

