/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.async;

import com.aerospike.client.AerospikeClient;
import com.aerospike.client.AerospikeException;
import com.aerospike.client.Bin;
import com.aerospike.client.Host;
import com.aerospike.client.Key;
import com.aerospike.client.Operation;
import com.aerospike.client.async.AsyncBatchExistsArrayExecutor;
import com.aerospike.client.async.AsyncBatchExistsSequenceExecutor;
import com.aerospike.client.async.AsyncBatchGetArrayExecutor;
import com.aerospike.client.async.AsyncBatchGetSequenceExecutor;
import com.aerospike.client.async.AsyncClientPolicy;
import com.aerospike.client.async.AsyncCluster;
import com.aerospike.client.async.AsyncDelete;
import com.aerospike.client.async.AsyncExists;
import com.aerospike.client.async.AsyncOperate;
import com.aerospike.client.async.AsyncRead;
import com.aerospike.client.async.AsyncReadHeader;
import com.aerospike.client.async.AsyncScanExecutor;
import com.aerospike.client.async.AsyncTouch;
import com.aerospike.client.async.AsyncWrite;
import com.aerospike.client.listener.DeleteListener;
import com.aerospike.client.listener.ExistsArrayListener;
import com.aerospike.client.listener.ExistsListener;
import com.aerospike.client.listener.ExistsSequenceListener;
import com.aerospike.client.listener.RecordArrayListener;
import com.aerospike.client.listener.RecordListener;
import com.aerospike.client.listener.RecordSequenceListener;
import com.aerospike.client.listener.WriteListener;
import com.aerospike.client.policy.Policy;
import com.aerospike.client.policy.ScanPolicy;
import com.aerospike.client.policy.WritePolicy;
import java.util.Arrays;
import java.util.HashSet;

public class AsyncClient
extends AerospikeClient {
    private final AsyncCluster cluster;

    public AsyncClient(String hostname, int port) throws AerospikeException {
        this(new AsyncClientPolicy(), new Host(hostname, port));
    }

    public AsyncClient(AsyncClientPolicy policy, String hostname, int port) throws AerospikeException {
        this(policy, new Host(hostname, port));
    }

    public AsyncClient(AsyncClientPolicy policy, Host ... hosts) throws AerospikeException {
        if (policy == null) {
            policy = new AsyncClientPolicy();
        }
        this.cluster = new AsyncCluster(policy, hosts);
        ((AerospikeClient)this).cluster = this.cluster;
        if (policy.failIfNotConnected && !this.cluster.isConnected()) {
            throw new AerospikeException.Connection("Failed to connect to host(s): " + Arrays.toString(hosts));
        }
    }

    public final void put(WritePolicy policy, WriteListener listener, Key key, Bin ... bins) throws AerospikeException {
        AsyncWrite command = new AsyncWrite(this.cluster, policy, listener, key, bins, Operation.Type.WRITE);
        command.execute();
    }

    public final void append(WritePolicy policy, WriteListener listener, Key key, Bin ... bins) throws AerospikeException {
        AsyncWrite command = new AsyncWrite(this.cluster, policy, listener, key, bins, Operation.Type.APPEND);
        command.execute();
    }

    public final void prepend(WritePolicy policy, WriteListener listener, Key key, Bin ... bins) throws AerospikeException {
        AsyncWrite command = new AsyncWrite(this.cluster, policy, listener, key, bins, Operation.Type.PREPEND);
        command.execute();
    }

    public final void add(WritePolicy policy, WriteListener listener, Key key, Bin ... bins) throws AerospikeException {
        AsyncWrite command = new AsyncWrite(this.cluster, policy, listener, key, bins, Operation.Type.ADD);
        command.execute();
    }

    public final void delete(WritePolicy policy, DeleteListener listener, Key key) throws AerospikeException {
        AsyncDelete command = new AsyncDelete(this.cluster, policy, listener, key);
        command.execute();
    }

    public final void touch(WritePolicy policy, WriteListener listener, Key key) throws AerospikeException {
        AsyncTouch command = new AsyncTouch(this.cluster, policy, listener, key);
        command.execute();
    }

    public final void exists(Policy policy, ExistsListener listener, Key key) throws AerospikeException {
        AsyncExists command = new AsyncExists(this.cluster, policy, listener, key);
        command.execute();
    }

    public final void exists(Policy policy, ExistsArrayListener listener, Key[] keys2) throws AerospikeException {
        new AsyncBatchExistsArrayExecutor(this.cluster, policy, keys2, listener);
    }

    public final void exists(Policy policy, ExistsSequenceListener listener, Key[] keys2) throws AerospikeException {
        new AsyncBatchExistsSequenceExecutor(this.cluster, policy, keys2, listener);
    }

    public final void get(Policy policy, RecordListener listener, Key key) throws AerospikeException {
        AsyncRead command = new AsyncRead(this.cluster, policy, listener, key, null);
        command.execute();
    }

    public final void get(Policy policy, RecordListener listener, Key key, String ... binNames) throws AerospikeException {
        AsyncRead command = new AsyncRead(this.cluster, policy, listener, key, binNames);
        command.execute();
    }

    public final void getHeader(Policy policy, RecordListener listener, Key key) throws AerospikeException {
        AsyncReadHeader command = new AsyncReadHeader(this.cluster, policy, listener, key);
        command.execute();
    }

    public final void get(Policy policy, RecordArrayListener listener, Key[] keys2) throws AerospikeException {
        new AsyncBatchGetArrayExecutor(this.cluster, policy, listener, keys2, null, 3);
    }

    public final void get(Policy policy, RecordSequenceListener listener, Key[] keys2) throws AerospikeException {
        new AsyncBatchGetSequenceExecutor(this.cluster, policy, listener, keys2, null, 3);
    }

    public final void get(Policy policy, RecordArrayListener listener, Key[] keys2, String ... binNames) throws AerospikeException {
        HashSet<String> names = AsyncClient.binNamesToHashSet(binNames);
        new AsyncBatchGetArrayExecutor(this.cluster, policy, listener, keys2, names, 1);
    }

    public final void get(Policy policy, RecordSequenceListener listener, Key[] keys2, String ... binNames) throws AerospikeException {
        HashSet<String> names = AsyncClient.binNamesToHashSet(binNames);
        new AsyncBatchGetSequenceExecutor(this.cluster, policy, listener, keys2, names, 1);
    }

    public final void getHeader(Policy policy, RecordArrayListener listener, Key[] keys2) throws AerospikeException {
        new AsyncBatchGetArrayExecutor(this.cluster, policy, listener, keys2, null, 33);
    }

    public final void getHeader(Policy policy, RecordSequenceListener listener, Key[] keys2) throws AerospikeException {
        new AsyncBatchGetSequenceExecutor(this.cluster, policy, listener, keys2, null, 33);
    }

    public final void operate(WritePolicy policy, RecordListener listener, Key key, Operation ... operations) throws AerospikeException {
        AsyncOperate command = new AsyncOperate(this.cluster, policy, listener, key, operations);
        command.execute();
    }

    public final void scanAll(ScanPolicy policy, RecordSequenceListener listener, String namespace, String setName, String ... binNames) throws AerospikeException {
        if (policy == null) {
            policy = new ScanPolicy();
        }
        policy.maxRetries = 0;
        new AsyncScanExecutor(this.cluster, policy, listener, namespace, setName, binNames);
    }
}

