/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.cluster;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.Host;
import com.aerospike.client.Info;
import com.aerospike.client.Log;
import com.aerospike.client.cluster.Connection;
import com.aerospike.client.util.Util;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.HashMap;

public final class NodeValidator {
    String name;
    Host[] aliases;
    InetSocketAddress address;
    boolean useNewInfo = true;

    public NodeValidator(Host host, int timeoutMillis) throws AerospikeException {
        this.setAliases(host);
        this.setAddress(timeoutMillis);
    }

    private void setAliases(Host host) throws AerospikeException {
        try {
            InetAddress[] addresses = InetAddress.getAllByName(host.name);
            int count = 0;
            this.aliases = new Host[addresses.length];
            for (InetAddress address : addresses) {
                this.aliases[count++] = new Host(address.getHostAddress(), host.port);
            }
        }
        catch (UnknownHostException uhe) {
            throw new AerospikeException.Connection("Invalid host: " + host);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setAddress(int timeoutMillis) throws AerospikeException {
        for (Host alias : this.aliases) {
            try {
                InetSocketAddress address = new InetSocketAddress(alias.name, alias.port);
                Connection conn = new Connection(address, timeoutMillis);
                try {
                    HashMap<String, String> map = Info.request(conn, "node", "build");
                    String nodeName = map.get("node");
                    if (nodeName == null) continue;
                    this.name = nodeName;
                    this.address = address;
                    String buildVersion = map.get("build");
                    if (buildVersion != null) {
                        try {
                            String[] vNumber = buildVersion.split("\\.");
                            int v1 = Integer.parseInt(vNumber[0]);
                            int v2 = Integer.parseInt(vNumber[1]);
                            int v3 = Integer.parseInt(vNumber[2]);
                            this.useNewInfo = v1 > 2 || v1 == 2 && (v2 > 6 || v2 == 6 && v3 >= 6);
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                    }
                    return;
                }
                finally {
                    conn.close();
                }
            }
            catch (Exception e) {
                if (!Log.debugEnabled()) continue;
                Log.debug("Alias " + alias + " failed: " + Util.getErrorMessage(e));
            }
        }
        throw new AerospikeException.Connection("Failed to connect to host aliases: " + Arrays.toString(this.aliases));
    }
}

