/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.cluster;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.Info;
import com.aerospike.client.cluster.Connection;
import com.aerospike.client.cluster.Node;
import com.aerospike.client.cluster.Partition;
import com.aerospike.client.command.Buffer;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicReferenceArray;

public final class PartitionTokenizerOld {
    private static final String ReplicasName = "replicas-write";
    protected final StringBuilder sb;
    protected final byte[] buffer;
    protected int length;
    protected int offset;

    public PartitionTokenizerOld(Connection conn) throws AerospikeException {
        Info info = new Info(conn, ReplicasName);
        this.length = info.getLength();
        if (this.length == 0) {
            throw new AerospikeException.Parse("replicas-write is empty");
        }
        this.buffer = info.getBuffer();
        this.offset = ReplicasName.length() + 1;
        this.sb = new StringBuilder(32);
    }

    public HashMap<String, AtomicReferenceArray<Node>> updatePartition(HashMap<String, AtomicReferenceArray<Node>> map, Node node) throws AerospikeException {
        Partition partition;
        boolean copied = false;
        while ((partition = this.getNext()) != null) {
            AtomicReferenceArray<Node> nodeArray = map.get(partition.namespace);
            if (nodeArray == null) {
                if (!copied) {
                    map = new HashMap<String, AtomicReferenceArray<Node>>(map);
                    copied = true;
                }
                nodeArray = new AtomicReferenceArray<Node>(new Node[4096]);
                map.put(partition.namespace, nodeArray);
            }
            nodeArray.lazySet(partition.partitionId, node);
        }
        return copied ? map : null;
    }

    private Partition getNext() throws AerospikeException {
        int begin = this.offset;
        while (this.offset < this.length) {
            if (this.buffer[this.offset] == 58) {
                byte b;
                String namespace = Buffer.utf8ToString(this.buffer, begin, this.offset - begin, this.sb).trim();
                if (namespace.length() <= 0 || namespace.length() >= 32) {
                    String response = this.getTruncatedResponse();
                    throw new AerospikeException.Parse("Invalid partition namespace " + namespace + ". Response=" + response);
                }
                begin = ++this.offset;
                while (this.offset < this.length && (b = this.buffer[this.offset]) != 59 && b != 10) {
                    ++this.offset;
                }
                if (this.offset == begin) {
                    String response = this.getTruncatedResponse();
                    throw new AerospikeException.Parse("Empty partition id for namespace " + namespace + ". Response=" + response);
                }
                int partitionId = Buffer.utf8DigitsToInt(this.buffer, begin, this.offset);
                if (partitionId < 0 || partitionId >= 4096) {
                    String response = this.getTruncatedResponse();
                    String partitionString = Buffer.utf8ToString(this.buffer, begin, this.offset - begin);
                    throw new AerospikeException.Parse("Invalid partition id " + partitionString + " for namespace " + namespace + ". Response=" + response);
                }
                begin = ++this.offset;
                return new Partition(namespace, partitionId);
            }
            ++this.offset;
        }
        return null;
    }

    private String getTruncatedResponse() {
        int max = this.length > 200 ? 200 : this.length;
        return Buffer.utf8ToString(this.buffer, 0, max);
    }
}

