/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.command;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.Key;
import com.aerospike.client.Record;
import com.aerospike.client.cluster.Cluster;
import com.aerospike.client.cluster.Connection;
import com.aerospike.client.command.Buffer;
import com.aerospike.client.command.SingleCommand;
import com.aerospike.client.policy.Policy;
import java.io.IOException;

public class ReadHeaderCommand
extends SingleCommand {
    private final Policy policy;
    private Record record;

    public ReadHeaderCommand(Cluster cluster, Policy policy, Key key) {
        super(cluster, key);
        this.policy = policy == null ? new Policy() : policy;
    }

    @Override
    protected Policy getPolicy() {
        return this.policy;
    }

    @Override
    protected void writeBuffer() throws AerospikeException {
        this.setReadHeader(this.key);
    }

    @Override
    protected void parseResult(Connection conn) throws AerospikeException, IOException {
        conn.readFully(this.dataBuffer, 30);
        int resultCode = this.dataBuffer[13] & 0xFF;
        if (resultCode == 0) {
            int generation = Buffer.bytesToInt(this.dataBuffer, 14);
            int expiration = Buffer.bytesToInt(this.dataBuffer, 18);
            this.record = new Record(null, null, generation, expiration);
        } else if (resultCode == 2) {
            this.record = null;
        } else {
            throw new AerospikeException(resultCode);
        }
        this.emptySocket(conn);
    }

    public Record getRecord() {
        return this.record;
    }
}

