/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.query;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.cluster.Node;
import com.aerospike.client.command.Buffer;
import com.aerospike.client.command.MultiCommand;
import com.aerospike.client.policy.Policy;
import com.aerospike.client.query.Filter;
import com.aerospike.client.query.Statement;
import com.aerospike.client.util.Packer;

public abstract class QueryCommand
extends MultiCommand {
    private final Policy policy;
    private final Statement statement;

    public QueryCommand(Node node, Policy policy, Statement statement) {
        super(node);
        this.policy = policy;
        this.statement = statement;
    }

    @Override
    protected final Policy getPolicy() {
        return this.policy;
    }

    @Override
    protected final void writeBuffer() throws AerospikeException {
        byte[] functionArgBuffer = null;
        int fieldCount = 0;
        int filterSize = 0;
        int binNameSize = 0;
        this.begin();
        if (this.statement.namespace != null) {
            this.dataOffset += Buffer.estimateSizeUtf8(this.statement.namespace) + 5;
            ++fieldCount;
        }
        if (this.statement.indexName != null) {
            this.dataOffset += Buffer.estimateSizeUtf8(this.statement.indexName) + 5;
            ++fieldCount;
        }
        if (this.statement.setName != null) {
            this.dataOffset += Buffer.estimateSizeUtf8(this.statement.setName) + 5;
            ++fieldCount;
        }
        if (this.statement.filters != null) {
            this.dataOffset += 5;
            ++filterSize;
            for (Filter filter : this.statement.filters) {
                filterSize += filter.estimateSize();
            }
            this.dataOffset += filterSize;
            ++fieldCount;
        } else {
            this.dataOffset += 7;
            ++fieldCount;
        }
        if (this.statement.binNames != null) {
            this.dataOffset += 5;
            ++binNameSize;
            for (String binName : this.statement.binNames) {
                binNameSize += Buffer.estimateSizeUtf8(binName) + 1;
            }
            this.dataOffset += binNameSize;
            ++fieldCount;
        }
        if (this.statement.taskId > 0) {
            this.dataOffset += 13;
            ++fieldCount;
        }
        if (this.statement.functionName != null) {
            this.dataOffset += 6;
            this.dataOffset += Buffer.estimateSizeUtf8(this.statement.packageName) + 5;
            this.dataOffset += Buffer.estimateSizeUtf8(this.statement.functionName) + 5;
            functionArgBuffer = this.statement.functionArgs.length > 0 ? Packer.pack(this.statement.functionArgs) : new byte[]{};
            this.dataOffset += 5 + functionArgBuffer.length;
            fieldCount += 4;
        }
        this.sizeBuffer();
        int readAttr = 1;
        this.writeHeader(readAttr, 0, fieldCount, 0);
        if (this.statement.namespace != null) {
            this.writeField(this.statement.namespace, 0);
        }
        if (this.statement.indexName != null) {
            this.writeField(this.statement.indexName, 21);
        }
        if (this.statement.setName != null) {
            this.writeField(this.statement.setName, 1);
        }
        if (this.statement.filters != null) {
            this.writeFieldHeader(filterSize, 22);
            this.dataBuffer[this.dataOffset++] = (byte)this.statement.filters.length;
            for (Filter filter : this.statement.filters) {
                this.dataOffset = filter.write(this.dataBuffer, this.dataOffset);
            }
        } else {
            this.writeFieldHeader(2, 8);
            byte priority = (byte)this.policy.priority.ordinal();
            priority = (byte)(priority << 4);
            this.dataBuffer[this.dataOffset++] = priority;
            this.dataBuffer[this.dataOffset++] = 100;
        }
        if (this.statement.binNames != null) {
            this.writeFieldHeader(binNameSize, 40);
            this.dataBuffer[this.dataOffset++] = (byte)this.statement.binNames.length;
            for (String binName : this.statement.binNames) {
                int len2 = Buffer.stringToUtf8(binName, this.dataBuffer, this.dataOffset + 1);
                this.dataBuffer[this.dataOffset] = (byte)len2;
                this.dataOffset += len2 + 1;
            }
        }
        if (this.statement.taskId > 0) {
            this.writeFieldHeader(8, 7);
            Buffer.longToBytes(this.statement.taskId, this.dataBuffer, this.dataOffset);
            this.dataOffset += 8;
        }
        if (this.statement.functionName != null) {
            this.writeFieldHeader(1, 33);
            this.dataBuffer[this.dataOffset++] = this.statement.returnData ? 1 : 2;
            this.writeField(this.statement.packageName, 30);
            this.writeField(this.statement.functionName, 31);
            this.writeField(functionArgBuffer, 32);
        }
        this.end();
    }
}

