/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.Bin;
import com.aerospike.client.Host;
import com.aerospike.client.Info;
import com.aerospike.client.Key;
import com.aerospike.client.Language;
import com.aerospike.client.Operation;
import com.aerospike.client.Record;
import com.aerospike.client.ScanCallback;
import com.aerospike.client.UserRoles;
import com.aerospike.client.Value;
import com.aerospike.client.cluster.Cluster;
import com.aerospike.client.cluster.Connection;
import com.aerospike.client.cluster.Node;
import com.aerospike.client.command.AdminCommand;
import com.aerospike.client.command.BatchExecutor;
import com.aerospike.client.command.Buffer;
import com.aerospike.client.command.DeleteCommand;
import com.aerospike.client.command.ExecuteCommand;
import com.aerospike.client.command.ExistsCommand;
import com.aerospike.client.command.OperateCommand;
import com.aerospike.client.command.ReadCommand;
import com.aerospike.client.command.ReadHeaderCommand;
import com.aerospike.client.command.ScanCommand;
import com.aerospike.client.command.ScanExecutor;
import com.aerospike.client.command.TouchCommand;
import com.aerospike.client.command.WriteCommand;
import com.aerospike.client.large.LargeList;
import com.aerospike.client.large.LargeMap;
import com.aerospike.client.large.LargeSet;
import com.aerospike.client.large.LargeStack;
import com.aerospike.client.policy.AdminPolicy;
import com.aerospike.client.policy.BatchPolicy;
import com.aerospike.client.policy.ClientPolicy;
import com.aerospike.client.policy.Policy;
import com.aerospike.client.policy.QueryPolicy;
import com.aerospike.client.policy.ScanPolicy;
import com.aerospike.client.policy.WritePolicy;
import com.aerospike.client.query.IndexType;
import com.aerospike.client.query.QueryAggregateExecutor;
import com.aerospike.client.query.QueryRecordExecutor;
import com.aerospike.client.query.RecordSet;
import com.aerospike.client.query.ResultSet;
import com.aerospike.client.query.ServerExecutor;
import com.aerospike.client.query.Statement;
import com.aerospike.client.task.ExecuteTask;
import com.aerospike.client.task.IndexTask;
import com.aerospike.client.task.RegisterTask;
import com.aerospike.client.util.Environment;
import com.aerospike.client.util.Util;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class AerospikeClient
implements Closeable {
    protected Cluster cluster;
    public final Policy readPolicyDefault;
    public final WritePolicy writePolicyDefault;
    public final ScanPolicy scanPolicyDefault;
    public final QueryPolicy queryPolicyDefault;
    public final BatchPolicy batchPolicyDefault;

    public AerospikeClient(String hostname, int port) throws AerospikeException {
        this(new ClientPolicy(), new Host(hostname, port));
    }

    public AerospikeClient(ClientPolicy policy, String hostname, int port) throws AerospikeException {
        this(policy, new Host(hostname, port));
    }

    public AerospikeClient(ClientPolicy policy, Host ... hosts) throws AerospikeException {
        if (policy == null) {
            policy = new ClientPolicy();
        }
        this.readPolicyDefault = policy.readPolicyDefault;
        this.writePolicyDefault = policy.writePolicyDefault;
        this.scanPolicyDefault = policy.scanPolicyDefault;
        this.queryPolicyDefault = policy.queryPolicyDefault;
        this.batchPolicyDefault = policy.batchPolicyDefault;
        this.cluster = new Cluster(policy, hosts);
        this.cluster.initTendThread(policy.failIfNotConnected);
    }

    protected AerospikeClient(ClientPolicy policy) {
        if (policy != null) {
            this.readPolicyDefault = policy.readPolicyDefault;
            this.writePolicyDefault = policy.writePolicyDefault;
            this.scanPolicyDefault = policy.scanPolicyDefault;
            this.queryPolicyDefault = policy.queryPolicyDefault;
            this.batchPolicyDefault = policy.batchPolicyDefault;
        } else {
            this.readPolicyDefault = new Policy();
            this.writePolicyDefault = new WritePolicy();
            this.scanPolicyDefault = new ScanPolicy();
            this.queryPolicyDefault = new QueryPolicy();
            this.batchPolicyDefault = new BatchPolicy();
        }
    }

    @Override
    public final void close() {
        this.cluster.close();
    }

    public final boolean isConnected() {
        return this.cluster.isConnected();
    }

    public final Node[] getNodes() {
        return this.cluster.getNodes();
    }

    public final List<String> getNodeNames() {
        Node[] nodes = this.cluster.getNodes();
        ArrayList<String> names = new ArrayList<String>(nodes.length);
        for (Node node : nodes) {
            names.add(node.getName());
        }
        return names;
    }

    public final Node getNode(String nodeName) throws AerospikeException.InvalidNode {
        return this.cluster.getNode(nodeName);
    }

    public final void put(WritePolicy policy, Key key, Bin ... bins) throws AerospikeException {
        if (policy == null) {
            policy = this.writePolicyDefault;
        }
        WriteCommand command = new WriteCommand(this.cluster, policy, key, bins, Operation.Type.WRITE);
        command.execute();
    }

    public final void append(WritePolicy policy, Key key, Bin ... bins) throws AerospikeException {
        if (policy == null) {
            policy = this.writePolicyDefault;
        }
        WriteCommand command = new WriteCommand(this.cluster, policy, key, bins, Operation.Type.APPEND);
        command.execute();
    }

    public final void prepend(WritePolicy policy, Key key, Bin ... bins) throws AerospikeException {
        if (policy == null) {
            policy = this.writePolicyDefault;
        }
        WriteCommand command = new WriteCommand(this.cluster, policy, key, bins, Operation.Type.PREPEND);
        command.execute();
    }

    public final void add(WritePolicy policy, Key key, Bin ... bins) throws AerospikeException {
        if (policy == null) {
            policy = this.writePolicyDefault;
        }
        WriteCommand command = new WriteCommand(this.cluster, policy, key, bins, Operation.Type.ADD);
        command.execute();
    }

    public final boolean delete(WritePolicy policy, Key key) throws AerospikeException {
        if (policy == null) {
            policy = this.writePolicyDefault;
        }
        DeleteCommand command = new DeleteCommand(this.cluster, policy, key);
        command.execute();
        return command.existed();
    }

    public final void touch(WritePolicy policy, Key key) throws AerospikeException {
        if (policy == null) {
            policy = this.writePolicyDefault;
        }
        TouchCommand command = new TouchCommand(this.cluster, policy, key);
        command.execute();
    }

    public final boolean exists(Policy policy, Key key) throws AerospikeException {
        if (policy == null) {
            policy = this.readPolicyDefault;
        }
        ExistsCommand command = new ExistsCommand(this.cluster, policy, key);
        command.execute();
        return command.exists();
    }

    @Deprecated
    public final boolean[] exists(Policy policy, Key[] keys2) throws AerospikeException {
        BatchPolicy batchPolicy = policy == null ? this.batchPolicyDefault : new BatchPolicy(policy);
        return this.exists(batchPolicy, keys2);
    }

    public final boolean[] exists(BatchPolicy policy, Key[] keys2) throws AerospikeException {
        if (policy == null) {
            policy = this.batchPolicyDefault;
        }
        boolean[] existsArray = new boolean[keys2.length];
        BatchExecutor.execute(this.cluster, policy, keys2, existsArray, null, null, 33);
        return existsArray;
    }

    public final Record get(Policy policy, Key key) throws AerospikeException {
        if (policy == null) {
            policy = this.readPolicyDefault;
        }
        ReadCommand command = new ReadCommand(this.cluster, policy, key, null);
        command.execute();
        return command.getRecord();
    }

    public final Record get(Policy policy, Key key, String ... binNames) throws AerospikeException {
        if (policy == null) {
            policy = this.readPolicyDefault;
        }
        ReadCommand command = new ReadCommand(this.cluster, policy, key, binNames);
        command.execute();
        return command.getRecord();
    }

    public final Record getHeader(Policy policy, Key key) throws AerospikeException {
        if (policy == null) {
            policy = this.readPolicyDefault;
        }
        ReadHeaderCommand command = new ReadHeaderCommand(this.cluster, policy, key);
        command.execute();
        return command.getRecord();
    }

    @Deprecated
    public final Record[] get(Policy policy, Key[] keys2) throws AerospikeException {
        BatchPolicy batchPolicy = policy == null ? this.batchPolicyDefault : new BatchPolicy(policy);
        return this.get(batchPolicy, keys2);
    }

    public final Record[] get(BatchPolicy policy, Key[] keys2) throws AerospikeException {
        if (policy == null) {
            policy = this.batchPolicyDefault;
        }
        Record[] records = new Record[keys2.length];
        BatchExecutor.execute(this.cluster, policy, keys2, null, records, null, 3);
        return records;
    }

    @Deprecated
    public final Record[] get(Policy policy, Key[] keys2, String ... binNames) throws AerospikeException {
        BatchPolicy batchPolicy = policy == null ? this.batchPolicyDefault : new BatchPolicy(policy);
        return this.get(batchPolicy, keys2, binNames);
    }

    public final Record[] get(BatchPolicy policy, Key[] keys2, String ... binNames) throws AerospikeException {
        if (policy == null) {
            policy = this.batchPolicyDefault;
        }
        Record[] records = new Record[keys2.length];
        HashSet<String> names = AerospikeClient.binNamesToHashSet(binNames);
        BatchExecutor.execute(this.cluster, policy, keys2, null, records, names, 1);
        return records;
    }

    @Deprecated
    public final Record[] getHeader(Policy policy, Key[] keys2) throws AerospikeException {
        BatchPolicy batchPolicy = policy == null ? this.batchPolicyDefault : new BatchPolicy(policy);
        return this.getHeader(batchPolicy, keys2);
    }

    public final Record[] getHeader(BatchPolicy policy, Key[] keys2) throws AerospikeException {
        if (policy == null) {
            policy = this.batchPolicyDefault;
        }
        Record[] records = new Record[keys2.length];
        BatchExecutor.execute(this.cluster, policy, keys2, null, records, null, 33);
        return records;
    }

    public final Record operate(WritePolicy policy, Key key, Operation ... operations) throws AerospikeException {
        if (policy == null) {
            policy = this.writePolicyDefault;
        }
        OperateCommand command = new OperateCommand(this.cluster, policy, key, operations);
        command.execute();
        return command.getRecord();
    }

    public final void scanAll(ScanPolicy policy, String namespace, String setName, ScanCallback callback, String ... binNames) throws AerospikeException {
        if (policy == null) {
            policy = this.scanPolicyDefault;
        }
        policy.maxRetries = 0;
        Node[] nodes = this.cluster.getNodes();
        if (nodes.length == 0) {
            throw new AerospikeException(11, "Scan failed because cluster is empty.");
        }
        if (policy.concurrentNodes) {
            ScanExecutor executor = new ScanExecutor(this.cluster, nodes, policy, namespace, setName, callback, binNames);
            executor.scanParallel();
        } else {
            for (Node node : nodes) {
                this.scanNode(policy, node, namespace, setName, callback, binNames);
            }
        }
    }

    public final void scanNode(ScanPolicy policy, String nodeName, String namespace, String setName, ScanCallback callback, String ... binNames) throws AerospikeException {
        Node node = this.cluster.getNode(nodeName);
        this.scanNode(policy, node, namespace, setName, callback, binNames);
    }

    public final void scanNode(ScanPolicy policy, Node node, String namespace, String setName, ScanCallback callback, String ... binNames) throws AerospikeException {
        if (policy == null) {
            policy = this.scanPolicyDefault;
        }
        policy.maxRetries = 0;
        ScanCommand command = new ScanCommand(node, policy, namespace, setName, callback, binNames);
        command.execute();
    }

    public final LargeList getLargeList(Policy policy, Key key, String binName, String userModule) {
        return new LargeList(this, policy, key, binName, userModule);
    }

    public final LargeMap getLargeMap(Policy policy, Key key, String binName, String userModule) {
        return new LargeMap(this, policy, key, binName, userModule);
    }

    public final LargeSet getLargeSet(Policy policy, Key key, String binName, String userModule) {
        return new LargeSet(this, policy, key, binName, userModule);
    }

    public final LargeStack getLargeStack(Policy policy, Key key, String binName, String userModule) {
        return new LargeStack(this, policy, key, binName, userModule);
    }

    public final RegisterTask register(Policy policy, String clientPath, String serverPath, Language language) throws AerospikeException {
        String content = Util.readFileEncodeBase64(clientPath);
        StringBuilder sb = new StringBuilder(serverPath.length() + content.length() + 100);
        sb.append("udf-put:filename=");
        sb.append(serverPath);
        sb.append(";content=");
        sb.append(content);
        sb.append(";content-len=");
        sb.append(content.length());
        sb.append(";udf-type=");
        sb.append((Object)language);
        sb.append(";");
        String command = sb.toString();
        Node node = this.cluster.getRandomNode();
        int timeout = policy == null ? 0 : policy.timeout;
        Connection conn = node.getConnection(timeout);
        try {
            Info info = new Info(conn, command);
            Info.NameValueParser parser = info.getNameValueParser();
            String error = null;
            String file = null;
            String line = null;
            String message = null;
            while (parser.next()) {
                String name = parser.getName();
                if (name.equals("error")) {
                    error = parser.getValue();
                    continue;
                }
                if (name.equals("file")) {
                    file = parser.getValue();
                    continue;
                }
                if (name.equals("line")) {
                    line = parser.getValue();
                    continue;
                }
                if (!name.equals("message")) continue;
                message = parser.getStringBase64();
            }
            if (error != null) {
                throw new AerospikeException("Registration failed: " + error + Environment.Newline + "File: " + file + Environment.Newline + "Line: " + line + Environment.Newline + "Message: " + message);
            }
            node.putConnection(conn);
            return new RegisterTask(this.cluster, serverPath);
        }
        catch (RuntimeException re) {
            conn.close();
            throw re;
        }
    }

    public final Object execute(Policy policy, Key key, String packageName, String functionName, Value ... args) throws AerospikeException {
        if (policy == null) {
            policy = this.readPolicyDefault;
        }
        ExecuteCommand command = new ExecuteCommand(this.cluster, policy, key, packageName, functionName, args);
        command.execute();
        Record record = command.getRecord();
        if (record == null || record.bins == null) {
            return null;
        }
        Map<String, Object> map = record.bins;
        Object obj = map.get("SUCCESS");
        if (obj != null) {
            return obj;
        }
        if (map.containsKey("SUCCESS")) {
            return null;
        }
        obj = map.get("FAILURE");
        if (obj != null) {
            throw new AerospikeException(obj.toString());
        }
        throw new AerospikeException("Invalid UDF return value");
    }

    public final ExecuteTask execute(Policy policy, Statement statement, String packageName, String functionName, Value ... functionArgs) throws AerospikeException {
        if (policy == null) {
            policy = this.readPolicyDefault;
        }
        new ServerExecutor(this.cluster, policy, statement, packageName, functionName, functionArgs);
        return new ExecuteTask(this.cluster, statement);
    }

    public final RecordSet query(QueryPolicy policy, Statement statement) throws AerospikeException {
        if (policy == null) {
            policy = this.queryPolicyDefault;
        }
        QueryRecordExecutor executor = new QueryRecordExecutor(this.cluster, policy, statement, null);
        executor.execute();
        return executor.getRecordSet();
    }

    public final RecordSet queryNode(QueryPolicy policy, Statement statement, Node node) throws AerospikeException {
        if (policy == null) {
            policy = this.queryPolicyDefault;
        }
        QueryRecordExecutor executor = new QueryRecordExecutor(this.cluster, policy, statement, node);
        executor.execute();
        return executor.getRecordSet();
    }

    public final ResultSet queryAggregate(QueryPolicy policy, Statement statement, String packageName, String functionName, Value ... functionArgs) throws AerospikeException {
        if (policy == null) {
            policy = this.queryPolicyDefault;
        }
        QueryAggregateExecutor executor = new QueryAggregateExecutor(this.cluster, policy, statement, packageName, functionName, functionArgs);
        executor.execute();
        return executor.getResultSet();
    }

    public final IndexTask createIndex(Policy policy, String namespace, String setName, String indexName, String binName, IndexType indexType) throws AerospikeException {
        StringBuilder sb = new StringBuilder(500);
        sb.append("sindex-create:ns=");
        sb.append(namespace);
        if (setName != null && setName.length() > 0) {
            sb.append(";set=");
            sb.append(setName);
        }
        sb.append(";indexname=");
        sb.append(indexName);
        sb.append(";numbins=1");
        sb.append(";indexdata=");
        sb.append(binName);
        sb.append(",");
        sb.append((Object)indexType);
        sb.append(";priority=normal");
        String response = this.sendInfoCommand(policy, sb.toString());
        if (response.equalsIgnoreCase("OK")) {
            return new IndexTask(this.cluster, namespace, indexName);
        }
        if (response.startsWith("FAIL:200")) {
            return new IndexTask();
        }
        throw new AerospikeException("Create index failed: " + response);
    }

    public final void dropIndex(Policy policy, String namespace, String setName, String indexName) throws AerospikeException {
        StringBuilder sb = new StringBuilder(500);
        sb.append("sindex-delete:ns=");
        sb.append(namespace);
        if (setName != null && setName.length() > 0) {
            sb.append(";set=");
            sb.append(setName);
        }
        sb.append(";indexname=");
        sb.append(indexName);
        String response = this.sendInfoCommand(policy, sb.toString());
        if (response.equalsIgnoreCase("OK")) {
            return;
        }
        if (response.startsWith("FAIL:201")) {
            return;
        }
        throw new AerospikeException("Drop index failed: " + response);
    }

    public final void createUser(AdminPolicy policy, String user, String password, List<String> roles) throws AerospikeException {
        String hash = AdminCommand.hashPassword(password);
        AdminCommand command = new AdminCommand();
        command.createUser(this.cluster, policy, user, hash, roles);
    }

    public final void dropUser(AdminPolicy policy, String user) throws AerospikeException {
        AdminCommand command = new AdminCommand();
        command.dropUser(this.cluster, policy, user);
    }

    public final void changePassword(AdminPolicy policy, String user, String password) throws AerospikeException {
        if (this.cluster.getUser() == null) {
            throw new AerospikeException("Invalid user");
        }
        String hash = AdminCommand.hashPassword(password);
        AdminCommand command = new AdminCommand();
        byte[] userBytes = Buffer.stringToUtf8(user);
        if (Arrays.equals(userBytes, this.cluster.getUser())) {
            command.changePassword(this.cluster, policy, userBytes, hash);
        } else {
            command.setPassword(this.cluster, policy, userBytes, hash);
        }
        this.cluster.changePassword(userBytes, hash);
    }

    public final void grantRoles(AdminPolicy policy, String user, List<String> roles) throws AerospikeException {
        AdminCommand command = new AdminCommand();
        command.grantRoles(this.cluster, policy, user, roles);
    }

    public final void revokeRoles(AdminPolicy policy, String user, List<String> roles) throws AerospikeException {
        AdminCommand command = new AdminCommand();
        command.revokeRoles(this.cluster, policy, user, roles);
    }

    public final void replaceRoles(AdminPolicy policy, String user, List<String> roles) throws AerospikeException {
        AdminCommand command = new AdminCommand();
        command.replaceRoles(this.cluster, policy, user, roles);
    }

    public final UserRoles queryUser(AdminPolicy policy, String user) throws AerospikeException {
        AdminCommand command = new AdminCommand();
        return command.queryUser(this.cluster, policy, user);
    }

    public final List<UserRoles> queryUsers(AdminPolicy policy) throws AerospikeException {
        AdminCommand command = new AdminCommand();
        return command.queryUsers(this.cluster, policy);
    }

    protected static HashSet<String> binNamesToHashSet(String[] binNames) {
        HashSet<String> names = new HashSet<String>(binNames.length);
        for (String binName : binNames) {
            names.add(binName);
        }
        return names;
    }

    private String sendInfoCommand(Policy policy, String command) throws AerospikeException {
        Info info;
        Node node = this.cluster.getRandomNode();
        int timeout = policy == null ? 0 : policy.timeout;
        Connection conn = node.getConnection(timeout);
        try {
            info = new Info(conn, command);
            node.putConnection(conn);
        }
        catch (RuntimeException re) {
            conn.close();
            throw re;
        }
        return info.getValue();
    }
}

