/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.async;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.async.AsyncCluster;
import com.aerospike.client.async.AsyncConnection;
import com.aerospike.client.async.AsyncNode;
import com.aerospike.client.command.AdminCommand;
import com.aerospike.client.command.Command;
import com.aerospike.client.policy.Policy;
import com.aerospike.client.util.ThreadLocalData;
import com.aerospike.client.util.Util;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicBoolean;

public abstract class AsyncCommand
extends Command
implements Runnable {
    protected AsyncConnection conn;
    protected ByteBuffer byteBuffer;
    protected final AsyncCluster cluster;
    protected AsyncNode node;
    private final AtomicBoolean complete = new AtomicBoolean();
    private long limit;
    protected int timeout;
    private int iteration;
    protected boolean inAuthenticate;
    protected boolean inHeader = true;

    public AsyncCommand(AsyncCluster cluster) {
        this.cluster = cluster;
    }

    public void execute() throws AerospikeException {
        Policy policy = this.getPolicy();
        this.timeout = policy.timeout;
        if (this.timeout > 0) {
            this.limit = System.currentTimeMillis() + (long)this.timeout;
        }
        this.byteBuffer = this.cluster.getByteBuffer();
        this.executeCommand();
    }

    public void executeCommand() throws AerospikeException {
        block9: {
            if (this.complete.get()) {
                return;
            }
            try {
                this.node = this.getNode();
                this.conn = this.node.getAsyncConnection();
                if (this.conn == null) {
                    this.conn = new AsyncConnection(this.node.getAddress(), this.cluster);
                    if (this.cluster.getUser() != null) {
                        this.inAuthenticate = true;
                        this.dataBuffer = ThreadLocalData.getBuffer();
                        AdminCommand command = new AdminCommand(this.dataBuffer);
                        this.dataOffset = command.setAuthenticate(this.cluster.getUser(), this.cluster.getPassword());
                        this.byteBuffer.clear();
                        this.byteBuffer.put(this.dataBuffer, 0, this.dataOffset);
                        this.byteBuffer.flip();
                        this.conn.execute(this);
                        return;
                    }
                }
                this.sendCommand();
            }
            catch (AerospikeException.InvalidNode ai) {
                if (!this.retryOnInit()) {
                    throw ai;
                }
            }
            catch (AerospikeException.Connection ce) {
                if (!this.retryOnInit()) {
                    throw ce;
                }
            }
            catch (Exception e) {
                if (this.failOnApplicationInit()) break block9;
                throw new AerospikeException(e);
            }
        }
    }

    protected void sendCommand() throws AerospikeException {
        this.writeBuffer();
        if (this.dataOffset > this.byteBuffer.capacity()) {
            this.byteBuffer = ByteBuffer.allocateDirect(this.dataOffset);
        }
        this.byteBuffer.clear();
        this.byteBuffer.put(this.dataBuffer, 0, this.dataOffset);
        this.byteBuffer.flip();
        this.conn.execute(this);
    }

    protected void processAuthenticate() throws AerospikeException {
        this.inAuthenticate = false;
        this.inHeader = true;
        int resultCode = this.byteBuffer.get(1) & 0xFF;
        if (resultCode != 0) {
            throw new AerospikeException(resultCode);
        }
        this.sendCommand();
    }

    private boolean retryOnInit() throws AerospikeException {
        if (this.complete.get()) {
            return true;
        }
        Policy policy = this.getPolicy();
        if (++this.iteration > policy.maxRetries) {
            return this.failOnNetworkInit();
        }
        if (this.limit > 0L && System.currentTimeMillis() + (long)policy.sleepBetweenRetries > this.limit) {
            return this.failOnNetworkInit();
        }
        this.resetConnection();
        if (policy.sleepBetweenRetries > 0) {
            Util.sleep(policy.sleepBetweenRetries);
        }
        this.executeCommand();
        return true;
    }

    protected final void write() throws IOException {
        this.conn.write(this.byteBuffer);
    }

    protected final void retryAfterInit(AerospikeException ae) {
        if (this.complete.get()) {
            return;
        }
        Policy policy = this.getPolicy();
        if (++this.iteration > policy.maxRetries) {
            this.failOnNetworkError(ae);
            return;
        }
        if (this.limit > 0L && System.currentTimeMillis() + (long)policy.sleepBetweenRetries > this.limit) {
            this.failOnNetworkError(ae);
            return;
        }
        this.resetConnection();
        if (policy.sleepBetweenRetries > 0) {
            Util.sleep(policy.sleepBetweenRetries);
        }
        try {
            this.executeCommand();
        }
        catch (Exception e) {
            this.onFailure(ae);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetConnection() {
        if (this.limit > 0L) {
            AsyncCommand asyncCommand = this;
            synchronized (asyncCommand) {
                if (this.conn != null) {
                    this.conn.close();
                    this.conn = null;
                }
            }
        } else if (this.conn != null) {
            this.conn.close();
            this.conn = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final boolean checkTimeout() {
        if (this.complete.get()) {
            return false;
        }
        if (this.limit > 0L && System.currentTimeMillis() > this.limit) {
            if (this.complete.compareAndSet(false, true)) {
                AsyncCommand asyncCommand = this;
                synchronized (asyncCommand) {
                    if (this.conn != null) {
                        this.conn.close();
                    }
                }
                this.failOnClientTimeout();
            }
            return false;
        }
        return true;
    }

    @Override
    public void run() {
        try {
            this.read();
            if (!this.complete.get()) {
                this.conn.setReadable();
            }
        }
        catch (AerospikeException.Connection ac) {
            this.retryAfterInit(ac);
        }
        catch (AerospikeException ae) {
            this.failOnApplicationError(ae);
        }
        catch (IOException ioe) {
            this.retryAfterInit(new AerospikeException(ioe));
        }
        catch (Exception e) {
            this.failOnApplicationError(new AerospikeException(e));
        }
    }

    protected final void finish() {
        if (this.complete.compareAndSet(false, true)) {
            this.conn.unregister();
            this.conn.updateLastUsed();
            this.node.putAsyncConnection(this.conn);
            this.cluster.putByteBuffer(this.byteBuffer);
            this.onSuccess();
        }
    }

    private boolean failOnNetworkInit() {
        if (this.complete.compareAndSet(false, true)) {
            this.closeOnNetworkError();
            return false;
        }
        return true;
    }

    private boolean failOnApplicationInit() {
        if (this.complete.compareAndSet(false, true)) {
            this.close();
            return false;
        }
        return true;
    }

    private void failOnNetworkError(AerospikeException ae) {
        if (this.complete.compareAndSet(false, true)) {
            this.closeOnNetworkError();
            this.onFailure(ae);
        }
    }

    protected final void failOnApplicationError(AerospikeException ae) {
        if (this.complete.compareAndSet(false, true)) {
            if (ae.keepConnection()) {
                this.conn.unregister();
                this.conn.updateLastUsed();
                this.node.putAsyncConnection(this.conn);
                this.cluster.putByteBuffer(this.byteBuffer);
            } else {
                this.close();
            }
            this.onFailure(ae);
        }
    }

    private void failOnClientTimeout() {
        this.closeOnNetworkError();
        this.onFailure(new AerospikeException.Timeout());
    }

    private void closeOnNetworkError() {
        this.close();
    }

    private void close() {
        if (this.conn != null && this.conn.isConnected()) {
            this.conn.close();
        }
        this.cluster.putByteBuffer(this.byteBuffer);
    }

    protected abstract AsyncNode getNode() throws AerospikeException.InvalidNode;

    protected abstract void read() throws AerospikeException, IOException;

    protected abstract void onSuccess();

    protected abstract void onFailure(AerospikeException var1);
}

