/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.async;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.Key;
import com.aerospike.client.Record;
import com.aerospike.client.async.AsyncCluster;
import com.aerospike.client.async.AsyncSingleCommand;
import com.aerospike.client.command.Buffer;
import com.aerospike.client.listener.RecordListener;
import com.aerospike.client.policy.Policy;
import com.aerospike.client.util.ThreadLocalData;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AsyncRead
extends AsyncSingleCommand {
    private final Policy policy;
    private final RecordListener listener;
    private final String[] binNames;
    private Record record;

    public AsyncRead(AsyncCluster cluster, Policy policy, RecordListener listener, Key key, String[] binNames) {
        super(cluster, key);
        this.policy = policy;
        this.listener = listener;
        this.binNames = binNames;
    }

    @Override
    protected Policy getPolicy() {
        return this.policy;
    }

    @Override
    protected void writeBuffer() throws AerospikeException {
        this.setRead(this.key, this.binNames);
    }

    @Override
    protected final void parseResult(ByteBuffer byteBuffer) throws AerospikeException {
        this.dataBuffer = ThreadLocalData.getBuffer();
        if (this.receiveSize > this.dataBuffer.length) {
            this.dataBuffer = ThreadLocalData.resizeBuffer(this.receiveSize);
        }
        byteBuffer.position(0);
        byteBuffer.get(this.dataBuffer, 0, this.receiveSize);
        int resultCode = this.dataBuffer[5] & 0xFF;
        int generation = Buffer.bytesToInt(this.dataBuffer, 6);
        int expiration = Buffer.bytesToInt(this.dataBuffer, 10);
        int fieldCount = Buffer.bytesToShort(this.dataBuffer, 18);
        int opCount = Buffer.bytesToShort(this.dataBuffer, 20);
        this.dataOffset = 22;
        if (resultCode == 0) {
            this.record = opCount == 0 ? new Record(null, null, generation, expiration) : this.parseRecord(opCount, fieldCount, generation, expiration);
        } else if (resultCode == 2) {
            this.record = null;
        } else {
            throw new AerospikeException(resultCode);
        }
    }

    private final Record parseRecord(int opCount, int fieldCount, int generation, int expiration) throws AerospikeException {
        int i;
        HashMap<String, Object> bins = null;
        ArrayList<HashMap<String, Object>> duplicates = null;
        if (fieldCount != 0) {
            for (i = 0; i < fieldCount; ++i) {
                int fieldSize = Buffer.bytesToInt(this.dataBuffer, this.dataOffset);
                this.dataOffset += 4 + fieldSize;
            }
        }
        for (i = 0; i < opCount; ++i) {
            int opSize = Buffer.bytesToInt(this.dataBuffer, this.dataOffset);
            byte particleType = this.dataBuffer[this.dataOffset + 5];
            int version = this.dataBuffer[this.dataOffset + 6];
            byte nameSize = this.dataBuffer[this.dataOffset + 7];
            String name = Buffer.utf8ToString(this.dataBuffer, this.dataOffset + 8, nameSize);
            this.dataOffset += 8 + nameSize;
            int particleBytesSize = opSize - (4 + nameSize);
            Object value = null;
            value = Buffer.bytesToParticle(particleType, this.dataBuffer, this.dataOffset, particleBytesSize);
            this.dataOffset += particleBytesSize;
            Map<String, Object> vmap = null;
            if (version > 0 || duplicates != null) {
                int j;
                if (duplicates == null) {
                    duplicates = new ArrayList<HashMap<String, Object>>(4);
                    duplicates.add(bins);
                    bins = null;
                    for (j = 0; j < version; ++j) {
                        duplicates.add(null);
                    }
                } else {
                    for (j = duplicates.size(); j < version + 1; ++j) {
                        duplicates.add(null);
                    }
                }
                if ((vmap = (Map)duplicates.get(version)) == null) {
                    vmap = new HashMap();
                    duplicates.set(version, (HashMap<String, Object>)vmap);
                }
            } else {
                if (bins == null) {
                    bins = new HashMap<String, Object>();
                }
                vmap = bins;
            }
            vmap.put(name, value);
        }
        if (duplicates != null) {
            while (duplicates.remove(null)) {
            }
        }
        return new Record(bins, (List<Map<String, Object>>)duplicates, generation, expiration);
    }

    @Override
    protected final void onSuccess() {
        if (this.listener != null) {
            this.listener.onSuccess(this.key, this.record);
        }
    }

    @Override
    protected final void onFailure(AerospikeException e) {
        if (this.listener != null) {
            this.listener.onFailure(e);
        }
    }
}

