/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.cluster;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.Log;
import com.aerospike.client.util.Util;
import java.io.Closeable;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;

public final class Connection
implements Closeable {
    private final Socket socket;
    private final InputStream in;
    private final OutputStream out;
    private final long maxSocketIdleMillis;
    private long lastUsed;

    public Connection(InetSocketAddress address, int timeoutMillis) throws AerospikeException.Connection {
        this(address, timeoutMillis, 14);
    }

    public Connection(InetSocketAddress address, int timeoutMillis, int maxSocketIdleSeconds) throws AerospikeException.Connection {
        this.maxSocketIdleMillis = (long)maxSocketIdleSeconds * 1000L;
        try {
            this.socket = new Socket();
            this.socket.setTcpNoDelay(true);
            if (timeoutMillis > 0) {
                this.socket.setSoTimeout(timeoutMillis);
            } else {
                timeoutMillis = 2000;
            }
            this.socket.connect(address, timeoutMillis);
            this.in = this.socket.getInputStream();
            this.out = this.socket.getOutputStream();
            this.lastUsed = System.currentTimeMillis();
        }
        catch (Exception e) {
            throw new AerospikeException.Connection(e);
        }
    }

    public void write(byte[] buffer, int length) throws IOException {
        int len2;
        int max = length;
        for (int pos = 0; pos < max; pos += len2) {
            len2 = max - pos;
            if (len2 > 8192) {
                len2 = 8192;
            }
            this.out.write(buffer, pos, len2);
        }
    }

    public void readFully(byte[] buffer, int length) throws IOException {
        int count;
        for (int pos = 0; pos < length; pos += count) {
            count = this.in.read(buffer, pos, length - pos);
            if (count >= 0) continue;
            throw new EOFException();
        }
    }

    public boolean isConnected() {
        return this.socket.isConnected();
    }

    public boolean isValid() {
        return this.socket.isConnected() && System.currentTimeMillis() - this.lastUsed <= this.maxSocketIdleMillis;
    }

    public void setTimeout(int timeout) throws SocketException {
        this.socket.setSoTimeout(timeout);
    }

    public InputStream getInputStream() {
        return this.in;
    }

    public void updateLastUsed() {
        this.lastUsed = System.currentTimeMillis();
    }

    @Override
    public void close() {
        block2: {
            try {
                this.in.close();
                this.out.close();
                this.socket.close();
            }
            catch (Exception e) {
                if (!Log.debugEnabled()) break block2;
                Log.debug("Error closing socket: " + Util.getErrorMessage(e));
            }
        }
    }
}

