/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.command;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.Key;
import com.aerospike.client.Log;
import com.aerospike.client.Record;
import com.aerospike.client.cluster.Node;
import com.aerospike.client.command.BatchNode;
import com.aerospike.client.command.Buffer;
import com.aerospike.client.command.MultiCommand;
import com.aerospike.client.policy.Policy;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public final class BatchCommandGet
extends MultiCommand {
    private final BatchNode.BatchNamespace batch;
    private final Policy policy;
    private final Key[] keys;
    private final HashSet<String> binNames;
    private final Record[] records;
    private final int readAttr;
    private int index;

    public BatchCommandGet(Node node, BatchNode.BatchNamespace batch, Policy policy, Key[] keys2, HashSet<String> binNames, Record[] records, int readAttr) {
        super(node);
        this.batch = batch;
        this.policy = policy;
        this.keys = keys2;
        this.binNames = binNames;
        this.records = records;
        this.readAttr = readAttr;
    }

    @Override
    protected Policy getPolicy() {
        return this.policy;
    }

    @Override
    protected void writeBuffer() throws AerospikeException {
        this.setBatchGet(this.keys, this.batch, this.binNames, this.readAttr);
    }

    @Override
    protected boolean parseRecordResults(int receiveSize) throws AerospikeException, IOException {
        this.dataOffset = 0;
        while (this.dataOffset < receiveSize) {
            this.readBytes(22);
            int resultCode = this.dataBuffer[5] & 0xFF;
            if (resultCode != 0 && resultCode != 2) {
                throw new AerospikeException(resultCode);
            }
            byte info3 = this.dataBuffer[3];
            if ((info3 & 1) == 1) {
                return false;
            }
            int generation = Buffer.bytesToInt(this.dataBuffer, 6);
            int expiration = Buffer.bytesToInt(this.dataBuffer, 10);
            int fieldCount = Buffer.bytesToShort(this.dataBuffer, 18);
            int opCount = Buffer.bytesToShort(this.dataBuffer, 20);
            Key key = this.parseKey(fieldCount);
            int offset = this.batch.offsets[this.index++];
            if (Arrays.equals(key.digest, this.keys[offset].digest)) {
                if (resultCode != 0) continue;
                this.records[offset] = this.parseRecord(opCount, generation, expiration);
                continue;
            }
            if (!Log.warnEnabled()) continue;
            Log.warn("Unexpected batch key returned: " + key.namespace + ',' + Buffer.bytesToHexString(key.digest) + ',' + this.index + ',' + offset);
        }
        return true;
    }

    protected Record parseRecord(int opCount, int generation, int expiration) throws AerospikeException, IOException {
        HashMap<String, Object> bins = null;
        ArrayList<HashMap<String, Object>> duplicates = null;
        for (int i = 0; i < opCount; ++i) {
            if (!this.valid) {
                throw new AerospikeException.QueryTerminated();
            }
            this.readBytes(8);
            int opSize = Buffer.bytesToInt(this.dataBuffer, 0);
            byte particleType = this.dataBuffer[5];
            int version = this.dataBuffer[6];
            byte nameSize = this.dataBuffer[7];
            this.readBytes(nameSize);
            String name = Buffer.utf8ToString(this.dataBuffer, 0, nameSize);
            int particleBytesSize = opSize - (4 + nameSize);
            this.readBytes(particleBytesSize);
            Object value = Buffer.bytesToParticle(particleType, this.dataBuffer, 0, particleBytesSize);
            if (this.binNames != null && !this.binNames.contains(name)) continue;
            Map<String, Object> vmap = null;
            if (version > 0 || duplicates != null) {
                int j;
                if (duplicates == null) {
                    duplicates = new ArrayList<HashMap<String, Object>>(4);
                    duplicates.add(bins);
                    bins = null;
                    for (j = 0; j < version; ++j) {
                        duplicates.add(null);
                    }
                } else {
                    for (j = duplicates.size(); j < version + 1; ++j) {
                        duplicates.add(null);
                    }
                }
                if ((vmap = (Map)duplicates.get(version)) == null) {
                    vmap = new HashMap();
                    duplicates.set(version, (HashMap<String, Object>)vmap);
                }
            } else {
                if (bins == null) {
                    bins = new HashMap<String, Object>();
                }
                vmap = bins;
            }
            vmap.put(name, value);
        }
        if (duplicates != null) {
            while (duplicates.remove(null)) {
            }
        }
        return new Record(bins, (List<Map<String, Object>>)duplicates, generation, expiration);
    }
}

