/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.command;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.Key;
import com.aerospike.client.Record;
import com.aerospike.client.cluster.Cluster;
import com.aerospike.client.command.BatchCommandExists;
import com.aerospike.client.command.BatchCommandGet;
import com.aerospike.client.command.BatchNode;
import com.aerospike.client.command.MultiCommand;
import com.aerospike.client.policy.BatchPolicy;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicInteger;

public final class BatchExecutor {
    private final ExecutorService threadPool;
    private final ArrayList<BatchThread> threads;
    private final AtomicInteger completedCount;
    private volatile Exception exception;
    private int maxConcurrentThreads;
    private boolean completed;

    public static void execute(Cluster cluster, BatchPolicy policy, Key[] keys2, boolean[] existsArray, Record[] records, HashSet<String> binNames, int readAttr) throws AerospikeException {
        if (keys2.length == 0) {
            return;
        }
        List<BatchNode> batchNodes = BatchNode.generateList(cluster, keys2);
        if (policy.maxConcurrentThreads == 1) {
            for (BatchNode batchNode : batchNodes) {
                for (BatchNode.BatchNamespace batchNamespace : batchNode.batchNamespaces) {
                    MultiCommand command;
                    if (records != null) {
                        command = new BatchCommandGet(batchNode.node, batchNamespace, policy, keys2, binNames, records, readAttr);
                        command.execute();
                        continue;
                    }
                    command = new BatchCommandExists(batchNode.node, batchNamespace, policy, keys2, existsArray);
                    command.execute();
                }
            }
        } else {
            BatchExecutor executor = new BatchExecutor(cluster, batchNodes.size() * 2);
            for (BatchNode batchNode : batchNodes) {
                for (BatchNode.BatchNamespace batchNamespace : batchNode.batchNamespaces) {
                    if (records != null) {
                        executor.add(new BatchCommandGet(batchNode.node, batchNamespace, policy, keys2, binNames, records, readAttr));
                        continue;
                    }
                    executor.add(new BatchCommandExists(batchNode.node, batchNamespace, policy, keys2, existsArray));
                }
            }
            executor.execute(policy);
        }
    }

    public BatchExecutor(Cluster cluster, int capacity) {
        this.threadPool = cluster.getThreadPool();
        this.threads = new ArrayList(capacity);
        this.completedCount = new AtomicInteger();
    }

    public void add(MultiCommand command) {
        this.threads.add(new BatchThread(command));
    }

    public void execute(BatchPolicy policy) {
        this.maxConcurrentThreads = policy.maxConcurrentThreads == 0 || policy.maxConcurrentThreads >= this.threads.size() ? this.threads.size() : policy.maxConcurrentThreads;
        for (int i = 0; i < this.maxConcurrentThreads; ++i) {
            this.threadPool.execute(this.threads.get(i));
        }
        this.waitTillComplete();
        if (this.exception != null) {
            if (this.exception instanceof AerospikeException) {
                throw (AerospikeException)this.exception;
            }
            throw new AerospikeException(this.exception);
        }
    }

    private void threadCompleted() {
        int finished = this.completedCount.incrementAndGet();
        if (finished < this.threads.size()) {
            int nextThread = finished + this.maxConcurrentThreads - 1;
            if (nextThread < this.threads.size()) {
                this.threadPool.execute(this.threads.get(nextThread));
            }
        } else {
            this.notifyCompleted();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopThreads(Exception cause) {
        ArrayList<BatchThread> arrayList = this.threads;
        synchronized (arrayList) {
            if (this.exception != null) {
                return;
            }
            this.exception = cause;
        }
        for (BatchThread thread : this.threads) {
            try {
                thread.stop();
            }
            catch (Exception e) {}
        }
        this.notifyCompleted();
    }

    private synchronized void waitTillComplete() {
        while (!this.completed) {
            try {
                super.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private synchronized void notifyCompleted() {
        this.completed = true;
        super.notify();
    }

    private final class BatchThread
    implements Runnable {
        private final MultiCommand command;
        private Thread thread;

        public BatchThread(MultiCommand command) {
            this.command = command;
        }

        @Override
        public void run() {
            this.thread = Thread.currentThread();
            try {
                if (this.command.isValid()) {
                    this.command.execute();
                }
            }
            catch (Exception e) {
                BatchExecutor.this.stopThreads(e);
            }
            if (BatchExecutor.this.exception == null) {
                BatchExecutor.this.threadCompleted();
            }
        }

        public void stop() {
            this.command.stop();
            if (this.thread != null) {
                this.thread.interrupt();
            }
        }
    }
}

