/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.command;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.Key;
import com.aerospike.client.Value;
import com.aerospike.client.cluster.Connection;
import com.aerospike.client.cluster.Node;
import com.aerospike.client.command.Buffer;
import com.aerospike.client.command.SyncCommand;
import java.io.BufferedInputStream;
import java.io.EOFException;
import java.io.IOException;

public abstract class MultiCommand
extends SyncCommand {
    private static final int MAX_BUFFER_SIZE = 0xA00000;
    private BufferedInputStream bis;
    protected final Node node;
    protected volatile boolean valid = true;

    protected MultiCommand(Node node) {
        this.node = node;
    }

    @Override
    protected final Node getNode() {
        return this.node;
    }

    @Override
    protected final void parseResult(Connection conn) throws AerospikeException, IOException {
        this.bis = new BufferedInputStream(conn.getInputStream());
        boolean status = true;
        while (status) {
            this.readBytes(8);
            long size = Buffer.bytesToLong(this.dataBuffer, 0);
            int receiveSize = (int)(size & 0xFFFFFFFFFFFFL);
            if (receiveSize > 0) {
                status = this.parseRecordResults(receiveSize);
                continue;
            }
            status = false;
        }
    }

    protected final Key parseKey(int fieldCount) throws AerospikeException, IOException {
        byte[] digest = null;
        String namespace = null;
        String setName = null;
        Value userKey = null;
        block6: for (int i = 0; i < fieldCount; ++i) {
            this.readBytes(4);
            int fieldlen = Buffer.bytesToInt(this.dataBuffer, 0);
            this.readBytes(fieldlen);
            byte fieldtype = this.dataBuffer[0];
            int size = fieldlen - 1;
            switch (fieldtype) {
                case 4: {
                    digest = new byte[size];
                    System.arraycopy(this.dataBuffer, 1, digest, 0, size);
                    continue block6;
                }
                case 0: {
                    namespace = Buffer.utf8ToString(this.dataBuffer, 1, size);
                    continue block6;
                }
                case 1: {
                    setName = Buffer.utf8ToString(this.dataBuffer, 1, size);
                    continue block6;
                }
                case 2: {
                    userKey = Buffer.bytesToKeyValue(this.dataBuffer[1], this.dataBuffer, 2, size - 1);
                }
            }
        }
        return new Key(namespace, digest, setName, userKey);
    }

    protected final void readBytes(int length) throws IOException {
        int count;
        if (length > this.dataBuffer.length) {
            if (length > 0xA00000) {
                throw new IllegalArgumentException("Invalid readBytes length: " + length);
            }
            this.dataBuffer = new byte[length];
        }
        for (int pos = 0; pos < length; pos += count) {
            count = this.bis.read(this.dataBuffer, pos, length - pos);
            if (count >= 0) continue;
            throw new EOFException();
        }
        this.dataOffset += length;
    }

    public void stop() {
        this.valid = false;
    }

    public boolean isValid() {
        return this.valid;
    }

    protected abstract boolean parseRecordResults(int var1) throws AerospikeException, IOException;
}

