/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.large;

import com.aerospike.client.AerospikeClient;
import com.aerospike.client.AerospikeException;
import com.aerospike.client.Key;
import com.aerospike.client.Value;
import com.aerospike.client.policy.Policy;
import java.util.List;
import java.util.Map;

public final class LargeStack {
    private static final String PackageName = "lstack";
    private final AerospikeClient client;
    private final Policy policy;
    private final Key key;
    private final Value binName;
    private final Value userModule;

    public LargeStack(AerospikeClient client, Policy policy, Key key, String binName, String userModule) {
        this.client = client;
        this.policy = policy;
        this.key = key;
        this.binName = Value.get(binName);
        this.userModule = Value.get(userModule);
    }

    public final void push(Value value) throws AerospikeException {
        this.client.execute(this.policy, this.key, PackageName, "push", this.binName, value, this.userModule);
    }

    public final void push(Value ... values2) throws AerospikeException {
        this.client.execute(this.policy, this.key, PackageName, "push_all", this.binName, Value.get(values2), this.userModule);
    }

    public final void push(List<?> values2) throws AerospikeException {
        this.client.execute(this.policy, this.key, PackageName, "push_all", this.binName, Value.getAsList(values2), this.userModule);
    }

    public final List<?> peek(int peekCount) throws AerospikeException {
        return (List)this.client.execute(this.policy, this.key, PackageName, "peek", this.binName, Value.get(peekCount));
    }

    public final List<?> scan() throws AerospikeException {
        return (List)this.client.execute(this.policy, this.key, PackageName, "scan", this.binName);
    }

    public final List<?> filter(int peekCount, String filterName, Value ... filterArgs) throws AerospikeException {
        return (List)this.client.execute(this.policy, this.key, PackageName, "filter", this.binName, Value.get(peekCount), this.userModule, Value.get(filterName), Value.get(filterArgs));
    }

    public final void destroy() throws AerospikeException {
        this.client.execute(this.policy, this.key, PackageName, "destroy", this.binName);
    }

    public final int size() throws AerospikeException {
        return (Integer)this.client.execute(this.policy, this.key, PackageName, "size", this.binName);
    }

    public final Map<?, ?> getConfig() throws AerospikeException {
        return (Map)this.client.execute(this.policy, this.key, PackageName, "get_config", this.binName);
    }

    public final void setCapacity(int capacity) throws AerospikeException {
        this.client.execute(this.policy, this.key, PackageName, "set_capacity", this.binName, Value.get(capacity));
    }

    public final int getCapacity() throws AerospikeException {
        return (Integer)this.client.execute(this.policy, this.key, PackageName, "get_capacity", this.binName);
    }
}

