/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.query;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.cluster.Cluster;
import com.aerospike.client.cluster.Node;
import com.aerospike.client.policy.QueryPolicy;
import com.aerospike.client.query.QueryCommand;
import com.aerospike.client.query.Statement;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class QueryExecutor {
    protected final QueryPolicy policy;
    protected final Statement statement;
    private final Node[] nodes;
    protected final ExecutorService threadPool;
    private final QueryThread[] threads;
    private final AtomicInteger completedCount;
    protected volatile Exception exception;
    private final int maxConcurrentNodes;

    public QueryExecutor(Cluster cluster, QueryPolicy policy, Statement statement, Node node) throws AerospikeException {
        this.policy = policy;
        this.policy.maxRetries = 0;
        this.statement = statement;
        this.completedCount = new AtomicInteger();
        if (node == null) {
            this.nodes = cluster.getNodes();
            if (this.nodes.length == 0) {
                throw new AerospikeException(11, "Query failed because cluster is empty.");
            }
        } else {
            this.nodes = new Node[]{node};
        }
        this.threadPool = cluster.getThreadPool();
        this.threads = new QueryThread[this.nodes.length];
        this.maxConcurrentNodes = policy.maxConcurrentNodes == 0 || policy.maxConcurrentNodes >= this.threads.length ? this.threads.length : policy.maxConcurrentNodes;
    }

    protected final void startThreads() {
        int i;
        for (i = 0; i < this.nodes.length; ++i) {
            QueryCommand command = this.createCommand(this.nodes[i]);
            this.threads[i] = new QueryThread(command);
        }
        for (i = 0; i < this.maxConcurrentNodes; ++i) {
            this.threadPool.execute(this.threads[i]);
        }
    }

    private final void threadCompleted() {
        int finished = this.completedCount.incrementAndGet();
        if (finished < this.threads.length) {
            int nextThread = finished + this.maxConcurrentNodes - 1;
            if (nextThread < this.threads.length) {
                this.threadPool.execute(this.threads[nextThread]);
            }
        } else {
            this.sendCompleted();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void stopThreads(Exception cause) {
        QueryThread[] queryThreadArray = this.threads;
        synchronized (this.threads) {
            if (this.exception != null) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            this.exception = cause;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            for (QueryThread thread : this.threads) {
                try {
                    thread.stop();
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            this.sendCompleted();
            return;
        }
    }

    protected final void checkForException() throws AerospikeException {
        if (this.exception != null) {
            if (this.exception instanceof AerospikeException) {
                throw (AerospikeException)this.exception;
            }
            throw new AerospikeException(this.exception);
        }
    }

    protected abstract QueryCommand createCommand(Node var1);

    protected abstract void sendCompleted();

    private final class QueryThread
    implements Runnable {
        private final QueryCommand command;
        private Thread thread;

        public QueryThread(QueryCommand command) {
            this.command = command;
        }

        @Override
        public void run() {
            this.thread = Thread.currentThread();
            try {
                if (this.command.isValid()) {
                    this.command.execute();
                }
            }
            catch (Exception e) {
                QueryExecutor.this.stopThreads(e);
            }
            if (QueryExecutor.this.exception == null) {
                QueryExecutor.this.threadCompleted();
            }
        }

        public void stop() {
            this.command.stop();
            if (this.thread != null) {
                this.thread.interrupt();
            }
        }
    }
}

