/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.query;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.query.QueryAggregateExecutor;
import java.io.Closeable;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;

public final class ResultSet
implements Closeable {
    public static final Integer END = new Integer(-1);
    private final QueryAggregateExecutor executor;
    private final BlockingQueue<Object> queue;
    private Object row;
    private volatile boolean valid = true;

    protected ResultSet(QueryAggregateExecutor executor, int capacity) {
        this.executor = executor;
        this.queue = new ArrayBlockingQueue<Object>(capacity);
    }

    public final boolean next() throws AerospikeException {
        if (this.valid) {
            try {
                this.row = this.queue.take();
                if (this.row == END) {
                    this.executor.checkForException();
                    this.valid = false;
                }
            }
            catch (InterruptedException ie) {
                this.valid = false;
            }
        }
        return this.valid;
    }

    @Override
    public final void close() {
        this.valid = false;
        if (this.row != END) {
            this.executor.stopThreads(new AerospikeException.QueryTerminated());
        }
    }

    public final Object getObject() {
        return this.row;
    }

    public final boolean put(Object object) {
        block3: {
            if (this.valid) {
                try {
                    this.queue.put(object);
                }
                catch (InterruptedException ie) {
                    if (!this.valid) break block3;
                    this.abort();
                }
            }
        }
        return this.valid;
    }

    private final void abort() {
        this.valid = false;
        while (true) {
            try {
                this.queue.put(END);
                return;
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }
}

