/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.query;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.Value;
import com.aerospike.client.cluster.Cluster;
import com.aerospike.client.cluster.Node;
import com.aerospike.client.policy.Policy;
import com.aerospike.client.query.ServerCommand;
import com.aerospike.client.query.Statement;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicInteger;

public final class ServerExecutor {
    private final ServerThread[] threads;
    private final AtomicInteger completedCount;
    private volatile Exception exception;
    private boolean completed;

    public ServerExecutor(Cluster cluster, Policy policy, Statement statement, String packageName, String functionName, Value[] functionArgs) throws AerospikeException {
        statement.setAggregateFunction(packageName, functionName, functionArgs, false);
        statement.prepare();
        this.completedCount = new AtomicInteger();
        Node[] nodes = cluster.getNodes();
        if (nodes.length == 0) {
            throw new AerospikeException(11, "Command failed because cluster is empty.");
        }
        this.threads = new ServerThread[nodes.length];
        for (int i = 0; i < nodes.length; ++i) {
            ServerCommand command = new ServerCommand(nodes[i], policy, statement);
            this.threads[i] = new ServerThread(command);
        }
        ExecutorService threadPool = cluster.getThreadPool();
        for (int i = 0; i < nodes.length; ++i) {
            threadPool.execute(this.threads[i]);
        }
        this.waitTillComplete();
        if (this.exception != null) {
            if (this.exception instanceof AerospikeException) {
                throw (AerospikeException)this.exception;
            }
            throw new AerospikeException(this.exception);
        }
    }

    private void threadCompleted() {
        if (this.completedCount.incrementAndGet() >= this.threads.length) {
            this.notifyCompleted();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopThreads(Exception cause) {
        ServerThread[] serverThreadArray = this.threads;
        synchronized (this.threads) {
            if (this.exception != null) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            this.exception = cause;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            for (ServerThread thread : this.threads) {
                try {
                    thread.stop();
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            this.notifyCompleted();
            return;
        }
    }

    private synchronized void waitTillComplete() {
        while (!this.completed) {
            try {
                super.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private synchronized void notifyCompleted() {
        this.completed = true;
        super.notify();
    }

    private final class ServerThread
    implements Runnable {
        private final ServerCommand command;
        private Thread thread;

        public ServerThread(ServerCommand command) {
            this.command = command;
        }

        @Override
        public void run() {
            this.thread = Thread.currentThread();
            try {
                if (this.command.isValid()) {
                    this.command.execute();
                }
            }
            catch (Exception e) {
                ServerExecutor.this.stopThreads(e);
            }
            if (ServerExecutor.this.exception == null) {
                ServerExecutor.this.threadCompleted();
            }
        }

        public void stop() {
            this.command.stop();
            if (this.thread != null) {
                this.thread.interrupt();
            }
        }
    }
}

