/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.admin;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.admin.Privilege;
import com.aerospike.client.admin.PrivilegeCode;
import com.aerospike.client.admin.Role;
import com.aerospike.client.admin.User;
import com.aerospike.client.cluster.Cluster;
import com.aerospike.client.cluster.Connection;
import com.aerospike.client.cluster.Node;
import com.aerospike.client.command.Buffer;
import com.aerospike.client.policy.AdminPolicy;
import com.aerospike.client.util.ThreadLocalData;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.mindrot.jbcrypt.BCrypt;

public class AdminCommand {
    private static final byte AUTHENTICATE = 0;
    private static final byte CREATE_USER = 1;
    private static final byte DROP_USER = 2;
    private static final byte SET_PASSWORD = 3;
    private static final byte CHANGE_PASSWORD = 4;
    private static final byte GRANT_ROLES = 5;
    private static final byte REVOKE_ROLES = 6;
    private static final byte QUERY_USERS = 9;
    private static final byte CREATE_ROLE = 10;
    private static final byte DROP_ROLE = 11;
    private static final byte GRANT_PRIVILEGES = 12;
    private static final byte REVOKE_PRIVILEGES = 13;
    private static final byte QUERY_ROLES = 16;
    private static final byte USER = 0;
    private static final byte PASSWORD = 1;
    private static final byte OLD_PASSWORD = 2;
    private static final byte CREDENTIAL = 3;
    private static final byte ROLES = 10;
    private static final byte ROLE = 11;
    private static final byte PRIVILEGES = 12;
    private static final long MSG_VERSION = 0L;
    private static final long MSG_TYPE = 2L;
    private static final int FIELD_HEADER_SIZE = 5;
    private static final int HEADER_SIZE = 24;
    private static final int HEADER_REMAINING = 16;
    private static final int RESULT_CODE = 9;
    private static final int QUERY_END = 50;
    private byte[] dataBuffer;
    private int dataOffset;

    public AdminCommand() {
        this.dataBuffer = ThreadLocalData.getBuffer();
        this.dataOffset = 8;
    }

    public AdminCommand(byte[] dataBuffer) {
        this.dataBuffer = dataBuffer;
        this.dataOffset = 8;
    }

    public void authenticate(Connection conn, byte[] user, byte[] password) throws AerospikeException, IOException {
        this.setAuthenticate(user, password);
        conn.write(this.dataBuffer, this.dataOffset);
        conn.readFully(this.dataBuffer, 24);
        byte result = this.dataBuffer[9];
        if (result != 0) {
            throw new AerospikeException((int)result, "Authentication failed");
        }
    }

    public int setAuthenticate(byte[] user, byte[] password) {
        this.writeHeader((byte)0, 2);
        this.writeField((byte)0, user);
        this.writeField((byte)3, password);
        this.writeSize();
        return this.dataOffset;
    }

    public void createUser(Cluster cluster, AdminPolicy policy, String user, String password, List<String> roles) throws AerospikeException {
        this.writeHeader((byte)1, 3);
        this.writeField((byte)0, user);
        this.writeField((byte)1, password);
        this.writeRoles(roles);
        this.executeCommand(cluster, policy);
    }

    public void dropUser(Cluster cluster, AdminPolicy policy, String user) throws AerospikeException {
        this.writeHeader((byte)2, 1);
        this.writeField((byte)0, user);
        this.executeCommand(cluster, policy);
    }

    public void setPassword(Cluster cluster, AdminPolicy policy, byte[] user, String password) throws AerospikeException {
        this.writeHeader((byte)3, 2);
        this.writeField((byte)0, user);
        this.writeField((byte)1, password);
        this.executeCommand(cluster, policy);
    }

    public void changePassword(Cluster cluster, AdminPolicy policy, byte[] user, String password) throws AerospikeException {
        this.writeHeader((byte)4, 3);
        this.writeField((byte)0, user);
        this.writeField((byte)2, cluster.getPassword());
        this.writeField((byte)1, password);
        this.executeCommand(cluster, policy);
    }

    public void grantRoles(Cluster cluster, AdminPolicy policy, String user, List<String> roles) throws AerospikeException {
        this.writeHeader((byte)5, 2);
        this.writeField((byte)0, user);
        this.writeRoles(roles);
        this.executeCommand(cluster, policy);
    }

    public void revokeRoles(Cluster cluster, AdminPolicy policy, String user, List<String> roles) throws AerospikeException {
        this.writeHeader((byte)6, 2);
        this.writeField((byte)0, user);
        this.writeRoles(roles);
        this.executeCommand(cluster, policy);
    }

    public void createRole(Cluster cluster, AdminPolicy policy, String roleName, List<Privilege> privileges) throws AerospikeException {
        this.writeHeader((byte)10, 2);
        this.writeField((byte)11, roleName);
        this.writePrivileges(privileges);
        this.executeCommand(cluster, policy);
    }

    public void dropRole(Cluster cluster, AdminPolicy policy, String roleName) throws AerospikeException {
        this.writeHeader((byte)11, 1);
        this.writeField((byte)11, roleName);
        this.executeCommand(cluster, policy);
    }

    public void grantPrivileges(Cluster cluster, AdminPolicy policy, String roleName, List<Privilege> privileges) throws AerospikeException {
        this.writeHeader((byte)12, 2);
        this.writeField((byte)11, roleName);
        this.writePrivileges(privileges);
        this.executeCommand(cluster, policy);
    }

    public void revokePrivileges(Cluster cluster, AdminPolicy policy, String roleName, List<Privilege> privileges) throws AerospikeException {
        this.writeHeader((byte)13, 2);
        this.writeField((byte)11, roleName);
        this.writePrivileges(privileges);
        this.executeCommand(cluster, policy);
    }

    private void writeRoles(List<String> roles) {
        int offset = this.dataOffset + 5;
        this.dataBuffer[offset++] = (byte)roles.size();
        for (String role : roles) {
            int len2 = Buffer.stringToUtf8(role, this.dataBuffer, offset + 1);
            this.dataBuffer[offset] = (byte)len2;
            offset += len2 + 1;
        }
        int size = offset - this.dataOffset - 5;
        this.writeFieldHeader((byte)10, size);
        this.dataOffset = offset;
    }

    private void writePrivileges(List<Privilege> privileges) {
        int offset = this.dataOffset + 5;
        this.dataBuffer[offset++] = (byte)privileges.size();
        for (Privilege privilege : privileges) {
            this.dataBuffer[offset++] = (byte)privilege.code.id;
            if (privilege.code.canScope()) {
                if (privilege.setName != null && privilege.setName.length() != 0 && (privilege.namespace == null || privilege.namespace.length() == 0)) {
                    throw new AerospikeException(72, "Admin privilege '" + (Object)((Object)privilege.code) + "' has a set scope with an empty namespace.");
                }
                int len2 = Buffer.stringToUtf8(privilege.namespace, this.dataBuffer, offset + 1);
                this.dataBuffer[offset] = (byte)len2;
                offset += len2 + 1;
                len2 = Buffer.stringToUtf8(privilege.setName, this.dataBuffer, offset + 1);
                this.dataBuffer[offset] = (byte)len2;
                offset += len2 + 1;
                continue;
            }
            if ((privilege.namespace == null || privilege.namespace.length() == 0) && (privilege.setName == null || privilege.setName.length() == 0)) continue;
            throw new AerospikeException(72, "Admin global privilege '" + (Object)((Object)privilege.code) + "' has namespace/set scope which is invalid.");
        }
        int size = offset - this.dataOffset - 5;
        this.writeFieldHeader((byte)12, size);
        this.dataOffset = offset;
    }

    private void writeSize() {
        long size = (long)this.dataOffset - 8L | 0L | 0x2000000000000L;
        Buffer.longToBytes(size, this.dataBuffer, 0);
    }

    private void writeHeader(byte command, int fieldCount) {
        Arrays.fill(this.dataBuffer, this.dataOffset, this.dataOffset + 16, (byte)0);
        this.dataBuffer[this.dataOffset + 2] = command;
        this.dataBuffer[this.dataOffset + 3] = (byte)fieldCount;
        this.dataOffset += 16;
    }

    private void writeField(byte id, String str) {
        int len2 = Buffer.stringToUtf8(str, this.dataBuffer, this.dataOffset + 5);
        this.writeFieldHeader(id, len2);
        this.dataOffset += len2;
    }

    private void writeField(byte id, byte[] bytes) {
        System.arraycopy(bytes, 0, this.dataBuffer, this.dataOffset + 5, bytes.length);
        this.writeFieldHeader(id, bytes.length);
        this.dataOffset += bytes.length;
    }

    private void writeFieldHeader(byte id, int size) {
        Buffer.intToBytes(size + 1, this.dataBuffer, this.dataOffset);
        this.dataOffset += 4;
        this.dataBuffer[this.dataOffset++] = id;
    }

    private void executeCommand(Cluster cluster, AdminPolicy policy) throws AerospikeException {
        this.writeSize();
        Node node = cluster.getRandomNode();
        int timeout = policy == null ? 1000 : policy.timeout;
        Connection conn = node.getConnection(timeout);
        try {
            conn.write(this.dataBuffer, this.dataOffset);
            conn.readFully(this.dataBuffer, 24);
            node.putConnection(conn);
        }
        catch (Exception e) {
            conn.close();
            throw new AerospikeException(e);
        }
        byte result = this.dataBuffer[9];
        if (result != 0) {
            throw new AerospikeException(result);
        }
    }

    private void executeQuery(Cluster cluster, AdminPolicy policy) throws AerospikeException {
        this.writeSize();
        Node node = cluster.getRandomNode();
        int timeout = policy == null ? 1000 : policy.timeout;
        int status = 0;
        Connection conn = node.getConnection(timeout);
        try {
            conn.write(this.dataBuffer, this.dataOffset);
            status = this.readBlocks(conn);
            node.putConnection(conn);
        }
        catch (Exception e) {
            conn.close();
            throw new AerospikeException(e);
        }
        if (status != 50 && status > 0) {
            throw new AerospikeException(status, "Query failed.");
        }
    }

    private int readBlocks(Connection conn) throws IOException {
        int status = 0;
        while (status == 0) {
            conn.readFully(this.dataBuffer, 8);
            long size = Buffer.bytesToLong(this.dataBuffer, 0);
            int receiveSize = (int)(size & 0xFFFFFFFFFFFFL);
            if (receiveSize <= 0) break;
            if (receiveSize > this.dataBuffer.length) {
                this.dataBuffer = ThreadLocalData.resizeBuffer(receiveSize);
            }
            conn.readFully(this.dataBuffer, receiveSize);
            status = this.parseBlock(receiveSize);
        }
        return status;
    }

    public static String hashPassword(String password) {
        return BCrypt.hashpw((String)password, (String)"$2a$10$7EqJtq98hPqEX7fNZaFWoO");
    }

    int parseBlock(int receiveSize) {
        return 50;
    }

    public static final class RoleCommand
    extends AdminCommand {
        private final List<Role> list;

        public RoleCommand(int capacity) {
            this.list = new ArrayList<Role>(capacity);
        }

        public Role queryRole(Cluster cluster, AdminPolicy policy, String roleName) throws AerospikeException {
            ((AdminCommand)this).writeHeader((byte)16, 1);
            ((AdminCommand)this).writeField((byte)11, roleName);
            ((AdminCommand)this).executeQuery(cluster, policy);
            return this.list.size() > 0 ? this.list.get(0) : null;
        }

        public List<Role> queryRoles(Cluster cluster, AdminPolicy policy) throws AerospikeException {
            ((AdminCommand)this).writeHeader((byte)16, 0);
            ((AdminCommand)this).executeQuery(cluster, policy);
            return this.list;
        }

        @Override
        int parseBlock(int receiveSize) {
            ((AdminCommand)this).dataOffset = 0;
            while (((AdminCommand)this).dataOffset < receiveSize) {
                byte resultCode = ((AdminCommand)this).dataBuffer[((AdminCommand)this).dataOffset + 1];
                if (resultCode != 0) {
                    return resultCode;
                }
                Role role = new Role();
                int fieldCount = ((AdminCommand)this).dataBuffer[((AdminCommand)this).dataOffset + 3];
                ((AdminCommand)this).dataOffset += 16;
                for (int i = 0; i < fieldCount; ++i) {
                    int len2 = Buffer.bytesToInt(((AdminCommand)this).dataBuffer, ((AdminCommand)this).dataOffset);
                    ((AdminCommand)this).dataOffset += 4;
                    byte id = ((AdminCommand)this).dataBuffer[((AdminCommand)this).dataOffset++];
                    --len2;
                    if (id == 11) {
                        role.name = Buffer.utf8ToString(((AdminCommand)this).dataBuffer, ((AdminCommand)this).dataOffset, len2);
                        ((AdminCommand)this).dataOffset += len2;
                        continue;
                    }
                    if (id == 12) {
                        this.parsePrivileges(role);
                        continue;
                    }
                    ((AdminCommand)this).dataOffset += len2;
                }
                if (role.name == null && role.privileges == null) continue;
                if (role.privileges == null) {
                    role.privileges = new ArrayList<Privilege>(0);
                }
                this.list.add(role);
            }
            return 0;
        }

        private void parsePrivileges(Role role) {
            int size = ((AdminCommand)this).dataBuffer[((AdminCommand)this).dataOffset++];
            role.privileges = new ArrayList<Privilege>(size);
            for (int i = 0; i < size; ++i) {
                Privilege priv = new Privilege();
                priv.code = PrivilegeCode.fromId(((AdminCommand)this).dataBuffer[((AdminCommand)this).dataOffset++]);
                if (priv.code.canScope()) {
                    byte len2 = ((AdminCommand)this).dataBuffer[((AdminCommand)this).dataOffset++];
                    priv.namespace = Buffer.utf8ToString(((AdminCommand)this).dataBuffer, ((AdminCommand)this).dataOffset, len2);
                    ((AdminCommand)this).dataOffset += len2;
                    len2 = ((AdminCommand)this).dataBuffer[((AdminCommand)this).dataOffset++];
                    priv.setName = Buffer.utf8ToString(((AdminCommand)this).dataBuffer, ((AdminCommand)this).dataOffset, len2);
                    ((AdminCommand)this).dataOffset += len2;
                }
                role.privileges.add(priv);
            }
        }
    }

    public static final class UserCommand
    extends AdminCommand {
        private final List<User> list;

        public UserCommand(int capacity) {
            this.list = new ArrayList<User>(capacity);
        }

        public User queryUser(Cluster cluster, AdminPolicy policy, String user) throws AerospikeException {
            ((AdminCommand)this).writeHeader((byte)9, 1);
            ((AdminCommand)this).writeField((byte)0, user);
            ((AdminCommand)this).executeQuery(cluster, policy);
            return this.list.size() > 0 ? this.list.get(0) : null;
        }

        public List<User> queryUsers(Cluster cluster, AdminPolicy policy) throws AerospikeException {
            ((AdminCommand)this).writeHeader((byte)9, 0);
            ((AdminCommand)this).executeQuery(cluster, policy);
            return this.list;
        }

        @Override
        int parseBlock(int receiveSize) {
            ((AdminCommand)this).dataOffset = 0;
            while (((AdminCommand)this).dataOffset < receiveSize) {
                byte resultCode = ((AdminCommand)this).dataBuffer[((AdminCommand)this).dataOffset + 1];
                if (resultCode != 0) {
                    return resultCode;
                }
                User user = new User();
                int fieldCount = ((AdminCommand)this).dataBuffer[((AdminCommand)this).dataOffset + 3];
                ((AdminCommand)this).dataOffset += 16;
                for (int i = 0; i < fieldCount; ++i) {
                    int len2 = Buffer.bytesToInt(((AdminCommand)this).dataBuffer, ((AdminCommand)this).dataOffset);
                    ((AdminCommand)this).dataOffset += 4;
                    byte id = ((AdminCommand)this).dataBuffer[((AdminCommand)this).dataOffset++];
                    --len2;
                    if (id == 0) {
                        user.name = Buffer.utf8ToString(((AdminCommand)this).dataBuffer, ((AdminCommand)this).dataOffset, len2);
                        ((AdminCommand)this).dataOffset += len2;
                        continue;
                    }
                    if (id == 10) {
                        this.parseRoles(user);
                        continue;
                    }
                    ((AdminCommand)this).dataOffset += len2;
                }
                if (user.name == null && user.roles == null) continue;
                if (user.roles == null) {
                    user.roles = new ArrayList<String>(0);
                }
                this.list.add(user);
            }
            return 0;
        }

        private void parseRoles(User user) {
            int size = ((AdminCommand)this).dataBuffer[((AdminCommand)this).dataOffset++];
            user.roles = new ArrayList<String>(size);
            for (int i = 0; i < size; ++i) {
                byte len2 = ((AdminCommand)this).dataBuffer[((AdminCommand)this).dataOffset++];
                String role = Buffer.utf8ToString(((AdminCommand)this).dataBuffer, ((AdminCommand)this).dataOffset, len2);
                ((AdminCommand)this).dataOffset += len2;
                user.roles.add(role);
            }
        }
    }
}

