/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.async;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.Bin;
import com.aerospike.client.Key;
import com.aerospike.client.Operation;
import com.aerospike.client.async.AsyncCluster;
import com.aerospike.client.async.AsyncSingleCommand;
import com.aerospike.client.listener.WriteListener;
import com.aerospike.client.policy.Policy;
import com.aerospike.client.policy.WritePolicy;
import java.nio.ByteBuffer;

public final class AsyncWrite
extends AsyncSingleCommand {
    private final WritePolicy policy;
    private final WriteListener listener;
    private final Bin[] bins;
    private final Operation.Type operation;

    public AsyncWrite(AsyncCluster cluster, WritePolicy policy, WriteListener listener, Key key, Bin[] bins, Operation.Type operation) {
        super(cluster, key);
        this.policy = policy;
        this.listener = listener;
        this.bins = bins;
        this.operation = operation;
    }

    @Override
    protected Policy getPolicy() {
        return this.policy;
    }

    @Override
    protected void writeBuffer() throws AerospikeException {
        this.setWrite(this.policy, this.operation, this.key, this.bins);
    }

    @Override
    protected void parseResult(ByteBuffer byteBuffer) throws AerospikeException {
        int resultCode = byteBuffer.get(5) & 0xFF;
        if (resultCode != 0) {
            throw new AerospikeException(resultCode);
        }
    }

    @Override
    protected void onSuccess() {
        if (this.listener != null) {
            this.listener.onSuccess(this.key);
        }
    }

    @Override
    protected void onFailure(AerospikeException e) {
        if (this.listener != null) {
            this.listener.onFailure(e);
        }
    }
}

