/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.command;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.Key;
import com.aerospike.client.Log;
import com.aerospike.client.cluster.Node;
import com.aerospike.client.command.BatchNode;
import com.aerospike.client.command.Buffer;
import com.aerospike.client.command.MultiCommand;
import com.aerospike.client.policy.Policy;
import java.io.IOException;
import java.util.Arrays;

public final class BatchCommandExists
extends MultiCommand {
    private final BatchNode.BatchNamespace batch;
    private final Policy policy;
    private final Key[] keys;
    private final boolean[] existsArray;
    private int index;

    public BatchCommandExists(Node node, BatchNode.BatchNamespace batch, Policy policy, Key[] keys2, boolean[] existsArray) {
        super(node);
        this.batch = batch;
        this.policy = policy;
        this.keys = keys2;
        this.existsArray = existsArray;
    }

    @Override
    protected Policy getPolicy() {
        return this.policy;
    }

    @Override
    protected void writeBuffer() throws AerospikeException {
        this.setBatchExists(this.policy, this.keys, this.batch);
    }

    @Override
    protected boolean parseRecordResults(int receiveSize) throws AerospikeException, IOException {
        this.dataOffset = 0;
        while (this.dataOffset < receiveSize) {
            if (!this.valid) {
                throw new AerospikeException.QueryTerminated();
            }
            this.readBytes(22);
            int resultCode = this.dataBuffer[5] & 0xFF;
            if (resultCode != 0 && resultCode != 2) {
                throw new AerospikeException(resultCode);
            }
            byte info3 = this.dataBuffer[3];
            if ((info3 & 1) == 1) {
                return false;
            }
            int fieldCount = Buffer.bytesToShort(this.dataBuffer, 18);
            int opCount = Buffer.bytesToShort(this.dataBuffer, 20);
            if (opCount > 0) {
                throw new AerospikeException.Parse("Received bins that were not requested!");
            }
            Key key = this.parseKey(fieldCount);
            int offset = this.batch.offsets[this.index++];
            if (Arrays.equals(key.digest, this.keys[offset].digest)) {
                this.existsArray[offset] = resultCode == 0;
                continue;
            }
            if (!Log.warnEnabled()) continue;
            Log.warn("Unexpected batch key returned: " + key.namespace + ',' + Buffer.bytesToHexString(key.digest) + ',' + this.index + ',' + offset);
        }
        return true;
    }
}

