/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.command;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.Bin;
import com.aerospike.client.Key;
import com.aerospike.client.Operation;
import com.aerospike.client.Value;
import com.aerospike.client.command.BatchNode;
import com.aerospike.client.command.Buffer;
import com.aerospike.client.policy.CommitLevel;
import com.aerospike.client.policy.ConsistencyLevel;
import com.aerospike.client.policy.Policy;
import com.aerospike.client.policy.ScanPolicy;
import com.aerospike.client.policy.WritePolicy;
import com.aerospike.client.query.Filter;
import com.aerospike.client.query.IndexCollectionType;
import com.aerospike.client.query.Statement;
import com.aerospike.client.util.Packer;
import com.aerospike.client.util.ThreadLocalData;
import java.util.HashSet;

public abstract class Command {
    public static final int INFO1_READ = 1;
    public static final int INFO1_GET_ALL = 2;
    public static final int INFO1_NOBINDATA = 32;
    public static final int INFO1_CONSISTENCY_ALL = 64;
    public static final int INFO2_WRITE = 1;
    public static final int INFO2_DELETE = 2;
    public static final int INFO2_GENERATION = 4;
    public static final int INFO2_GENERATION_GT = 8;
    public static final int INFO2_CREATE_ONLY = 32;
    public static final int INFO3_LAST = 1;
    public static final int INFO3_COMMIT_MASTER = 2;
    public static final int INFO3_UPDATE_ONLY = 8;
    public static final int INFO3_CREATE_OR_REPLACE = 16;
    public static final int INFO3_REPLACE_ONLY = 32;
    public static final int MSG_TOTAL_HEADER_SIZE = 30;
    public static final int FIELD_HEADER_SIZE = 5;
    public static final int OPERATION_HEADER_SIZE = 8;
    public static final int MSG_REMAINING_HEADER_SIZE = 22;
    public static final int DIGEST_SIZE = 20;
    public static final long CL_MSG_VERSION = 2L;
    public static final long AS_MSG_TYPE = 3L;
    protected byte[] dataBuffer;
    protected int dataOffset;

    public final void setWrite(WritePolicy policy, Operation.Type operation, Key key, Bin[] bins) throws AerospikeException {
        this.begin();
        int fieldCount = this.estimateKeySize(policy, key);
        for (Bin bin : bins) {
            this.estimateOperationSize(bin);
        }
        this.sizeBuffer();
        this.writeHeader(policy, 0, 1, fieldCount, bins.length);
        this.writeKey(policy, key);
        for (Bin bin : bins) {
            this.writeOperation(bin, operation);
        }
        this.end();
    }

    public void setDelete(WritePolicy policy, Key key) {
        this.begin();
        int fieldCount = this.estimateKeySize(policy, key);
        this.sizeBuffer();
        this.writeHeader(policy, 0, 3, fieldCount, 0);
        this.writeKey(policy, key);
        this.end();
    }

    public final void setTouch(WritePolicy policy, Key key) {
        this.begin();
        int fieldCount = this.estimateKeySize(policy, key);
        this.estimateOperationSize();
        this.sizeBuffer();
        this.writeHeader(policy, 0, 1, fieldCount, 1);
        this.writeKey(policy, key);
        this.writeOperation(Operation.Type.TOUCH);
        this.end();
    }

    public final void setExists(Policy policy, Key key) {
        this.begin();
        int fieldCount = this.estimateKeySize(policy, key);
        this.sizeBuffer();
        this.writeHeader(policy, 33, 0, fieldCount, 0);
        this.writeKey(policy, key);
        this.end();
    }

    public final void setRead(Policy policy, Key key) {
        this.begin();
        int fieldCount = this.estimateKeySize(policy, key);
        this.sizeBuffer();
        this.writeHeader(policy, 3, 0, fieldCount, 0);
        this.writeKey(policy, key);
        this.end();
    }

    public final void setRead(Policy policy, Key key, String[] binNames) {
        if (binNames != null) {
            this.begin();
            int fieldCount = this.estimateKeySize(policy, key);
            for (String binName : binNames) {
                this.estimateOperationSize(binName);
            }
            this.sizeBuffer();
            this.writeHeader(policy, 1, 0, fieldCount, binNames.length);
            this.writeKey(policy, key);
            for (String binName : binNames) {
                this.writeOperation(binName, Operation.Type.READ);
            }
            this.end();
        } else {
            this.setRead(policy, key);
        }
    }

    public final void setReadHeader(Policy policy, Key key) {
        this.begin();
        int fieldCount = this.estimateKeySize(policy, key);
        this.estimateOperationSize((String)null);
        this.sizeBuffer();
        this.writeHeader(policy, 33, 0, fieldCount, 0);
        this.writeKey(policy, key);
        this.end();
    }

    public final void setOperate(WritePolicy policy, Key key, Operation[] operations) throws AerospikeException {
        this.begin();
        int fieldCount = this.estimateKeySize(policy, key);
        int readAttr = 0;
        int writeAttr = 0;
        boolean readBin = false;
        boolean readHeader = false;
        for (Operation operation : operations) {
            switch (operation.type) {
                case READ: {
                    readAttr |= 1;
                    if (operation.binName == null) {
                        readAttr |= 2;
                    }
                    readBin = true;
                    break;
                }
                case READ_HEADER: {
                    readAttr |= 1;
                    readHeader = true;
                    break;
                }
                default: {
                    writeAttr = 1;
                }
            }
            this.estimateOperationSize(operation);
        }
        this.sizeBuffer();
        if (readHeader && !readBin) {
            readAttr |= 0x20;
        }
        this.writeHeader(policy, readAttr, writeAttr, fieldCount, operations.length);
        this.writeKey(policy, key);
        for (Operation operation : operations) {
            this.writeOperation(operation);
        }
        this.end();
    }

    public final void setUdf(WritePolicy policy, Key key, String packageName, String functionName, Value[] args) throws AerospikeException {
        this.begin();
        int fieldCount = this.estimateKeySize(policy, key);
        byte[] argBytes = Packer.pack(args);
        this.sizeBuffer();
        this.writeHeader(policy, 0, 1, fieldCount += this.estimateUdfSize(packageName, functionName, argBytes), 0);
        this.writeKey(policy, key);
        this.writeField(packageName, 30);
        this.writeField(functionName, 31);
        this.writeField(argBytes, 32);
        this.end();
    }

    public final void setBatchExists(Policy policy, Key[] keys2, BatchNode.BatchNamespace batch) {
        this.begin();
        int byteSize = batch.offsetsSize * 20;
        this.dataOffset += Buffer.estimateSizeUtf8(batch.namespace) + 5 + byteSize + 5;
        this.sizeBuffer();
        this.writeHeader(policy, 33, 0, 2, 0);
        this.writeField(batch.namespace, 0);
        this.writeFieldHeader(byteSize, 6);
        int[] offsets = batch.offsets;
        int max = batch.offsetsSize;
        for (int i = 0; i < max; ++i) {
            Key key = keys2[offsets[i]];
            byte[] digest = key.digest;
            System.arraycopy(digest, 0, this.dataBuffer, this.dataOffset, digest.length);
            this.dataOffset += digest.length;
        }
        this.end();
    }

    public final void setBatchGet(Policy policy, Key[] keys2, BatchNode.BatchNamespace batch, HashSet<String> binNames, int readAttr) {
        this.begin();
        int byteSize = batch.offsetsSize * 20;
        this.dataOffset += Buffer.estimateSizeUtf8(batch.namespace) + 5 + byteSize + 5;
        if (binNames != null) {
            for (String binName : binNames) {
                this.estimateOperationSize(binName);
            }
        }
        this.sizeBuffer();
        int operationCount = binNames == null ? 0 : binNames.size();
        this.writeHeader(policy, readAttr, 0, 2, operationCount);
        this.writeField(batch.namespace, 0);
        this.writeFieldHeader(byteSize, 6);
        int[] offsets = batch.offsets;
        int max = batch.offsetsSize;
        for (int i = 0; i < max; ++i) {
            Key key = keys2[offsets[i]];
            byte[] digest = key.digest;
            System.arraycopy(digest, 0, this.dataBuffer, this.dataOffset, digest.length);
            this.dataOffset += digest.length;
        }
        if (binNames != null) {
            for (String binName : binNames) {
                this.writeOperation(binName, Operation.Type.READ);
            }
        }
        this.end();
    }

    public final void setScan(ScanPolicy policy, String namespace, String setName, String[] binNames, long taskId) {
        this.begin();
        int fieldCount = 0;
        if (namespace != null) {
            this.dataOffset += Buffer.estimateSizeUtf8(namespace) + 5;
            ++fieldCount;
        }
        if (setName != null) {
            this.dataOffset += Buffer.estimateSizeUtf8(setName) + 5;
            ++fieldCount;
        }
        this.dataOffset += 7;
        ++fieldCount;
        this.dataOffset += 13;
        ++fieldCount;
        if (binNames != null) {
            for (String binName : binNames) {
                this.estimateOperationSize(binName);
            }
        }
        this.sizeBuffer();
        int readAttr = 1;
        if (!policy.includeBinData) {
            readAttr = (byte)(readAttr | 0x20);
        }
        int operationCount = binNames == null ? 0 : binNames.length;
        this.writeHeader(policy, readAttr, 0, fieldCount, operationCount);
        if (namespace != null) {
            this.writeField(namespace, 0);
        }
        if (setName != null) {
            this.writeField(setName, 1);
        }
        this.writeFieldHeader(2, 8);
        byte priority = (byte)policy.priority.ordinal();
        priority = (byte)(priority << 4);
        if (policy.failOnClusterChange) {
            priority = (byte)(priority | 8);
        }
        this.dataBuffer[this.dataOffset++] = priority;
        this.dataBuffer[this.dataOffset++] = (byte)policy.scanPercent;
        this.writeFieldHeader(8, 7);
        Buffer.longToBytes(taskId, this.dataBuffer, this.dataOffset);
        this.dataOffset += 8;
        if (binNames != null) {
            for (String binName : binNames) {
                this.writeOperation(binName, Operation.Type.READ);
            }
        }
        this.end();
    }

    /*
     * WARNING - void declaration
     */
    public final void setQuery(Policy policy, Statement statement, boolean write2) {
        int len$;
        int operationCount;
        byte[] functionArgBuffer = null;
        int fieldCount = 0;
        int filterSize = 0;
        int binNameSize = 0;
        this.begin();
        if (statement.getNamespace() != null) {
            this.dataOffset += Buffer.estimateSizeUtf8(statement.getNamespace()) + 5;
            ++fieldCount;
        }
        if (statement.getIndexName() != null) {
            this.dataOffset += Buffer.estimateSizeUtf8(statement.getIndexName()) + 5;
            ++fieldCount;
        }
        if (statement.getSetName() != null) {
            this.dataOffset += Buffer.estimateSizeUtf8(statement.getSetName()) + 5;
            ++fieldCount;
        }
        this.dataOffset += 13;
        ++fieldCount;
        Filter[] filters = statement.getFilters();
        String[] binNames = statement.getBinNames();
        if (filters != null) {
            IndexCollectionType type;
            if (filters.length >= 1 && (type = filters[0].getCollectionType()) != IndexCollectionType.DEFAULT) {
                this.dataOffset += 6;
                ++fieldCount;
            }
            this.dataOffset += 5;
            ++filterSize;
            for (Filter filter : filters) {
                filterSize += filter.estimateSize();
            }
            this.dataOffset += filterSize;
            ++fieldCount;
            if (binNames != null) {
                this.dataOffset += 5;
                ++binNameSize;
                for (String string : binNames) {
                    binNameSize += Buffer.estimateSizeUtf8(string) + 1;
                }
                this.dataOffset += binNameSize;
                ++fieldCount;
            }
        } else {
            this.dataOffset += 7;
            ++fieldCount;
        }
        if (statement.getFunctionName() != null) {
            this.dataOffset += 6;
            this.dataOffset += Buffer.estimateSizeUtf8(statement.getPackageName()) + 5;
            this.dataOffset += Buffer.estimateSizeUtf8(statement.getFunctionName()) + 5;
            functionArgBuffer = statement.getFunctionArgs().length > 0 ? Packer.pack(statement.getFunctionArgs()) : new byte[]{};
            this.dataOffset += 5 + functionArgBuffer.length;
            fieldCount += 4;
        }
        if (filters == null && binNames != null) {
            for (String string : binNames) {
                this.estimateOperationSize(string);
            }
        }
        this.sizeBuffer();
        int n = operationCount = filters == null && binNames != null ? binNames.length : 0;
        if (write2) {
            this.writeHeader((WritePolicy)policy, 1, 1, fieldCount, operationCount);
        } else {
            this.writeHeader(policy, 1, 0, fieldCount, operationCount);
        }
        if (statement.getNamespace() != null) {
            this.writeField(statement.getNamespace(), 0);
        }
        if (statement.getIndexName() != null) {
            this.writeField(statement.getIndexName(), 21);
        }
        if (statement.getSetName() != null) {
            this.writeField(statement.getSetName(), 1);
        }
        this.writeFieldHeader(8, 7);
        Buffer.longToBytes(statement.getTaskId(), this.dataBuffer, this.dataOffset);
        this.dataOffset += 8;
        if (filters != null) {
            void var13_23;
            IndexCollectionType type;
            if (filters.length >= 1 && (type = filters[0].getCollectionType()) != IndexCollectionType.DEFAULT) {
                this.writeFieldHeader(1, 26);
                this.dataBuffer[this.dataOffset++] = (byte)type.ordinal();
            }
            this.writeFieldHeader(filterSize, 22);
            this.dataBuffer[this.dataOffset++] = (byte)filters.length;
            Object[] arr$ = filters;
            len$ = arr$.length;
            boolean bl = false;
            while (var13_23 < len$) {
                Filter filter = arr$[var13_23];
                this.dataOffset = filter.write(this.dataBuffer, this.dataOffset);
                ++var13_23;
            }
            if (binNames != null) {
                void var13_25;
                this.writeFieldHeader(binNameSize, 40);
                this.dataBuffer[this.dataOffset++] = (byte)binNames.length;
                arr$ = binNames;
                len$ = arr$.length;
                boolean bl2 = false;
                while (var13_25 < len$) {
                    Object object = arr$[var13_25];
                    int len2 = Buffer.stringToUtf8((String)object, this.dataBuffer, this.dataOffset + 1);
                    this.dataBuffer[this.dataOffset] = (byte)len2;
                    this.dataOffset += len2 + 1;
                    ++var13_25;
                }
            }
        } else {
            this.writeFieldHeader(2, 8);
            byte priority = (byte)policy.priority.ordinal();
            priority = (byte)(priority << 4);
            this.dataBuffer[this.dataOffset++] = priority;
            this.dataBuffer[this.dataOffset++] = 100;
        }
        if (statement.getFunctionName() != null) {
            this.writeFieldHeader(1, 33);
            this.dataBuffer[this.dataOffset++] = statement.returnData() ? 1 : 2;
            this.writeField(statement.getPackageName(), 30);
            this.writeField(statement.getFunctionName(), 31);
            this.writeField(functionArgBuffer, 32);
        }
        if (filters == null && binNames != null) {
            void var13_27;
            String[] arr$ = binNames;
            len$ = arr$.length;
            boolean bl = false;
            while (var13_27 < len$) {
                String string = arr$[var13_27];
                this.writeOperation(string, Operation.Type.READ);
                ++var13_27;
            }
        }
        this.end();
    }

    private final int estimateKeySize(Policy policy, Key key) {
        int fieldCount = 0;
        if (key.namespace != null) {
            this.dataOffset += Buffer.estimateSizeUtf8(key.namespace) + 5;
            ++fieldCount;
        }
        if (key.setName != null) {
            this.dataOffset += Buffer.estimateSizeUtf8(key.setName) + 5;
            ++fieldCount;
        }
        this.dataOffset += key.digest.length + 5;
        ++fieldCount;
        if (policy.sendKey) {
            this.dataOffset += key.userKey.estimateSize() + 5 + 1;
            ++fieldCount;
        }
        return fieldCount;
    }

    private final int estimateUdfSize(String packageName, String functionName, byte[] bytes) {
        this.dataOffset += Buffer.estimateSizeUtf8(packageName) + 5;
        this.dataOffset += Buffer.estimateSizeUtf8(functionName) + 5;
        this.dataOffset += bytes.length + 5;
        return 3;
    }

    private final void estimateOperationSize(Bin bin) throws AerospikeException {
        this.dataOffset += Buffer.estimateSizeUtf8(bin.name) + 8;
        this.dataOffset += bin.value.estimateSize();
    }

    private final void estimateOperationSize(Operation operation) throws AerospikeException {
        this.dataOffset += Buffer.estimateSizeUtf8(operation.binName) + 8;
        this.dataOffset += operation.binValue.estimateSize();
    }

    protected final void estimateOperationSize(String binName) {
        this.dataOffset += Buffer.estimateSizeUtf8(binName) + 8;
    }

    private final void estimateOperationSize() {
        this.dataOffset += 8;
    }

    protected final void writeHeader(WritePolicy policy, int readAttr, int writeAttr, int fieldCount, int operationCount) {
        int generation = 0;
        int infoAttr = 0;
        switch (policy.recordExistsAction) {
            case UPDATE: {
                break;
            }
            case UPDATE_ONLY: {
                infoAttr |= 8;
                break;
            }
            case REPLACE: {
                infoAttr |= 0x10;
                break;
            }
            case REPLACE_ONLY: {
                infoAttr |= 0x20;
                break;
            }
            case CREATE_ONLY: {
                writeAttr |= 0x20;
            }
        }
        switch (policy.generationPolicy) {
            case NONE: {
                break;
            }
            case EXPECT_GEN_EQUAL: {
                generation = policy.generation;
                writeAttr |= 4;
                break;
            }
            case EXPECT_GEN_GT: {
                generation = policy.generation;
                writeAttr |= 8;
            }
        }
        if (policy.commitLevel == CommitLevel.COMMIT_MASTER) {
            infoAttr |= 2;
        }
        if (policy.consistencyLevel == ConsistencyLevel.CONSISTENCY_ALL) {
            readAttr |= 0x40;
        }
        this.dataBuffer[8] = 22;
        this.dataBuffer[9] = (byte)readAttr;
        this.dataBuffer[10] = (byte)writeAttr;
        this.dataBuffer[11] = (byte)infoAttr;
        this.dataBuffer[12] = 0;
        this.dataBuffer[13] = 0;
        Buffer.intToBytes(generation, this.dataBuffer, 14);
        Buffer.intToBytes(policy.expiration, this.dataBuffer, 18);
        this.dataBuffer[22] = 0;
        this.dataBuffer[23] = 0;
        this.dataBuffer[24] = 0;
        this.dataBuffer[25] = 0;
        Buffer.shortToBytes(fieldCount, this.dataBuffer, 26);
        Buffer.shortToBytes(operationCount, this.dataBuffer, 28);
        this.dataOffset = 30;
    }

    protected final void writeHeader(Policy policy, int readAttr, int writeAttr, int fieldCount, int operationCount) {
        if (policy.consistencyLevel == ConsistencyLevel.CONSISTENCY_ALL) {
            readAttr |= 0x40;
        }
        this.dataBuffer[8] = 22;
        this.dataBuffer[9] = (byte)readAttr;
        this.dataBuffer[10] = (byte)writeAttr;
        for (int i = 11; i < 26; ++i) {
            this.dataBuffer[i] = 0;
        }
        Buffer.shortToBytes(fieldCount, this.dataBuffer, 26);
        Buffer.shortToBytes(operationCount, this.dataBuffer, 28);
        this.dataOffset = 30;
    }

    private final void writeKey(Policy policy, Key key) {
        if (key.namespace != null) {
            this.writeField(key.namespace, 0);
        }
        if (key.setName != null) {
            this.writeField(key.setName, 1);
        }
        this.writeField(key.digest, 4);
        if (policy.sendKey) {
            this.writeField(key.userKey, 2);
        }
    }

    private final void writeOperation(Bin bin, Operation.Type operation) throws AerospikeException {
        int nameLength = Buffer.stringToUtf8(bin.name, this.dataBuffer, this.dataOffset + 8);
        int valueLength = bin.value.write(this.dataBuffer, this.dataOffset + 8 + nameLength);
        Buffer.intToBytes(nameLength + valueLength + 4, this.dataBuffer, this.dataOffset);
        this.dataOffset += 4;
        this.dataBuffer[this.dataOffset++] = (byte)operation.protocolType;
        this.dataBuffer[this.dataOffset++] = (byte)bin.value.getType();
        this.dataBuffer[this.dataOffset++] = 0;
        this.dataBuffer[this.dataOffset++] = (byte)nameLength;
        this.dataOffset += nameLength + valueLength;
    }

    private final void writeOperation(Operation operation) throws AerospikeException {
        int nameLength = Buffer.stringToUtf8(operation.binName, this.dataBuffer, this.dataOffset + 8);
        int valueLength = operation.binValue.write(this.dataBuffer, this.dataOffset + 8 + nameLength);
        Buffer.intToBytes(nameLength + valueLength + 4, this.dataBuffer, this.dataOffset);
        this.dataOffset += 4;
        this.dataBuffer[this.dataOffset++] = (byte)operation.type.protocolType;
        this.dataBuffer[this.dataOffset++] = (byte)operation.binValue.getType();
        this.dataBuffer[this.dataOffset++] = 0;
        this.dataBuffer[this.dataOffset++] = (byte)nameLength;
        this.dataOffset += nameLength + valueLength;
    }

    protected final void writeOperation(String name, Operation.Type operation) {
        int nameLength = Buffer.stringToUtf8(name, this.dataBuffer, this.dataOffset + 8);
        Buffer.intToBytes(nameLength + 4, this.dataBuffer, this.dataOffset);
        this.dataOffset += 4;
        this.dataBuffer[this.dataOffset++] = (byte)operation.protocolType;
        this.dataBuffer[this.dataOffset++] = 0;
        this.dataBuffer[this.dataOffset++] = 0;
        this.dataBuffer[this.dataOffset++] = (byte)nameLength;
        this.dataOffset += nameLength;
    }

    private final void writeOperation(Operation.Type operation) {
        Buffer.intToBytes(4, this.dataBuffer, this.dataOffset);
        this.dataOffset += 4;
        this.dataBuffer[this.dataOffset++] = (byte)operation.protocolType;
        this.dataBuffer[this.dataOffset++] = 0;
        this.dataBuffer[this.dataOffset++] = 0;
        this.dataBuffer[this.dataOffset++] = 0;
    }

    public final void writeField(Value value, int type) throws AerospikeException {
        int offset = this.dataOffset + 5;
        this.dataBuffer[offset++] = (byte)value.getType();
        int len2 = value.write(this.dataBuffer, offset) + 1;
        this.writeFieldHeader(len2, type);
        this.dataOffset += len2;
    }

    public final void writeField(String str, int type) {
        int len2 = Buffer.stringToUtf8(str, this.dataBuffer, this.dataOffset + 5);
        this.writeFieldHeader(len2, type);
        this.dataOffset += len2;
    }

    public final void writeField(byte[] bytes, int type) {
        System.arraycopy(bytes, 0, this.dataBuffer, this.dataOffset + 5, bytes.length);
        this.writeFieldHeader(bytes.length, type);
        this.dataOffset += bytes.length;
    }

    public final void writeFieldHeader(int size, int type) {
        Buffer.intToBytes(size + 1, this.dataBuffer, this.dataOffset);
        this.dataOffset += 4;
        this.dataBuffer[this.dataOffset++] = (byte)type;
    }

    protected final void begin() {
        this.dataOffset = 30;
    }

    protected final void sizeBuffer() {
        this.dataBuffer = ThreadLocalData.getBuffer();
        if (this.dataOffset > this.dataBuffer.length) {
            this.dataBuffer = ThreadLocalData.resizeBuffer(this.dataOffset);
        }
    }

    protected final void sizeBuffer(int size) {
        if (size > this.dataBuffer.length) {
            this.dataBuffer = ThreadLocalData.resizeBuffer(size);
        }
    }

    protected final void end() {
        long size = (long)(this.dataOffset - 8) | 0x200000000000000L | 0x3000000000000L;
        Buffer.longToBytes(size, this.dataBuffer, 0);
    }

    protected abstract Policy getPolicy();

    protected abstract void writeBuffer() throws AerospikeException;
}

