/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.lua;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.Value;
import com.aerospike.client.command.Buffer;
import com.aerospike.client.lua.LuaAerospikeLib;
import com.aerospike.client.lua.LuaBytes;
import com.aerospike.client.lua.LuaBytesLib;
import com.aerospike.client.lua.LuaCache;
import com.aerospike.client.lua.LuaJavaBlob;
import com.aerospike.client.lua.LuaList;
import com.aerospike.client.lua.LuaListLib;
import com.aerospike.client.lua.LuaMap;
import com.aerospike.client.lua.LuaMapLib;
import com.aerospike.client.lua.LuaStreamLib;
import com.aerospike.client.lua.LuaUnpacker;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.luaj.vm2.Globals;
import org.luaj.vm2.LuaClosure;
import org.luaj.vm2.LuaDouble;
import org.luaj.vm2.LuaInteger;
import org.luaj.vm2.LuaString;
import org.luaj.vm2.LuaTable;
import org.luaj.vm2.LuaValue;
import org.luaj.vm2.Prototype;
import org.luaj.vm2.compiler.LuaC;
import org.luaj.vm2.lib.CoroutineLib;
import org.luaj.vm2.lib.DebugLib;
import org.luaj.vm2.lib.LibFunction;
import org.luaj.vm2.lib.PackageLib;
import org.luaj.vm2.lib.StringLib;
import org.luaj.vm2.lib.TableLib;
import org.luaj.vm2.lib.jse.JseBaseLib;
import org.luaj.vm2.lib.jse.JseIoLib;
import org.luaj.vm2.lib.jse.JseMathLib;
import org.luaj.vm2.lib.jse.JseOsLib;
import org.luaj.vm2.lib.jse.LuajavaLib;

public final class LuaInstance {
    private final Globals globals = new Globals();
    private final LuaTable loadedTable;

    public LuaInstance() throws AerospikeException {
        this.globals.load((LuaValue)new JseBaseLib());
        this.globals.load((LuaValue)new PackageLib());
        this.globals.load((LuaValue)new TableLib());
        this.globals.load((LuaValue)new StringLib());
        this.globals.load((LuaValue)new CoroutineLib());
        this.globals.load((LuaValue)new JseMathLib());
        this.globals.load((LuaValue)new JseIoLib());
        this.globals.load((LuaValue)new JseOsLib());
        this.globals.load((LuaValue)new LuajavaLib());
        this.globals.load((LuaValue)new DebugLib());
        LuaTable packageTable = (LuaTable)this.globals.get("package");
        this.loadedTable = (LuaTable)packageTable.get("loaded");
        this.globals.load((LuaValue)new LuaBytesLib(this));
        this.globals.load((LuaValue)new LuaListLib(this));
        this.globals.load((LuaValue)new LuaMapLib(this));
        this.globals.load((LuaValue)new LuaStreamLib(this));
        LuaC.install((Globals)this.globals);
        this.load("compat52", true);
        this.load("as", true);
        this.load("stream_ops", true);
        this.load("aerospike", true);
        this.globals.load((LuaValue)new LuaAerospikeLib(this));
    }

    public void registerPackage(String packageName, LuaTable table) {
        this.globals.set(packageName, (LuaValue)table);
        this.loadedTable.set(packageName, (LuaValue)LuaValue.TRUE);
    }

    public LuaValue getPackage(String packageName) {
        return this.globals.get(packageName);
    }

    public void load(LibFunction function) {
        this.globals.load((LuaValue)function);
    }

    public void load(String packageName, boolean system) throws AerospikeException {
        if (this.loadedTable.get(packageName).toboolean()) {
            return;
        }
        Prototype prototype = LuaCache.loadPackage(packageName, system);
        LuaClosure function = new LuaClosure(prototype, (LuaValue)this.globals);
        function.invoke();
        this.loadedTable.set(packageName, (LuaValue)LuaValue.TRUE);
    }

    public void call(String functionName, LuaValue[] args) {
        this.globals.get(functionName).invoke(args);
    }

    public LuaValue getFunction(String functionName) {
        return this.globals.get(functionName);
    }

    public LuaValue getLuaValue(int type, byte[] buf, int offset, int len2) throws AerospikeException {
        if (len2 <= 0) {
            return LuaValue.NIL;
        }
        switch (type) {
            case 3: {
                byte[] copy = new byte[len2];
                System.arraycopy(buf, offset, copy, 0, len2);
                return LuaString.valueOf((byte[])copy, (int)0, (int)len2);
            }
            case 1: {
                if (len2 <= 4) {
                    return LuaInteger.valueOf((int)Buffer.bytesToInt(buf, offset));
                }
                if (len2 <= 8) {
                    return LuaInteger.valueOf((long)Buffer.bytesToLong(buf, offset));
                }
                throw new AerospikeException("Lua BigInteger not implemented.");
            }
            case 4: {
                byte[] blob = new byte[len2];
                System.arraycopy(buf, offset, blob, 0, len2);
                return new LuaBytes(this, blob);
            }
            case 7: {
                Object object = Buffer.bytesToObject(buf, offset, len2);
                return new LuaJavaBlob(object);
            }
            case 20: {
                LuaUnpacker unpacker = new LuaUnpacker(this, buf, offset, len2);
                return (LuaValue)unpacker.unpackList();
            }
            case 19: {
                LuaUnpacker unpacker = new LuaUnpacker(this, buf, offset, len2);
                return (LuaValue)unpacker.unpackMap();
            }
        }
        return LuaValue.NIL;
    }

    public LuaList getLuaList(List<?> list) {
        ArrayList<LuaValue> luaList = new ArrayList<LuaValue>();
        for (Object obj : list) {
            luaList.add(this.getLuaValue(obj));
        }
        return new LuaList(this, luaList);
    }

    public LuaList getLuaList(Value[] array) {
        ArrayList<LuaValue> luaList = new ArrayList<LuaValue>();
        for (Value value : array) {
            luaList.add(value.getLuaValue(this));
        }
        return new LuaList(this, luaList);
    }

    public LuaMap getLuaMap(Map<?, ?> map) {
        HashMap<LuaValue, LuaValue> luaMap = new HashMap<LuaValue, LuaValue>(map.size());
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            LuaValue key = this.getLuaValue(entry.getKey());
            LuaValue value = this.getLuaValue(entry.getValue());
            luaMap.put(key, value);
        }
        return new LuaMap(this, luaMap);
    }

    public LuaValue getLuaValue(Object obj) {
        if (obj == null) {
            return LuaValue.NIL;
        }
        if (obj instanceof LuaValue) {
            return (LuaValue)obj;
        }
        if (obj instanceof Value) {
            Value value = (Value)obj;
            return value.getLuaValue(this);
        }
        if (obj instanceof byte[]) {
            return new LuaBytes(this, (byte[])obj);
        }
        if (obj instanceof String) {
            return LuaString.valueOf((String)((String)obj));
        }
        if (obj instanceof Integer) {
            return LuaInteger.valueOf((int)((Integer)obj));
        }
        if (obj instanceof Long) {
            return LuaInteger.valueOf((long)((Long)obj));
        }
        if (obj instanceof Double) {
            return LuaDouble.valueOf((double)((Double)obj));
        }
        if (obj instanceof Float) {
            return LuaDouble.valueOf((double)((Float)obj).floatValue());
        }
        if (obj instanceof List) {
            return this.getLuaList((List)obj);
        }
        if (obj instanceof Map) {
            return this.getLuaMap((Map)obj);
        }
        return LuaValue.NIL;
    }
}

