/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.query;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.cluster.Cluster;
import com.aerospike.client.cluster.Node;
import com.aerospike.client.command.MultiCommand;
import com.aerospike.client.policy.QueryPolicy;
import com.aerospike.client.query.Statement;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class QueryExecutor {
    protected final QueryPolicy policy;
    protected final Statement statement;
    private final Node[] nodes;
    protected final ExecutorService threadPool;
    private final QueryThread[] threads;
    private final AtomicInteger completedCount;
    private final AtomicBoolean done;
    protected volatile Exception exception;
    private final int maxConcurrentNodes;

    public QueryExecutor(Cluster cluster, QueryPolicy policy, Statement statement, Node node) throws AerospikeException {
        this.policy = policy;
        this.statement = statement;
        this.completedCount = new AtomicInteger();
        this.done = new AtomicBoolean();
        if (node == null) {
            this.nodes = cluster.getNodes();
            if (this.nodes.length == 0) {
                throw new AerospikeException(11, "Query failed because cluster is empty.");
            }
        } else {
            this.nodes = new Node[]{node};
        }
        this.threadPool = cluster.getThreadPool();
        this.threads = new QueryThread[this.nodes.length];
        this.maxConcurrentNodes = policy.maxConcurrentNodes == 0 || policy.maxConcurrentNodes >= this.threads.length ? this.threads.length : policy.maxConcurrentNodes;
    }

    protected final void startThreads() {
        int i;
        for (i = 0; i < this.nodes.length; ++i) {
            MultiCommand command = this.createCommand(this.nodes[i]);
            this.threads[i] = new QueryThread(command);
        }
        for (i = 0; i < this.maxConcurrentNodes; ++i) {
            this.threadPool.execute(this.threads[i]);
        }
    }

    private final void threadCompleted() {
        int finished = this.completedCount.incrementAndGet();
        if (finished < this.threads.length) {
            int nextThread = finished + this.maxConcurrentNodes - 1;
            if (nextThread < this.threads.length && !this.done.get()) {
                this.threadPool.execute(this.threads[nextThread]);
            }
        } else if (this.done.compareAndSet(false, true)) {
            this.sendCompleted();
        }
    }

    protected final void stopThreads(Exception cause) {
        if (this.done.compareAndSet(false, true)) {
            this.exception = cause;
            for (QueryThread thread : this.threads) {
                thread.stop();
            }
            this.sendCancel();
        }
    }

    protected final void checkForException() throws AerospikeException {
        if (this.exception != null) {
            if (this.exception instanceof AerospikeException) {
                throw (AerospikeException)this.exception;
            }
            throw new AerospikeException(this.exception);
        }
    }

    protected abstract MultiCommand createCommand(Node var1);

    protected abstract void sendCancel();

    protected abstract void sendCompleted();

    private final class QueryThread
    implements Runnable {
        private final MultiCommand command;

        public QueryThread(MultiCommand command) {
            this.command = command;
        }

        @Override
        public void run() {
            try {
                if (this.command.isValid()) {
                    this.command.execute();
                }
                QueryExecutor.this.threadCompleted();
            }
            catch (Exception e) {
                QueryExecutor.this.stopThreads(e);
            }
        }

        public void stop() {
            this.command.stop();
        }
    }
}

