/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.query;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.Key;
import com.aerospike.client.Log;
import com.aerospike.client.Record;
import com.aerospike.client.query.KeyRecord;
import com.aerospike.client.query.QueryExecutor;
import java.io.Closeable;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;

public final class RecordSet
implements Closeable {
    public static final KeyRecord END = new KeyRecord(null, null);
    private final QueryExecutor executor;
    private final BlockingQueue<KeyRecord> queue;
    private KeyRecord record;
    private volatile boolean valid = true;

    protected RecordSet(QueryExecutor executor, int capacity) {
        this.executor = executor;
        this.queue = new ArrayBlockingQueue<KeyRecord>(capacity);
    }

    public final boolean next() throws AerospikeException {
        if (!this.valid) {
            this.executor.checkForException();
            return false;
        }
        try {
            this.record = this.queue.take();
        }
        catch (InterruptedException ie) {
            this.valid = false;
            if (Log.debugEnabled()) {
                Log.debug("RecordSet " + this.executor.statement.taskId + " take interrupted");
            }
            return false;
        }
        if (this.record == END) {
            this.valid = false;
            this.executor.checkForException();
            return false;
        }
        return true;
    }

    @Override
    public final void close() {
        this.valid = false;
        if (this.record != END && this.queue.poll() != END) {
            this.executor.stopThreads(new AerospikeException.QueryTerminated());
        }
    }

    public final Key getKey() {
        return this.record.key;
    }

    public final Record getRecord() {
        return this.record.record;
    }

    protected final boolean put(KeyRecord record) {
        if (!this.valid) {
            return false;
        }
        try {
            this.queue.put(record);
            return true;
        }
        catch (InterruptedException ie) {
            if (Log.debugEnabled()) {
                Log.debug("RecordSet " + this.executor.statement.taskId + " put interrupted");
            }
            if (this.valid) {
                this.abort();
            }
            return false;
        }
    }

    protected final void abort() {
        this.valid = false;
        this.queue.clear();
        while (!this.queue.offer(END)) {
            if (this.queue.poll() != null) continue;
            if (!Log.debugEnabled()) break;
            Log.debug("RecordSet " + this.executor.statement.taskId + " both offer and poll failed on abort");
            break;
        }
    }
}

