/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.util;

import com.aerospike.client.AerospikeException;
import gnu.crypto.util.Base64;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public final class Util {
    public static void sleep(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static String getErrorMessage(Exception e) {
        Throwable cause = e.getCause();
        if (e instanceof SocketException || e instanceof AerospikeException.Connection || cause instanceof SocketTimeoutException) {
            return e.getMessage();
        }
        if (e instanceof EOFException || cause instanceof EOFException) {
            return EOFException.class.getName();
        }
        StringWriter sw = new StringWriter(1000);
        PrintWriter pw = new PrintWriter(sw);
        e.printStackTrace(pw);
        return sw.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readFileEncodeBase64(String path) throws AerospikeException {
        try {
            File file = new File(path);
            byte[] bytes = new byte[(int)file.length()];
            FileInputStream in = new FileInputStream(file);
            try {
                int len2 = 0;
                for (int pos = 0; pos < bytes.length; pos += len2) {
                    len2 = in.read(bytes, pos, bytes.length - pos);
                }
            }
            finally {
                in.close();
            }
            return Base64.encode((byte[])bytes, (int)0, (int)bytes.length, (boolean)false);
        }
        catch (Exception e) {
            throw new AerospikeException("Failed to read " + path, e);
        }
    }

    public static long toTimeStamp(String dateTime, SimpleDateFormat format, int timeZoneOffset) throws ParseException {
        Date formatDate = format.parse(dateTime);
        long miliSecondForDate = formatDate.getTime() - (long)timeZoneOffset;
        return miliSecondForDate / 1000L;
    }

    public static long toTimeStamp(String dateTime, String pattern, int timeZoneOffset) throws ParseException {
        SimpleDateFormat format = new SimpleDateFormat(pattern);
        return Util.toTimeStamp(dateTime, format, timeZoneOffset);
    }

    public static String fromTimeStamp(long timeStamp, SimpleDateFormat format) {
        Date formatDate = new Date(timeStamp);
        return format.format(formatDate);
    }

    public static String fromTimeStamp(long timeStamp, String pattern) {
        SimpleDateFormat format = new SimpleDateFormat(pattern);
        return Util.fromTimeStamp(timeStamp, format);
    }

    public static long toLong(Object obj) {
        return obj != null ? (Long)obj : 0L;
    }

    public static int toInt(Object obj) {
        return (int)Util.toLong(obj);
    }

    public static short toShort(Object obj) {
        return (short)Util.toLong(obj);
    }

    public static byte toByte(Object obj) {
        return (byte)Util.toLong(obj);
    }

    public static boolean toBoolean(Object obj) {
        return Util.toLong(obj) != 0L;
    }
}

