/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client;

import com.aerospike.client.ResultCode;
import com.aerospike.client.cluster.Node;
import com.aerospike.client.cluster.Partition;
import com.aerospike.client.policy.Policy;

public class AerospikeException
extends RuntimeException {
    private static final long serialVersionUID = 1L;
    protected Node node;
    protected int resultCode = -1;
    protected int iteration = -1;
    protected boolean inDoubt;

    public AerospikeException(int resultCode, String message) {
        super(message);
        this.resultCode = resultCode;
    }

    public AerospikeException(int resultCode, Throwable e) {
        super(e);
        this.resultCode = resultCode;
    }

    public AerospikeException(int resultCode) {
        this.resultCode = resultCode;
    }

    public AerospikeException(int resultCode, boolean inDoubt) {
        this.resultCode = resultCode;
        this.inDoubt = inDoubt;
    }

    public AerospikeException(String message, Throwable e) {
        super(message, e);
    }

    public AerospikeException(String message) {
        super(message);
    }

    public AerospikeException(Throwable e) {
        super(e);
    }

    @Override
    public String getMessage() {
        StringBuilder sb = new StringBuilder();
        String message = super.getMessage();
        sb.append("Error ");
        sb.append(this.resultCode);
        if (this.inDoubt) {
            sb.append("(inDoubt)");
        }
        if (this.node != null) {
            sb.append(" from ");
            sb.append(this.node.toString());
        }
        sb.append(": ");
        if (message != null) {
            sb.append(message);
        } else {
            sb.append(ResultCode.getResultString(this.resultCode));
        }
        if (this.iteration > 1) {
            sb.append(System.lineSeparator());
            sb.append("iteration=" + this.iteration);
        }
        return sb.toString();
    }

    public final boolean keepConnection() {
        return ResultCode.keepConnection(this.resultCode);
    }

    public final Node getNode() {
        return this.node;
    }

    public final void setNode(Node node) {
        this.node = node;
    }

    public final int getResultCode() {
        return this.resultCode;
    }

    public final int getIteration() {
        return this.iteration;
    }

    public final void setIteration(int iteration) {
        this.iteration = iteration;
    }

    public final boolean getInDoubt() {
        return this.inDoubt;
    }

    public final void setInDoubt(boolean isRead, int commandSentCounter) {
        if (!(isRead || commandSentCounter <= 1 && (commandSentCounter != 1 || this.resultCode != 9 && this.resultCode > 0))) {
            this.inDoubt = true;
        }
    }

    public static final class AsyncQueueFull
    extends AerospikeException {
        private static final long serialVersionUID = 1L;

        public AsyncQueueFull() {
            super(-9);
        }
    }

    public static final class QueryTerminated
    extends AerospikeException {
        private static final long serialVersionUID = 1L;

        public QueryTerminated() {
            super(-5);
        }

        public QueryTerminated(Exception e) {
            super(-5, (Throwable)e);
        }
    }

    public static final class ScanTerminated
    extends AerospikeException {
        private static final long serialVersionUID = 1L;

        public ScanTerminated() {
            super(-4);
        }

        public ScanTerminated(Exception e) {
            super(-4, (Throwable)e);
        }
    }

    public static final class InvalidNode
    extends AerospikeException {
        private static final long serialVersionUID = 1L;

        public InvalidNode(int clusterSize, Partition partition) {
            super(-3, clusterSize == 0 ? "Cluster is empty" : "Node not found for partition " + partition);
        }

        public InvalidNode(String message) {
            super(-3, message);
        }
    }

    public static final class Connection
    extends AerospikeException {
        private static final long serialVersionUID = 1L;

        public Connection(String message) {
            super(-8, message);
        }

        public Connection(Exception e) {
            super(-8, (Throwable)e);
        }

        public Connection(int resultCode, String message) {
            super(resultCode, message);
        }
    }

    public static final class Parse
    extends AerospikeException {
        private static final long serialVersionUID = 1L;

        public Parse(String message) {
            super(-2, message);
        }
    }

    public static final class Serialize
    extends AerospikeException {
        private static final long serialVersionUID = 1L;

        public Serialize(Exception e) {
            super(-10, (Throwable)e);
        }
    }

    public static final class Timeout
    extends AerospikeException {
        private static final long serialVersionUID = 1L;
        public int socketTimeout;
        public int timeout;
        public boolean client;

        public Timeout(int totalTimeout, boolean inDoubt) {
            super(9, inDoubt);
            this.socketTimeout = 0;
            this.timeout = totalTimeout;
            this.client = true;
        }

        public Timeout(Policy policy, boolean client) {
            super(9);
            this.socketTimeout = policy.socketTimeout;
            this.timeout = policy.totalTimeout;
            this.client = client;
        }

        @Override
        public String getMessage() {
            if (this.iteration == -1) {
                return "Client timeout: " + this.timeout;
            }
            String type = this.client ? "Client" : "Server";
            return type + " timeout: socket=" + this.socketTimeout + " total=" + this.timeout + " iteration=" + this.iteration + " node=" + this.node + " inDoubt=" + this.inDoubt;
        }
    }
}

