/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client;

public final class ResultCode {
    public static final int SERIALIZE_ERROR = -10;
    public static final int ASYNC_QUEUE_FULL = -9;
    public static final int SERVER_NOT_AVAILABLE = -8;
    public static final int NO_MORE_CONNECTIONS = -7;
    public static final int COMMAND_REJECTED = -6;
    public static final int QUERY_TERMINATED = -5;
    public static final int SCAN_TERMINATED = -4;
    public static final int INVALID_NODE_ERROR = -3;
    public static final int PARSE_ERROR = -2;
    public static final int CLIENT_ERROR = -1;
    public static final int OK = 0;
    public static final int SERVER_ERROR = 1;
    public static final int KEY_NOT_FOUND_ERROR = 2;
    public static final int GENERATION_ERROR = 3;
    public static final int PARAMETER_ERROR = 4;
    public static final int KEY_EXISTS_ERROR = 5;
    public static final int BIN_EXISTS_ERROR = 6;
    public static final int CLUSTER_KEY_MISMATCH = 7;
    public static final int SERVER_MEM_ERROR = 8;
    public static final int TIMEOUT = 9;
    public static final int ALWAYS_FORBIDDEN = 10;
    public static final int PARTITION_UNAVAILABLE = 11;
    public static final int BIN_TYPE_ERROR = 12;
    public static final int RECORD_TOO_BIG = 13;
    public static final int KEY_BUSY = 14;
    public static final int SCAN_ABORT = 15;
    public static final int UNSUPPORTED_FEATURE = 16;
    public static final int BIN_NOT_FOUND = 17;
    public static final int DEVICE_OVERLOAD = 18;
    public static final int KEY_MISMATCH = 19;
    public static final int INVALID_NAMESPACE = 20;
    public static final int BIN_NAME_TOO_LONG = 21;
    public static final int FAIL_FORBIDDEN = 22;
    public static final int ELEMENT_NOT_FOUND = 23;
    public static final int ELEMENT_EXISTS = 24;
    public static final int QUERY_END = 50;
    public static final int SECURITY_NOT_SUPPORTED = 51;
    public static final int SECURITY_NOT_ENABLED = 52;
    public static final int SECURITY_SCHEME_NOT_SUPPORTED = 53;
    public static final int INVALID_COMMAND = 54;
    public static final int INVALID_FIELD = 55;
    public static final int ILLEGAL_STATE = 56;
    public static final int INVALID_USER = 60;
    public static final int USER_ALREADY_EXISTS = 61;
    public static final int INVALID_PASSWORD = 62;
    public static final int EXPIRED_PASSWORD = 63;
    public static final int FORBIDDEN_PASSWORD = 64;
    public static final int INVALID_CREDENTIAL = 65;
    public static final int INVALID_ROLE = 70;
    public static final int ROLE_ALREADY_EXISTS = 71;
    public static final int INVALID_PRIVILEGE = 72;
    public static final int NOT_AUTHENTICATED = 80;
    public static final int ROLE_VIOLATION = 81;
    public static final int UDF_BAD_RESPONSE = 100;
    public static final int LARGE_ITEM_NOT_FOUND = 125;
    public static final int BATCH_DISABLED = 150;
    public static final int BATCH_MAX_REQUESTS_EXCEEDED = 151;
    public static final int BATCH_QUEUES_FULL = 152;
    public static final int INDEX_ALREADY_EXISTS = 200;
    public static final int INDEX_FOUND = 200;
    public static final int INDEX_NOTFOUND = 201;
    public static final int INDEX_OOM = 202;
    public static final int INDEX_NOTREADABLE = 203;
    public static final int INDEX_GENERIC = 204;
    public static final int INDEX_NAME_MAXLEN = 205;
    public static final int INDEX_MAXCOUNT = 206;
    public static final int QUERY_ABORTED = 210;
    public static final int QUERY_QUEUEFULL = 211;
    public static final int QUERY_TIMEOUT = 212;
    public static final int QUERY_GENERIC = 213;

    public static boolean keepConnection(int resultCode) {
        switch (resultCode) {
            case -10: 
            case -8: 
            case -5: 
            case -4: 
            case -2: 
            case -1: 
            case 0: 
            case 15: 
            case 210: {
                return false;
            }
        }
        return true;
    }

    public static String getResultString(int resultCode) {
        switch (resultCode) {
            case -10: {
                return "Serialize error";
            }
            case -9: {
                return "Async delay queue is full";
            }
            case -8: {
                return "Server not available";
            }
            case -7: {
                return "No more available connections";
            }
            case -6: {
                return "Command rejected";
            }
            case -5: {
                return "Query terminated";
            }
            case -4: {
                return "Scan terminated";
            }
            case -3: {
                return "Invalid node";
            }
            case -2: {
                return "Parse error";
            }
            case -1: {
                return "Client error";
            }
            case 0: {
                return "ok";
            }
            case 1: {
                return "Server error";
            }
            case 2: {
                return "Key not found";
            }
            case 3: {
                return "Generation error";
            }
            case 4: {
                return "Parameter error";
            }
            case 5: {
                return "Key already exists";
            }
            case 6: {
                return "Bin already exists";
            }
            case 7: {
                return "Cluster key mismatch";
            }
            case 8: {
                return "Server memory error";
            }
            case 9: {
                return "Timeout";
            }
            case 10: {
                return "Operation not allowed";
            }
            case 11: {
                return "Partition unavailable";
            }
            case 12: {
                return "Bin type error";
            }
            case 13: {
                return "Record too big";
            }
            case 14: {
                return "Hot key";
            }
            case 15: {
                return "Scan aborted";
            }
            case 16: {
                return "Unsupported Server Feature";
            }
            case 17: {
                return "Bin not found";
            }
            case 18: {
                return "Device overload";
            }
            case 19: {
                return "Key mismatch";
            }
            case 20: {
                return "Namespace not found";
            }
            case 21: {
                return "Bin name length greater than 14 characters or maximum bins exceeded";
            }
            case 22: {
                return "Operation not allowed at this time";
            }
            case 23: {
                return "Map key not found";
            }
            case 24: {
                return "Map key exists";
            }
            case 50: {
                return "Query end";
            }
            case 51: {
                return "Security not supported";
            }
            case 52: {
                return "Security not enabled";
            }
            case 53: {
                return "Security scheme not supported";
            }
            case 54: {
                return "Invalid command";
            }
            case 55: {
                return "Invalid field";
            }
            case 56: {
                return "Illegal state";
            }
            case 60: {
                return "Invalid user";
            }
            case 61: {
                return "User already exists";
            }
            case 62: {
                return "Invalid password";
            }
            case 63: {
                return "Password expired";
            }
            case 64: {
                return "Password can't be reused";
            }
            case 65: {
                return "Invalid credential";
            }
            case 70: {
                return "Invalid role";
            }
            case 71: {
                return "Role already exists";
            }
            case 72: {
                return "Invalid privilege";
            }
            case 80: {
                return "Not authenticated";
            }
            case 81: {
                return "Role violation";
            }
            case 100: {
                return "UDF returned error";
            }
            case 125: {
                return "Large collection item not found";
            }
            case 150: {
                return "Batch functionality has been disabled";
            }
            case 151: {
                return "Batch max requests have been exceeded";
            }
            case 152: {
                return "All batch queues are full";
            }
            case 200: {
                return "Index already exists";
            }
            case 201: {
                return "Index not found";
            }
            case 202: {
                return "Index out of memory";
            }
            case 203: {
                return "Index not readable";
            }
            case 204: {
                return "Index error";
            }
            case 205: {
                return "Index name max length exceeded";
            }
            case 206: {
                return "Index count exceeds max";
            }
            case 210: {
                return "Query aborted";
            }
            case 211: {
                return "Query queue full";
            }
            case 212: {
                return "Query timeout";
            }
            case 213: {
                return "Query error";
            }
        }
        return "";
    }
}

