/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.async;

import com.aerospike.client.AerospikeClient;
import com.aerospike.client.AerospikeException;
import com.aerospike.client.BatchRead;
import com.aerospike.client.Bin;
import com.aerospike.client.Host;
import com.aerospike.client.Key;
import com.aerospike.client.Log;
import com.aerospike.client.Operation;
import com.aerospike.client.Record;
import com.aerospike.client.Value;
import com.aerospike.client.async.AsyncClientPolicy;
import com.aerospike.client.async.EventLoop;
import com.aerospike.client.async.EventPolicy;
import com.aerospike.client.async.IAsyncClient;
import com.aerospike.client.async.MaxCommandAction;
import com.aerospike.client.async.NioEventLoop;
import com.aerospike.client.async.NioEventLoops;
import com.aerospike.client.async.Throttle;
import com.aerospike.client.cluster.Cluster;
import com.aerospike.client.listener.BatchListListener;
import com.aerospike.client.listener.BatchSequenceListener;
import com.aerospike.client.listener.DeleteListener;
import com.aerospike.client.listener.ExecuteListener;
import com.aerospike.client.listener.ExistsArrayListener;
import com.aerospike.client.listener.ExistsListener;
import com.aerospike.client.listener.ExistsSequenceListener;
import com.aerospike.client.listener.RecordArrayListener;
import com.aerospike.client.listener.RecordListener;
import com.aerospike.client.listener.RecordSequenceListener;
import com.aerospike.client.listener.WriteListener;
import com.aerospike.client.policy.BatchPolicy;
import com.aerospike.client.policy.Policy;
import com.aerospike.client.policy.QueryPolicy;
import com.aerospike.client.policy.ScanPolicy;
import com.aerospike.client.policy.WritePolicy;
import com.aerospike.client.query.Statement;
import com.aerospike.client.util.Util;
import java.io.Closeable;
import java.util.List;
import java.util.concurrent.ExecutorService;

public class AsyncClient
extends AerospikeClient
implements IAsyncClient,
Closeable {
    public final Policy asyncReadPolicyDefault;
    public final WritePolicy asyncWritePolicyDefault;
    public final ScanPolicy asyncScanPolicyDefault;
    public final QueryPolicy asyncQueryPolicyDefault;
    public final BatchPolicy asyncBatchPolicyDefault;
    private final NioEventLoops eventLoops;
    private final ExecutorService taskThreadPool;
    private final Throttle throttle;
    private final int maxCommandsPerEventLoop;
    private final boolean useListener;

    public AsyncClient(String hostname, int port) throws AerospikeException {
        this(new AsyncClientPolicy(), new Host(hostname, port));
    }

    public AsyncClient(AsyncClientPolicy policy, String hostname, int port) throws AerospikeException {
        this(policy, new Host(hostname, port));
    }

    public AsyncClient(AsyncClientPolicy policy, Host ... hosts) throws AerospikeException {
        super(policy);
        if (policy == null) {
            policy = new AsyncClientPolicy();
        }
        this.asyncReadPolicyDefault = policy.asyncReadPolicyDefault;
        this.asyncWritePolicyDefault = policy.asyncWritePolicyDefault;
        this.asyncScanPolicyDefault = policy.asyncScanPolicyDefault;
        this.asyncQueryPolicyDefault = policy.asyncQueryPolicyDefault;
        this.asyncBatchPolicyDefault = policy.asyncBatchPolicyDefault;
        EventPolicy eventPolicy = new EventPolicy();
        if (policy.asyncSelectorTimeout > 0) {
            eventPolicy.minTimeout = policy.asyncSelectorTimeout;
        }
        this.eventLoops = new NioEventLoops(eventPolicy, policy.asyncSelectorThreads);
        policy.eventLoops = this.eventLoops;
        try {
            this.useListener = policy.asyncMaxCommandAction == MaxCommandAction.BLOCK || policy.asyncTaskThreadPool != null;
            this.taskThreadPool = policy.asyncTaskThreadPool;
            if (policy.asyncMaxCommandAction == MaxCommandAction.BLOCK) {
                this.throttle = new Throttle(policy.asyncMaxCommands);
                this.maxCommandsPerEventLoop = policy.asyncMaxCommands / this.eventLoops.getSize();
            } else {
                this.throttle = null;
                this.maxCommandsPerEventLoop = 0;
            }
            this.cluster = new Cluster(policy, hosts);
        }
        catch (Exception e) {
            this.eventLoops.close();
            throw e;
        }
    }

    @Override
    public final void close() {
        super.close();
        this.eventLoops.close();
    }

    @Override
    public final Policy getAsyncReadPolicyDefault() {
        return this.asyncReadPolicyDefault;
    }

    @Override
    public final WritePolicy getAsyncWritePolicyDefault() {
        return this.asyncWritePolicyDefault;
    }

    @Override
    public final ScanPolicy getAsyncScanPolicyDefault() {
        return this.asyncScanPolicyDefault;
    }

    @Override
    public final QueryPolicy getAsyncQueryPolicyDefault() {
        return this.asyncQueryPolicyDefault;
    }

    @Override
    public final BatchPolicy getAsyncBatchPolicyDefault() {
        return this.asyncBatchPolicyDefault;
    }

    @Override
    public final void put(WritePolicy policy, final WriteListener listener, final Key key, final Bin ... bins) throws AerospikeException {
        WritePolicy wp;
        WritePolicy writePolicy = wp = policy != null ? policy : this.asyncWritePolicyDefault;
        if (this.useListener) {
            this.commandBegin(1, new Runnable(){

                @Override
                public void run() {
                    AsyncClient.this.put(AsyncClient.this.findEventLoop(), (WriteListener)new AWriteListener(listener), wp, key, bins);
                }
            });
        } else {
            this.put(this.findEventLoop(), listener, wp, key, bins);
        }
    }

    @Override
    public final void append(WritePolicy policy, final WriteListener listener, final Key key, final Bin ... bins) throws AerospikeException {
        WritePolicy wp;
        WritePolicy writePolicy = wp = policy != null ? policy : this.asyncWritePolicyDefault;
        if (this.useListener) {
            this.commandBegin(1, new Runnable(){

                @Override
                public void run() {
                    AsyncClient.this.append(AsyncClient.this.findEventLoop(), (WriteListener)new AWriteListener(listener), wp, key, bins);
                }
            });
        } else {
            this.append(this.findEventLoop(), listener, wp, key, bins);
        }
    }

    @Override
    public final void prepend(WritePolicy policy, final WriteListener listener, final Key key, final Bin ... bins) throws AerospikeException {
        WritePolicy wp;
        WritePolicy writePolicy = wp = policy != null ? policy : this.asyncWritePolicyDefault;
        if (this.useListener) {
            this.commandBegin(1, new Runnable(){

                @Override
                public void run() {
                    AsyncClient.this.prepend(AsyncClient.this.findEventLoop(), (WriteListener)new AWriteListener(listener), wp, key, bins);
                }
            });
        } else {
            this.prepend(this.findEventLoop(), listener, wp, key, bins);
        }
    }

    @Override
    public final void add(WritePolicy policy, final WriteListener listener, final Key key, final Bin ... bins) throws AerospikeException {
        WritePolicy wp;
        WritePolicy writePolicy = wp = policy != null ? policy : this.asyncWritePolicyDefault;
        if (this.useListener) {
            this.commandBegin(1, new Runnable(){

                @Override
                public void run() {
                    AsyncClient.this.add(AsyncClient.this.findEventLoop(), (WriteListener)new AWriteListener(listener), wp, key, bins);
                }
            });
        } else {
            this.add(this.findEventLoop(), listener, wp, key, bins);
        }
    }

    @Override
    public final void delete(WritePolicy policy, final DeleteListener listener, final Key key) throws AerospikeException {
        WritePolicy wp;
        WritePolicy writePolicy = wp = policy != null ? policy : this.asyncWritePolicyDefault;
        if (this.useListener) {
            this.commandBegin(1, new Runnable(){

                @Override
                public void run() {
                    AsyncClient.this.delete(AsyncClient.this.findEventLoop(), new ADeleteListener(listener), wp, key);
                }
            });
        } else {
            this.delete(this.findEventLoop(), listener, wp, key);
        }
    }

    @Override
    public final void touch(WritePolicy policy, final WriteListener listener, final Key key) throws AerospikeException {
        WritePolicy wp;
        WritePolicy writePolicy = wp = policy != null ? policy : this.asyncWritePolicyDefault;
        if (this.useListener) {
            this.commandBegin(1, new Runnable(){

                @Override
                public void run() {
                    AsyncClient.this.touch(AsyncClient.this.findEventLoop(), new AWriteListener(listener), wp, key);
                }
            });
        } else {
            this.touch(this.findEventLoop(), listener, wp, key);
        }
    }

    @Override
    public final void exists(Policy policy, final ExistsListener listener, final Key key) throws AerospikeException {
        Policy p;
        Policy policy2 = p = policy != null ? policy : this.asyncReadPolicyDefault;
        if (this.useListener) {
            this.commandBegin(1, new Runnable(){

                @Override
                public void run() {
                    AsyncClient.this.exists(AsyncClient.this.findEventLoop(), new AExistsListener(listener), p, key);
                }
            });
        } else {
            this.exists(this.findEventLoop(), listener, p, key);
        }
    }

    @Override
    public final void exists(BatchPolicy policy, final ExistsArrayListener listener, final Key[] keys) throws AerospikeException {
        BatchPolicy bp;
        BatchPolicy batchPolicy = bp = policy != null ? policy : this.asyncBatchPolicyDefault;
        if (this.useListener) {
            final int commands = this.cluster.getNodes().length;
            this.commandBegin(commands, new Runnable(){

                @Override
                public void run() {
                    AsyncClient.this.exists(AsyncClient.this.findEventLoop(), new AExistsArrayListener(listener, commands), bp, keys);
                }
            });
        } else {
            this.exists(this.findEventLoop(), listener, bp, keys);
        }
    }

    @Override
    public final void exists(BatchPolicy policy, final ExistsSequenceListener listener, final Key[] keys) throws AerospikeException {
        BatchPolicy bp;
        BatchPolicy batchPolicy = bp = policy != null ? policy : this.asyncBatchPolicyDefault;
        if (this.useListener) {
            final int commands = this.cluster.getNodes().length;
            this.commandBegin(commands, new Runnable(){

                @Override
                public void run() {
                    AsyncClient.this.exists(AsyncClient.this.findEventLoop(), new AExistsSequenceListener(listener, commands), bp, keys);
                }
            });
        } else {
            this.exists(this.findEventLoop(), listener, bp, keys);
        }
    }

    @Override
    public final void get(Policy policy, final RecordListener listener, final Key key) throws AerospikeException {
        Policy p;
        Policy policy2 = p = policy != null ? policy : this.asyncReadPolicyDefault;
        if (this.useListener) {
            this.commandBegin(1, new Runnable(){

                @Override
                public void run() {
                    AsyncClient.this.get(AsyncClient.this.findEventLoop(), (RecordListener)new ARecordListener(listener), p, key);
                }
            });
        } else {
            this.get(this.findEventLoop(), listener, p, key);
        }
    }

    @Override
    public final void get(Policy policy, final RecordListener listener, final Key key, final String ... binNames) throws AerospikeException {
        Policy p;
        Policy policy2 = p = policy != null ? policy : this.asyncReadPolicyDefault;
        if (this.useListener) {
            this.commandBegin(1, new Runnable(){

                @Override
                public void run() {
                    AsyncClient.this.get(AsyncClient.this.findEventLoop(), (RecordListener)new ARecordListener(listener), p, key, binNames);
                }
            });
        } else {
            this.get(this.findEventLoop(), listener, p, key, binNames);
        }
    }

    @Override
    public final void getHeader(Policy policy, final RecordListener listener, final Key key) throws AerospikeException {
        Policy p;
        Policy policy2 = p = policy != null ? policy : this.asyncReadPolicyDefault;
        if (this.useListener) {
            this.commandBegin(1, new Runnable(){

                @Override
                public void run() {
                    AsyncClient.this.getHeader(AsyncClient.this.findEventLoop(), new ARecordListener(listener), p, key);
                }
            });
        } else {
            this.getHeader(this.findEventLoop(), listener, p, key);
        }
    }

    @Override
    public final void get(BatchPolicy policy, final BatchListListener listener, final List<BatchRead> records) throws AerospikeException {
        BatchPolicy bp;
        BatchPolicy batchPolicy = bp = policy != null ? policy : this.asyncBatchPolicyDefault;
        if (this.useListener) {
            final int commands = this.cluster.getNodes().length;
            this.commandBegin(commands, new Runnable(){

                @Override
                public void run() {
                    AsyncClient.this.get(AsyncClient.this.findEventLoop(), new ABatchListListener(listener, commands), bp, (List<BatchRead>)records);
                }
            });
        } else {
            this.get(this.findEventLoop(), listener, bp, records);
        }
    }

    @Override
    public final void get(BatchPolicy policy, final BatchSequenceListener listener, final List<BatchRead> records) throws AerospikeException {
        BatchPolicy bp;
        BatchPolicy batchPolicy = bp = policy != null ? policy : this.asyncBatchPolicyDefault;
        if (this.useListener) {
            final int commands = this.cluster.getNodes().length;
            this.commandBegin(commands, new Runnable(){

                @Override
                public void run() {
                    AsyncClient.this.get(AsyncClient.this.findEventLoop(), new ABatchSequenceListener(listener, commands), bp, (List<BatchRead>)records);
                }
            });
        } else {
            this.get(this.findEventLoop(), listener, bp, records);
        }
    }

    @Override
    public final void get(BatchPolicy policy, final RecordArrayListener listener, final Key[] keys) throws AerospikeException {
        BatchPolicy bp;
        BatchPolicy batchPolicy = bp = policy != null ? policy : this.asyncBatchPolicyDefault;
        if (this.useListener) {
            final int commands = this.cluster.getNodes().length;
            this.commandBegin(commands, new Runnable(){

                @Override
                public void run() {
                    AsyncClient.this.get(AsyncClient.this.findEventLoop(), (RecordArrayListener)new ARecordArrayListener(listener, commands), bp, keys);
                }
            });
        } else {
            this.get(this.findEventLoop(), listener, bp, keys);
        }
    }

    @Override
    public final void get(BatchPolicy policy, final RecordSequenceListener listener, final Key[] keys) throws AerospikeException {
        BatchPolicy bp;
        BatchPolicy batchPolicy = bp = policy != null ? policy : this.asyncBatchPolicyDefault;
        if (this.useListener) {
            final int commands = this.cluster.getNodes().length;
            this.commandBegin(commands, new Runnable(){

                @Override
                public void run() {
                    AsyncClient.this.get(AsyncClient.this.findEventLoop(), (RecordSequenceListener)new ARecordSequenceListener(listener, commands), bp, keys);
                }
            });
        } else {
            this.get(this.findEventLoop(), listener, bp, keys);
        }
    }

    @Override
    public final void get(BatchPolicy policy, final RecordArrayListener listener, final Key[] keys, final String ... binNames) throws AerospikeException {
        BatchPolicy bp;
        BatchPolicy batchPolicy = bp = policy != null ? policy : this.asyncBatchPolicyDefault;
        if (this.useListener) {
            final int commands = this.cluster.getNodes().length;
            this.commandBegin(commands, new Runnable(){

                @Override
                public void run() {
                    AsyncClient.this.get(AsyncClient.this.findEventLoop(), (RecordArrayListener)new ARecordArrayListener(listener, commands), bp, keys, binNames);
                }
            });
        } else {
            this.get(this.findEventLoop(), listener, bp, keys, binNames);
        }
    }

    @Override
    public final void get(BatchPolicy policy, final RecordSequenceListener listener, final Key[] keys, final String ... binNames) throws AerospikeException {
        BatchPolicy bp;
        BatchPolicy batchPolicy = bp = policy != null ? policy : this.asyncBatchPolicyDefault;
        if (this.useListener) {
            final int commands = this.cluster.getNodes().length;
            this.commandBegin(commands, new Runnable(){

                @Override
                public void run() {
                    AsyncClient.this.get(AsyncClient.this.findEventLoop(), (RecordSequenceListener)new ARecordSequenceListener(listener, commands), bp, keys, binNames);
                }
            });
        } else {
            this.get(this.findEventLoop(), listener, bp, keys, binNames);
        }
    }

    @Override
    public final void getHeader(BatchPolicy policy, final RecordArrayListener listener, final Key[] keys) throws AerospikeException {
        BatchPolicy bp;
        BatchPolicy batchPolicy = bp = policy != null ? policy : this.asyncBatchPolicyDefault;
        if (this.useListener) {
            final int commands = this.cluster.getNodes().length;
            this.commandBegin(commands, new Runnable(){

                @Override
                public void run() {
                    AsyncClient.this.getHeader(AsyncClient.this.findEventLoop(), new ARecordArrayListener(listener, commands), bp, keys);
                }
            });
        } else {
            this.getHeader(this.findEventLoop(), listener, bp, keys);
        }
    }

    @Override
    public final void getHeader(BatchPolicy policy, final RecordSequenceListener listener, final Key[] keys) throws AerospikeException {
        BatchPolicy bp;
        BatchPolicy batchPolicy = bp = policy != null ? policy : this.asyncBatchPolicyDefault;
        if (this.useListener) {
            final int commands = this.cluster.getNodes().length;
            this.commandBegin(commands, new Runnable(){

                @Override
                public void run() {
                    AsyncClient.this.getHeader(AsyncClient.this.findEventLoop(), new ARecordSequenceListener(listener, commands), bp, keys);
                }
            });
        } else {
            this.getHeader(this.findEventLoop(), listener, bp, keys);
        }
    }

    @Override
    public final void operate(WritePolicy policy, final RecordListener listener, final Key key, final Operation ... operations) throws AerospikeException {
        WritePolicy wp;
        WritePolicy writePolicy = wp = policy != null ? policy : this.asyncWritePolicyDefault;
        if (this.useListener) {
            this.commandBegin(1, new Runnable(){

                @Override
                public void run() {
                    AsyncClient.this.operate(AsyncClient.this.findEventLoop(), (RecordListener)new ARecordListener(listener), wp, key, operations);
                }
            });
        } else {
            this.operate(this.findEventLoop(), listener, wp, key, operations);
        }
    }

    @Override
    public final void scanAll(ScanPolicy policy, final RecordSequenceListener listener, final String namespace, final String setName, final String ... binNames) throws AerospikeException {
        ScanPolicy sp;
        ScanPolicy scanPolicy = sp = policy != null ? policy : this.asyncScanPolicyDefault;
        if (this.useListener) {
            final int commands = this.cluster.getNodes().length;
            this.commandBegin(commands, new Runnable(){

                @Override
                public void run() {
                    AsyncClient.this.scanAll(AsyncClient.this.findEventLoop(), (RecordSequenceListener)new ARecordSequenceListener(listener, commands), sp, namespace, setName, binNames);
                }
            });
        } else {
            this.scanAll(this.findEventLoop(), listener, sp, namespace, setName, binNames);
        }
    }

    @Override
    public final void execute(WritePolicy policy, final ExecuteListener listener, final Key key, final String packageName, final String functionName, final Value ... functionArgs) throws AerospikeException {
        WritePolicy wp;
        WritePolicy writePolicy = wp = policy != null ? policy : this.asyncWritePolicyDefault;
        if (this.useListener) {
            this.commandBegin(1, new Runnable(){

                @Override
                public void run() {
                    AsyncClient.this.execute(AsyncClient.this.findEventLoop(), (ExecuteListener)new AExecuteListener(listener), wp, key, packageName, functionName, functionArgs);
                }
            });
        } else {
            this.execute(this.findEventLoop(), listener, wp, key, packageName, functionName, functionArgs);
        }
    }

    @Override
    public final void query(QueryPolicy policy, final RecordSequenceListener listener, final Statement statement) throws AerospikeException {
        QueryPolicy qp;
        QueryPolicy queryPolicy = qp = policy != null ? policy : this.asyncQueryPolicyDefault;
        if (this.useListener) {
            final int commands = this.cluster.getNodes().length;
            this.commandBegin(commands, new Runnable(){

                @Override
                public void run() {
                    AsyncClient.this.query(AsyncClient.this.findEventLoop(), new ARecordSequenceListener(listener, commands), qp, statement);
                }
            });
        } else {
            this.query(this.findEventLoop(), listener, qp, statement);
        }
    }

    private final EventLoop findEventLoop() {
        int i;
        NioEventLoop eventLoop = this.eventLoops.next();
        if (this.cluster.eventState[eventLoop.index].pending < this.maxCommandsPerEventLoop) {
            return eventLoop;
        }
        for (i = eventLoop.index - 1; i >= 0; --i) {
            if (this.cluster.eventState[i].pending >= this.maxCommandsPerEventLoop) continue;
            return this.eventLoops.eventLoops[i];
        }
        for (i = eventLoop.index + 1; i < this.eventLoops.eventLoops.length; ++i) {
            if (this.cluster.eventState[i].pending >= this.maxCommandsPerEventLoop) continue;
            return this.eventLoops.eventLoops[i];
        }
        return eventLoop;
    }

    private final void commandBegin(int commands, Runnable runnable) {
        if (this.throttle != null) {
            if (this.throttle.waitForSlot(commands)) {
                try {
                    runnable.run();
                }
                catch (Exception e) {
                    this.throttle.addSlot(commands);
                    throw e;
                }
            }
        } else {
            runnable.run();
        }
    }

    private final void commandComplete(int commands, Runnable runnable) {
        if (this.throttle != null) {
            this.throttle.addSlot(commands);
        }
        this.callListener(runnable);
    }

    private final void callListener(final Runnable runnable) {
        if (this.taskThreadPool != null) {
            this.taskThreadPool.submit(new Runnable(){

                @Override
                public void run() {
                    try {
                        runnable.run();
                    }
                    catch (Exception e) {
                        Log.error("Listener error: " + Util.getErrorMessage(e));
                    }
                }
            });
        } else {
            runnable.run();
        }
    }

    private final class AExecuteListener
    implements ExecuteListener {
        private final ExecuteListener listener;

        private AExecuteListener(ExecuteListener listener) {
            this.listener = listener;
        }

        @Override
        public void onSuccess(final Key key, final Object obj) {
            AsyncClient.this.commandComplete(1, new Runnable(){

                @Override
                public void run() {
                    if (AExecuteListener.this.listener != null) {
                        AExecuteListener.this.listener.onSuccess(key, obj);
                    }
                }
            });
        }

        @Override
        public void onFailure(final AerospikeException ae) {
            AsyncClient.this.commandComplete(1, new Runnable(){

                @Override
                public void run() {
                    if (AExecuteListener.this.listener != null) {
                        AExecuteListener.this.listener.onFailure(ae);
                    }
                }
            });
        }
    }

    private final class ARecordSequenceListener
    implements RecordSequenceListener {
        private final RecordSequenceListener listener;
        private final int commands;

        private ARecordSequenceListener(RecordSequenceListener listener, int commands) {
            this.listener = listener;
            this.commands = commands;
        }

        @Override
        public void onRecord(final Key key, final Record record) {
            AsyncClient.this.callListener(new Runnable(){

                @Override
                public void run() {
                    ARecordSequenceListener.this.listener.onRecord(key, record);
                }
            });
        }

        @Override
        public void onSuccess() {
            AsyncClient.this.commandComplete(this.commands, new Runnable(){

                @Override
                public void run() {
                    ARecordSequenceListener.this.listener.onSuccess();
                }
            });
        }

        @Override
        public void onFailure(final AerospikeException ae) {
            AsyncClient.this.commandComplete(this.commands, new Runnable(){

                @Override
                public void run() {
                    ARecordSequenceListener.this.listener.onFailure(ae);
                }
            });
        }
    }

    private final class ARecordArrayListener
    implements RecordArrayListener {
        private final RecordArrayListener listener;
        private final int commands;

        private ARecordArrayListener(RecordArrayListener listener, int commands) {
            this.listener = listener;
            this.commands = commands;
        }

        @Override
        public void onSuccess(final Key[] keys, final Record[] records) {
            AsyncClient.this.commandComplete(this.commands, new Runnable(){

                @Override
                public void run() {
                    ARecordArrayListener.this.listener.onSuccess(keys, records);
                }
            });
        }

        @Override
        public void onFailure(final AerospikeException ae) {
            AsyncClient.this.commandComplete(this.commands, new Runnable(){

                @Override
                public void run() {
                    ARecordArrayListener.this.listener.onFailure(ae);
                }
            });
        }
    }

    private final class ABatchSequenceListener
    implements BatchSequenceListener {
        private final BatchSequenceListener listener;
        private final int commands;

        private ABatchSequenceListener(BatchSequenceListener listener, int commands) {
            this.listener = listener;
            this.commands = commands;
        }

        @Override
        public void onRecord(final BatchRead record) {
            AsyncClient.this.callListener(new Runnable(){

                @Override
                public void run() {
                    ABatchSequenceListener.this.listener.onRecord(record);
                }
            });
        }

        @Override
        public void onSuccess() {
            AsyncClient.this.commandComplete(this.commands, new Runnable(){

                @Override
                public void run() {
                    ABatchSequenceListener.this.listener.onSuccess();
                }
            });
        }

        @Override
        public void onFailure(final AerospikeException ae) {
            AsyncClient.this.commandComplete(this.commands, new Runnable(){

                @Override
                public void run() {
                    ABatchSequenceListener.this.listener.onFailure(ae);
                }
            });
        }
    }

    private final class ABatchListListener
    implements BatchListListener {
        private final BatchListListener listener;
        private final int commands;

        private ABatchListListener(BatchListListener listener, int commands) {
            this.listener = listener;
            this.commands = commands;
        }

        @Override
        public void onSuccess(final List<BatchRead> records) {
            AsyncClient.this.commandComplete(this.commands, new Runnable(){

                @Override
                public void run() {
                    ABatchListListener.this.listener.onSuccess(records);
                }
            });
        }

        @Override
        public void onFailure(final AerospikeException ae) {
            AsyncClient.this.commandComplete(this.commands, new Runnable(){

                @Override
                public void run() {
                    ABatchListListener.this.listener.onFailure(ae);
                }
            });
        }
    }

    private final class ARecordListener
    implements RecordListener {
        private final RecordListener listener;

        private ARecordListener(RecordListener listener) {
            this.listener = listener;
        }

        @Override
        public void onSuccess(final Key key, final Record record) {
            AsyncClient.this.commandComplete(1, new Runnable(){

                @Override
                public void run() {
                    if (ARecordListener.this.listener != null) {
                        ARecordListener.this.listener.onSuccess(key, record);
                    }
                }
            });
        }

        @Override
        public void onFailure(final AerospikeException ae) {
            AsyncClient.this.commandComplete(1, new Runnable(){

                @Override
                public void run() {
                    if (ARecordListener.this.listener != null) {
                        ARecordListener.this.listener.onFailure(ae);
                    }
                }
            });
        }
    }

    private final class AExistsSequenceListener
    implements ExistsSequenceListener {
        private final ExistsSequenceListener listener;
        private final int commands;

        private AExistsSequenceListener(ExistsSequenceListener listener, int commands) {
            this.listener = listener;
            this.commands = commands;
        }

        @Override
        public void onExists(final Key key, final boolean exists) {
            AsyncClient.this.callListener(new Runnable(){

                @Override
                public void run() {
                    AExistsSequenceListener.this.listener.onExists(key, exists);
                }
            });
        }

        @Override
        public void onSuccess() {
            AsyncClient.this.commandComplete(this.commands, new Runnable(){

                @Override
                public void run() {
                    AExistsSequenceListener.this.listener.onSuccess();
                }
            });
        }

        @Override
        public void onFailure(final AerospikeException ae) {
            AsyncClient.this.commandComplete(this.commands, new Runnable(){

                @Override
                public void run() {
                    AExistsSequenceListener.this.listener.onFailure(ae);
                }
            });
        }
    }

    private final class AExistsArrayListener
    implements ExistsArrayListener {
        private final ExistsArrayListener listener;
        private final int commands;

        private AExistsArrayListener(ExistsArrayListener listener, int commands) {
            this.listener = listener;
            this.commands = commands;
        }

        @Override
        public void onSuccess(final Key[] keys, final boolean[] exists) {
            AsyncClient.this.commandComplete(this.commands, new Runnable(){

                @Override
                public void run() {
                    AExistsArrayListener.this.listener.onSuccess(keys, exists);
                }
            });
        }

        @Override
        public void onFailure(final AerospikeException ae) {
            AsyncClient.this.commandComplete(this.commands, new Runnable(){

                @Override
                public void run() {
                    AExistsArrayListener.this.listener.onFailure(ae);
                }
            });
        }
    }

    private final class AExistsListener
    implements ExistsListener {
        private final ExistsListener listener;

        private AExistsListener(ExistsListener listener) {
            this.listener = listener;
        }

        @Override
        public void onSuccess(final Key key, final boolean existed) {
            AsyncClient.this.commandComplete(1, new Runnable(){

                @Override
                public void run() {
                    AExistsListener.this.listener.onSuccess(key, existed);
                }
            });
        }

        @Override
        public void onFailure(final AerospikeException ae) {
            AsyncClient.this.commandComplete(1, new Runnable(){

                @Override
                public void run() {
                    AExistsListener.this.listener.onFailure(ae);
                }
            });
        }
    }

    private final class ADeleteListener
    implements DeleteListener {
        private final DeleteListener listener;

        private ADeleteListener(DeleteListener listener) {
            this.listener = listener;
        }

        @Override
        public void onSuccess(final Key key, final boolean existed) {
            AsyncClient.this.commandComplete(1, new Runnable(){

                @Override
                public void run() {
                    if (ADeleteListener.this.listener != null) {
                        ADeleteListener.this.listener.onSuccess(key, existed);
                    }
                }
            });
        }

        @Override
        public void onFailure(final AerospikeException ae) {
            AsyncClient.this.commandComplete(1, new Runnable(){

                @Override
                public void run() {
                    if (ADeleteListener.this.listener != null) {
                        ADeleteListener.this.listener.onFailure(ae);
                    }
                }
            });
        }
    }

    private final class AWriteListener
    implements WriteListener {
        private final WriteListener listener;

        private AWriteListener(WriteListener listener) {
            this.listener = listener;
        }

        @Override
        public void onSuccess(final Key key) {
            AsyncClient.this.commandComplete(1, new Runnable(){

                @Override
                public void run() {
                    if (AWriteListener.this.listener != null) {
                        AWriteListener.this.listener.onSuccess(key);
                    }
                }
            });
        }

        @Override
        public void onFailure(final AerospikeException ae) {
            AsyncClient.this.commandComplete(1, new Runnable(){

                @Override
                public void run() {
                    if (AWriteListener.this.listener != null) {
                        AWriteListener.this.listener.onFailure(ae);
                    }
                }
            });
        }
    }
}

