/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.async;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.cluster.Cluster;
import com.aerospike.client.cluster.Node;
import com.aerospike.client.cluster.Partition;
import com.aerospike.client.command.Command;
import com.aerospike.client.policy.Policy;
import java.util.ArrayDeque;

public abstract class AsyncCommand
extends Command {
    static final int MAX_BUFFER_SIZE = 131072;
    static final int REGISTERED = 1;
    static final int DELAY_QUEUE = 2;
    static final int CONNECT = 3;
    static final int AUTH_WRITE = 4;
    static final int AUTH_READ_HEADER = 5;
    static final int AUTH_READ_BODY = 6;
    static final int COMMAND_WRITE = 7;
    static final int COMMAND_READ_HEADER = 8;
    static final int COMMAND_READ_BODY = 9;
    static final int COMPLETE = 10;
    Policy policy;
    final Partition partition;
    Node node;
    ArrayDeque<byte[]> bufferQueue;
    int receiveSize;
    final boolean isRead;
    final boolean isSingle;
    boolean valid = true;

    public AsyncCommand(Policy policy, Partition partition, Node node, boolean isRead) {
        this.policy = policy;
        this.partition = partition;
        this.node = node;
        this.isRead = isRead;
        this.isSingle = partition != null;
    }

    public AsyncCommand(Policy policy, Node node, boolean isRead, boolean isSingle) {
        this.policy = policy;
        this.partition = null;
        this.node = node;
        this.isRead = isRead;
        this.isSingle = isSingle;
    }

    final Node getNode(Cluster cluster) {
        if (this.partition != null) {
            this.node = this.getNode(cluster, this.partition, this.policy.replica, this.isRead);
        }
        return this.node;
    }

    final void initBuffer() {
        this.dataBuffer = this.getBuffer(8192);
    }

    @Override
    protected final void sizeBuffer() {
        this.sizeBuffer(this.dataOffset);
    }

    final void sizeBuffer(int size) {
        if (this.dataBuffer == null) {
            this.dataBuffer = this.getBuffer(size);
        } else if (size > this.dataBuffer.length) {
            this.dataBuffer = this.resizeBuffer(this.dataBuffer, size);
        }
    }

    final void putBuffer() {
        if (this.dataBuffer != null) {
            this.putBuffer(this.dataBuffer);
            this.dataBuffer = null;
        }
    }

    private final byte[] getBuffer(int size) {
        if (size > 131072) {
            return new byte[size];
        }
        byte[] buffer = this.bufferQueue.pollFirst();
        if (buffer == null || buffer.length < size) {
            buffer = new byte[size + 8191 & 0xFFFFE000];
        }
        return buffer;
    }

    private final byte[] resizeBuffer(byte[] buffer, int size) {
        if (size > 131072) {
            this.putBuffer(buffer);
            return new byte[size];
        }
        return new byte[size + 8191 & 0xFFFFE000];
    }

    private final void putBuffer(byte[] buffer) {
        if (buffer.length <= 131072) {
            this.bufferQueue.addLast(buffer);
        }
    }

    final void validateHeaderSize() {
        if (this.receiveSize < 22) {
            throw new AerospikeException.Parse("Invalid receive size: " + this.receiveSize);
        }
    }

    final void stop() {
        this.valid = false;
    }

    abstract void writeBuffer();

    abstract boolean parseResult();

    abstract void onSuccess();

    abstract void onFailure(AerospikeException var1);
}

