/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.async;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.Key;
import com.aerospike.client.async.AsyncCommand;
import com.aerospike.client.cluster.Partition;
import com.aerospike.client.listener.ExistsListener;
import com.aerospike.client.policy.Policy;

public final class AsyncExists
extends AsyncCommand {
    private final ExistsListener listener;
    private final Key key;
    private boolean exists;

    public AsyncExists(ExistsListener listener, Policy policy, Key key) {
        super(policy, new Partition(key), null, true);
        this.listener = listener;
        this.key = key;
    }

    @Override
    protected void writeBuffer() {
        this.setExists(this.policy, this.key);
    }

    @Override
    protected boolean parseResult() {
        this.validateHeaderSize();
        int resultCode = this.dataBuffer[5] & 0xFF;
        if (resultCode == 0) {
            this.exists = true;
        } else if (resultCode == 2) {
            this.exists = false;
        } else {
            throw new AerospikeException(resultCode);
        }
        return true;
    }

    @Override
    protected void onSuccess() {
        if (this.listener != null) {
            this.listener.onSuccess(this.key, this.exists);
        }
    }

    @Override
    protected void onFailure(AerospikeException e) {
        if (this.listener != null) {
            this.listener.onFailure(e);
        }
    }
}

