/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.async;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.Key;
import com.aerospike.client.async.AsyncCommand;
import com.aerospike.client.cluster.Partition;
import com.aerospike.client.listener.WriteListener;
import com.aerospike.client.policy.Policy;
import com.aerospike.client.policy.WritePolicy;

public final class AsyncTouch
extends AsyncCommand {
    private final WriteListener listener;
    private final WritePolicy writePolicy;
    private final Key key;

    public AsyncTouch(WriteListener listener, WritePolicy writePolicy, Key key) {
        super((Policy)writePolicy, new Partition(key), null, false);
        this.listener = listener;
        this.writePolicy = writePolicy;
        this.key = key;
    }

    @Override
    protected void writeBuffer() {
        this.setTouch(this.writePolicy, this.key);
    }

    @Override
    protected boolean parseResult() {
        this.validateHeaderSize();
        int resultCode = this.dataBuffer[5] & 0xFF;
        if (resultCode != 0) {
            throw new AerospikeException(resultCode);
        }
        return true;
    }

    @Override
    protected void onSuccess() {
        if (this.listener != null) {
            this.listener.onSuccess(this.key);
        }
    }

    @Override
    protected void onFailure(AerospikeException e) {
        if (this.listener != null) {
            this.listener.onFailure(e);
        }
    }
}

