/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.async;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.async.EventLoop;
import com.aerospike.client.async.EventPolicy;
import com.aerospike.client.async.EventState;
import com.aerospike.client.async.HashedWheelTimer;
import java.util.ArrayDeque;
import java.util.concurrent.TimeUnit;

public abstract class EventLoopBase
implements EventLoop {
    final ArrayDeque<Runnable> delayQueue;
    final ArrayDeque<byte[]> bufferQueue;
    final HashedWheelTimer timer;
    final int index;
    final int maxCommandsInProcess;
    final int maxCommandsInQueue;
    int pending;
    boolean usingDelayQueue;

    public EventLoopBase(EventPolicy policy, int index2) {
        if (policy.maxCommandsInProcess > 0 && policy.maxCommandsInProcess < 5) {
            throw new AerospikeException("maxCommandsInProcess " + policy.maxCommandsInProcess + " must be 0 or >= 5");
        }
        this.delayQueue = policy.maxCommandsInProcess > 0 ? new ArrayDeque(policy.queueInitialCapacity) : null;
        this.bufferQueue = new ArrayDeque(policy.commandsPerEventLoop);
        this.timer = new HashedWheelTimer(this, policy.minTimeout, TimeUnit.MILLISECONDS, policy.ticksPerWheel);
        this.index = index2;
        this.maxCommandsInProcess = policy.maxCommandsInProcess;
        this.maxCommandsInQueue = policy.maxCommandsInQueue;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public EventState createState() {
        return new EventState(this, this.index);
    }
}

