/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.async;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.Log;
import com.aerospike.client.admin.AdminCommand;
import com.aerospike.client.async.AsyncCommand;
import com.aerospike.client.async.EventState;
import com.aerospike.client.async.HashedWheelTimer;
import com.aerospike.client.async.NioConnection;
import com.aerospike.client.async.NioEventLoop;
import com.aerospike.client.async.TimerTask;
import com.aerospike.client.cluster.Cluster;
import com.aerospike.client.cluster.Node;
import com.aerospike.client.util.Util;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.TimeUnit;

public final class NioCommand
implements Runnable,
TimerTask {
    final NioEventLoop eventLoop;
    final Cluster cluster;
    final AsyncCommand command;
    final EventState eventState;
    NioConnection conn;
    ByteBuffer byteBuffer;
    HashedWheelTimer.HashedWheelTimeout timeoutTask;
    long totalDeadline;
    int state;
    int iteration;
    int commandSentCounter;
    final boolean hasTotalTimeout;
    boolean usingSocketTimeout;
    boolean eventReceived;
    boolean timeoutDelay;

    public NioCommand(NioEventLoop eventLoop, Cluster cluster, AsyncCommand command) {
        this.eventLoop = eventLoop;
        this.cluster = cluster;
        this.eventState = cluster.eventState[eventLoop.index];
        this.command = command;
        command.bufferQueue = eventLoop.bufferQueue;
        boolean bl = this.hasTotalTimeout = command.policy.totalTimeout > 0;
        if (eventLoop.thread == Thread.currentThread() && this.eventState.errors < 5) {
            this.run();
        } else {
            if (this.hasTotalTimeout) {
                this.totalDeadline = System.nanoTime() + TimeUnit.MILLISECONDS.toNanos(command.policy.totalTimeout);
            }
            this.state = 1;
            eventLoop.execute(this);
        }
    }

    @Override
    public void run() {
        if (this.eventState.pending++ == -1) {
            this.eventState.pending = -1;
            ++this.eventState.errors;
            this.state = 10;
            this.notifyFailure(new AerospikeException("Cluster has been closed"));
            return;
        }
        long currentTime = 0L;
        if (this.hasTotalTimeout) {
            currentTime = System.nanoTime();
            if (this.state == 1) {
                if (currentTime >= this.totalDeadline) {
                    this.queueError(new AerospikeException.Timeout(this.command.policy, true));
                    return;
                }
            } else {
                this.totalDeadline = currentTime + TimeUnit.MILLISECONDS.toNanos(this.command.policy.totalTimeout);
            }
        }
        if (this.eventLoop.maxCommandsInProcess > 0) {
            this.executeFromDelayQueue();
            if (this.eventLoop.pending >= this.eventLoop.maxCommandsInProcess) {
                if (this.eventLoop.maxCommandsInQueue > 0 && this.eventLoop.delayQueue.size() >= this.eventLoop.maxCommandsInQueue) {
                    this.queueError(new AerospikeException.AsyncQueueFull());
                    return;
                }
                this.eventLoop.delayQueue.addLast(this);
                if (this.hasTotalTimeout) {
                    this.timeoutTask = this.eventLoop.timer.addTimeout(this, this.totalDeadline);
                }
                this.state = 2;
                return;
            }
        }
        if (this.hasTotalTimeout) {
            long deadline;
            if (this.command.policy.socketTimeout > 0) {
                deadline = currentTime + TimeUnit.MILLISECONDS.toNanos(this.command.policy.socketTimeout);
                if (deadline < this.totalDeadline) {
                    this.usingSocketTimeout = true;
                } else {
                    deadline = this.totalDeadline;
                }
            } else {
                deadline = this.totalDeadline;
            }
            this.timeoutTask = this.eventLoop.timer.addTimeout(this, deadline);
        } else if (this.command.policy.socketTimeout > 0) {
            this.usingSocketTimeout = true;
            this.timeoutTask = this.eventLoop.timer.addTimeout(this, System.nanoTime() + TimeUnit.MILLISECONDS.toNanos(this.command.policy.socketTimeout));
        }
        ++this.eventLoop.pending;
        this.executeCommand();
    }

    private final void queueError(AerospikeException ae) {
        --this.eventState.pending;
        ++this.eventState.errors;
        this.state = 10;
        this.notifyFailure(ae);
    }

    private final void tryDelayQueue() {
        if (this.eventLoop.maxCommandsInProcess > 0 && !this.eventLoop.usingDelayQueue) {
            this.executeFromDelayQueue();
        }
    }

    private final void executeFromDelayQueue() {
        this.eventLoop.usingDelayQueue = true;
        try {
            NioCommand cmd;
            while (this.eventLoop.pending < this.eventLoop.maxCommandsInProcess && (cmd = (NioCommand)this.eventLoop.delayQueue.pollFirst()) != null) {
                if (cmd.state == 10) continue;
                cmd.executeCommandFromDelayQueue();
            }
        }
        catch (Exception e) {
            Log.error("Unexpected async error: " + Util.getErrorMessage(e));
        }
        finally {
            this.eventLoop.usingDelayQueue = false;
        }
    }

    private final void executeCommandFromDelayQueue() {
        if (this.command.policy.socketTimeout > 0) {
            long socketDeadline = System.nanoTime() + TimeUnit.MILLISECONDS.toNanos(this.command.policy.socketTimeout);
            if (this.hasTotalTimeout) {
                if (socketDeadline < this.totalDeadline) {
                    this.timeoutTask.cancel();
                    this.usingSocketTimeout = true;
                    this.eventLoop.timer.restoreTimeout(this.timeoutTask, socketDeadline);
                }
            } else {
                this.usingSocketTimeout = true;
                this.timeoutTask = this.eventLoop.timer.addTimeout(this, socketDeadline);
            }
        }
        ++this.eventLoop.pending;
        this.executeCommand();
    }

    protected final void executeCommand() {
        this.state = 3;
        ++this.iteration;
        try {
            Node node = this.command.getNode(this.cluster);
            this.byteBuffer = this.eventLoop.getByteBuffer();
            this.conn = (NioConnection)node.getAsyncConnection(this.eventLoop.index, this.byteBuffer);
            if (this.conn != null) {
                this.conn.attach(this);
                this.writeCommand();
                return;
            }
            try {
                this.conn = new NioConnection(node.getAddress(), this.cluster.maxSocketIdleNanos);
            }
            catch (Exception e) {
                node.decrAsyncConnection(this.eventLoop.index);
                throw e;
            }
            this.state = this.cluster.getUser() != null ? 4 : 7;
            this.conn.registerConnect(this);
            this.eventState.errors = 0;
        }
        catch (AerospikeException.Connection ac) {
            ++this.eventState.errors;
            this.onNetworkError(ac, true);
        }
        catch (IOException ioe) {
            ++this.eventState.errors;
            this.onNetworkError(new AerospikeException(ioe), true);
        }
        catch (Exception e) {
            ++this.eventState.errors;
            this.fail();
            this.notifyFailure(new AerospikeException(e));
            this.tryDelayQueue();
        }
    }

    protected final void finishConnect() throws IOException {
        this.conn.finishConnect();
        if (this.state == 4) {
            this.writeAuth();
        } else {
            this.writeCommand();
        }
    }

    private final void writeAuth() throws IOException {
        this.command.initBuffer();
        AdminCommand admin = new AdminCommand(this.command.dataBuffer);
        this.command.dataOffset = admin.setAuthenticate(this.cluster, this.command.node.getSessionToken());
        this.byteBuffer.clear();
        this.byteBuffer.put(this.command.dataBuffer, 0, this.command.dataOffset);
        this.byteBuffer.flip();
        this.command.putBuffer();
        if (this.conn.write(this.byteBuffer)) {
            this.byteBuffer.clear();
            this.byteBuffer.limit(8);
            this.state = 5;
            this.eventReceived = false;
            this.conn.registerRead();
        } else {
            this.state = 4;
            this.conn.registerWrite();
        }
    }

    private final void writeCommand() throws IOException {
        this.command.writeBuffer();
        if (this.command.dataOffset > this.byteBuffer.capacity()) {
            this.byteBuffer = NioEventLoop.createByteBuffer(this.command.dataOffset);
        }
        this.byteBuffer.clear();
        this.byteBuffer.put(this.command.dataBuffer, 0, this.command.dataOffset);
        this.byteBuffer.flip();
        this.command.putBuffer();
        if (this.conn.write(this.byteBuffer)) {
            this.byteBuffer.clear();
            this.byteBuffer.limit(8);
            this.state = 8;
            ++this.commandSentCounter;
            this.eventReceived = false;
            this.conn.registerRead();
        } else {
            this.state = 7;
            this.conn.registerWrite();
        }
    }

    protected final void write() throws IOException {
        if (this.conn.write(this.byteBuffer)) {
            this.byteBuffer.clear();
            this.byteBuffer.limit(8);
            if (this.state == 7) {
                this.state = 8;
                ++this.commandSentCounter;
            } else {
                this.state = 5;
            }
            this.eventReceived = false;
            this.conn.registerRead();
        }
    }

    protected final void read() throws IOException {
        this.eventReceived = true;
        if (!this.conn.read(this.byteBuffer)) {
            return;
        }
        switch (this.state) {
            case 5: {
                this.readAuthHeader();
                if (!this.conn.read(this.byteBuffer)) {
                    return;
                }
            }
            case 6: {
                this.readAuthBody();
                this.writeCommand();
                break;
            }
            case 8: {
                if (this.command.isSingle) {
                    this.readSingleHeader();
                    break;
                }
                this.readMultiHeader();
                break;
            }
            case 9: {
                if (this.command.isSingle) {
                    this.readSingleBody();
                    break;
                }
                this.readMultiBody();
            }
        }
    }

    private final void readAuthHeader() {
        this.byteBuffer.position(0);
        this.command.receiveSize = (int)(this.byteBuffer.getLong() & 0xFFFFFFFFFFFFL);
        if (this.command.receiveSize < 2 || this.command.receiveSize > this.byteBuffer.capacity()) {
            throw new AerospikeException.Parse("Invalid auth receive size: " + this.command.receiveSize);
        }
        this.byteBuffer.clear();
        this.byteBuffer.limit(this.command.receiveSize);
        this.state = 6;
    }

    private final void readAuthBody() {
        int resultCode = this.byteBuffer.get(1) & 0xFF;
        if (resultCode != 0) {
            this.command.node.signalLogin();
            throw new AerospikeException(resultCode);
        }
    }

    private final void readSingleHeader() throws IOException {
        this.byteBuffer.position(0);
        this.command.receiveSize = (int)(this.byteBuffer.getLong() & 0xFFFFFFFFFFFFL);
        if (this.command.receiveSize <= this.byteBuffer.capacity()) {
            this.byteBuffer.clear();
        } else {
            this.byteBuffer = NioEventLoop.createByteBuffer(this.command.receiveSize);
        }
        this.byteBuffer.limit(this.command.receiveSize);
        this.state = 9;
        if (this.conn.read(this.byteBuffer)) {
            this.readSingleBody();
        }
    }

    private final void readSingleBody() {
        this.command.sizeBuffer(this.command.receiveSize);
        this.byteBuffer.position(0);
        this.byteBuffer.get(this.command.dataBuffer, 0, this.command.receiveSize);
        this.command.parseResult();
        this.command.putBuffer();
        this.finish();
    }

    private final void readMultiHeader() throws IOException {
        if (!this.command.valid) {
            throw new AerospikeException.QueryTerminated();
        }
        if (!this.parseGroupHeader()) {
            return;
        }
        if (!this.conn.read(this.byteBuffer)) {
            return;
        }
        this.readMultiBody();
    }

    private final void readMultiBody() throws IOException {
        if (!this.command.valid) {
            throw new AerospikeException.QueryTerminated();
        }
        if (!this.parseGroupBody()) {
            return;
        }
        if (!this.conn.read(this.byteBuffer)) {
            return;
        }
        if (!this.parseGroupHeader()) {
            return;
        }
        if (this.command.receiveSize == 22) {
            if (!this.conn.read(this.byteBuffer)) {
                return;
            }
            this.parseGroupBody();
        }
    }

    private final boolean parseGroupHeader() {
        this.byteBuffer.position(0);
        this.command.receiveSize = (int)(this.byteBuffer.getLong() & 0xFFFFFFFFFFFFL);
        if (this.command.receiveSize <= 0) {
            this.byteBuffer.clear();
            this.byteBuffer.limit(8);
            this.state = 8;
            return false;
        }
        this.command.sizeBuffer(this.command.receiveSize);
        this.command.dataOffset = 0;
        this.byteBuffer.clear();
        if (this.command.receiveSize < this.byteBuffer.capacity()) {
            this.byteBuffer.limit(this.command.receiveSize);
        }
        this.state = 9;
        return true;
    }

    private final boolean parseGroupBody() throws IOException {
        do {
            this.byteBuffer.position(0);
            this.byteBuffer.get(this.command.dataBuffer, this.command.dataOffset, this.byteBuffer.limit());
            this.command.dataOffset += this.byteBuffer.limit();
            this.byteBuffer.clear();
            if (this.command.dataOffset >= this.command.receiveSize) {
                if (this.command.parseResult()) {
                    this.finish();
                    return false;
                }
                this.byteBuffer.limit(8);
                this.command.dataOffset = 0;
                this.state = 8;
                return true;
            }
            int remaining = this.command.receiveSize - this.command.dataOffset;
            if (remaining >= this.byteBuffer.capacity()) continue;
            this.byteBuffer.limit(remaining);
        } while (this.conn.read(this.byteBuffer));
        return false;
    }

    @Override
    public final void timeout() {
        if (this.state == 10) {
            return;
        }
        if (this.timeoutDelay) {
            this.timeoutTask = null;
            this.fail();
            this.tryDelayQueue();
            return;
        }
        long currentTime = 0L;
        if (this.hasTotalTimeout) {
            currentTime = System.nanoTime();
            if (currentTime >= this.totalDeadline) {
                this.totalTimeout();
                return;
            }
            if (this.usingSocketTimeout && this.eventReceived) {
                this.eventReceived = false;
                long deadline = currentTime + TimeUnit.MILLISECONDS.toNanos(this.command.policy.socketTimeout);
                if (deadline >= this.totalDeadline) {
                    deadline = this.totalDeadline;
                    this.usingSocketTimeout = false;
                }
                this.eventLoop.timer.restoreTimeout(this.timeoutTask, deadline);
                return;
            }
        } else if (this.eventReceived) {
            this.eventReceived = false;
            long socketDeadline = System.nanoTime() + TimeUnit.MILLISECONDS.toNanos(this.command.policy.socketTimeout);
            this.eventLoop.timer.restoreTimeout(this.timeoutTask, socketDeadline);
            return;
        }
        if (this.iteration > this.command.policy.maxRetries) {
            this.totalTimeout();
            return;
        }
        this.closeConnection();
        if (this.command.isRead) {
            ++this.command.sequence;
        }
        long timeout = TimeUnit.MILLISECONDS.toNanos(this.command.policy.socketTimeout);
        if (this.hasTotalTimeout) {
            long remaining = this.totalDeadline - currentTime;
            if (remaining <= timeout) {
                timeout = remaining;
                this.usingSocketTimeout = false;
            }
        } else {
            currentTime = System.nanoTime();
        }
        this.eventLoop.timer.restoreTimeout(this.timeoutTask, currentTime + timeout);
        this.executeCommand();
    }

    private final void totalTimeout() {
        AerospikeException.Timeout ae = new AerospikeException.Timeout(this.command.policy, true);
        if (this.state == 2) {
            this.closeFromDelayQueue();
            this.notifyFailure(ae);
            return;
        }
        if (this.command.policy.timeoutDelay > 0) {
            this.timeoutDelay = true;
            this.notifyFailure(ae);
            this.totalDeadline = System.nanoTime() + TimeUnit.MILLISECONDS.toNanos(this.command.policy.timeoutDelay);
            this.eventLoop.timer.restoreTimeout(this.timeoutTask, this.totalDeadline);
            return;
        }
        this.timeoutTask = null;
        this.fail();
        this.notifyFailure(ae);
        this.tryDelayQueue();
    }

    protected final void finish() {
        this.complete();
        if (!this.timeoutDelay) {
            try {
                this.command.onSuccess();
            }
            catch (Exception e) {
                Log.error("onSuccess() error: " + Util.getErrorMessage(e));
            }
        }
        this.tryDelayQueue();
    }

    protected final void onNetworkError(AerospikeException ae, boolean queueCommand) {
        this.closeConnection();
        ++this.command.sequence;
        this.retry(ae, queueCommand);
    }

    protected final void onServerTimeout() {
        this.conn.unregister();
        this.command.node.putAsyncConnection(this.conn, this.eventLoop.index);
        if (this.command.isRead) {
            ++this.command.sequence;
        }
        AerospikeException.Timeout ae = new AerospikeException.Timeout(this.command.policy, false);
        this.retry(ae, false);
    }

    private final void retry(AerospikeException ae, boolean queueCommand) {
        if (this.timeoutDelay) {
            this.close();
            this.tryDelayQueue();
            return;
        }
        if (this.iteration > this.command.policy.maxRetries) {
            this.close();
            this.notifyFailure(ae);
            this.tryDelayQueue();
            return;
        }
        long currentTime = 0L;
        if (this.hasTotalTimeout && (currentTime = System.nanoTime()) >= this.totalDeadline) {
            this.close();
            this.notifyFailure(ae);
            this.tryDelayQueue();
            return;
        }
        if (this.usingSocketTimeout) {
            this.timeoutTask.cancel();
            long timeout = TimeUnit.MILLISECONDS.toNanos(this.command.policy.socketTimeout);
            if (this.hasTotalTimeout) {
                long remaining = this.totalDeadline - currentTime;
                if (remaining <= timeout) {
                    timeout = remaining;
                    this.usingSocketTimeout = false;
                }
            } else {
                currentTime = System.nanoTime();
            }
            this.eventLoop.timer.restoreTimeout(this.timeoutTask, currentTime + timeout);
        }
        if (queueCommand) {
            this.eventLoop.execute(new Runnable(){

                @Override
                public void run() {
                    if (NioCommand.this.state == 10) {
                        return;
                    }
                    if (NioCommand.this.timeoutDelay) {
                        NioCommand.this.close();
                        NioCommand.this.tryDelayQueue();
                        return;
                    }
                    NioCommand.this.executeCommand();
                }
            });
        } else {
            this.executeCommand();
        }
    }

    protected final void onApplicationError(AerospikeException ae) {
        if (ae.keepConnection()) {
            this.complete();
        } else {
            this.fail();
        }
        if (!this.timeoutDelay) {
            this.notifyFailure(ae);
        }
        this.tryDelayQueue();
    }

    private final void notifyFailure(AerospikeException ae) {
        try {
            ae.setNode(this.command.node);
            ae.setIteration(this.iteration);
            ae.setInDoubt(this.command.isRead, this.commandSentCounter);
            this.command.onFailure(ae);
        }
        catch (Exception e) {
            Log.error("onFailure() error: " + Util.getErrorMessage(e));
        }
    }

    private final void complete() {
        this.conn.unregister();
        this.command.node.putAsyncConnection(this.conn, this.eventLoop.index);
        this.close();
    }

    private final void fail() {
        this.closeConnection();
        this.close();
    }

    private final void closeConnection() {
        if (this.conn != null) {
            this.command.node.closeAsyncConnection(this.conn, this.eventLoop.index);
            this.conn = null;
        }
    }

    private final void closeFromDelayQueue() {
        if (this.byteBuffer != null) {
            this.eventLoop.putByteBuffer(this.byteBuffer);
        }
        this.command.putBuffer();
        this.state = 10;
        --this.eventState.pending;
    }

    private final void close() {
        if (this.timeoutTask != null) {
            this.timeoutTask.cancel();
        }
        if (this.byteBuffer != null) {
            this.eventLoop.putByteBuffer(this.byteBuffer);
        }
        this.command.putBuffer();
        this.state = 10;
        --this.eventState.pending;
        --this.eventLoop.pending;
    }
}

