/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.async;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.async.EventLoops;
import com.aerospike.client.async.EventPolicy;
import com.aerospike.client.async.NioEventLoop;
import com.aerospike.client.policy.TlsPolicy;
import com.aerospike.client.util.Util;
import java.io.IOException;
import java.nio.channels.spi.SelectorProvider;

public final class NioEventLoops
implements EventLoops {
    final NioEventLoop[] eventLoops;
    private int eventIter;

    public NioEventLoops() throws AerospikeException {
        this(0);
    }

    public NioEventLoops(int size) throws AerospikeException {
        this(new EventPolicy(), size);
    }

    public NioEventLoops(EventPolicy policy, int size) throws AerospikeException {
        if (policy.minTimeout < 5) {
            throw new AerospikeException("Invalid minTimeout " + policy.minTimeout + ". Must be at least 5ms.");
        }
        if (size <= 0 && (size = Runtime.getRuntime().availableProcessors()) <= 0) {
            size = 1;
        }
        this.eventLoops = new NioEventLoop[size];
        SelectorProvider provider = SelectorProvider.provider();
        for (int i = 0; i < this.eventLoops.length; ++i) {
            try {
                this.eventLoops[i] = new NioEventLoop(policy, provider, i);
                continue;
            }
            catch (IOException ioe) {
                for (int j = 0; j < i; ++j) {
                    this.eventLoops[j].close();
                }
                throw new AerospikeException("Failed to construct event loop: " + Util.getErrorMessage(ioe));
            }
        }
        for (NioEventLoop eventLoop : this.eventLoops) {
            eventLoop.thread.start();
        }
    }

    @Override
    public void initTlsContext(TlsPolicy policy) {
        throw new AerospikeException("TLS not supported in direct NIO event loops");
    }

    public NioEventLoop[] getArray() {
        return this.eventLoops;
    }

    @Override
    public int getSize() {
        return this.eventLoops.length;
    }

    @Override
    public NioEventLoop get(int index2) {
        return this.eventLoops[index2];
    }

    @Override
    public NioEventLoop next() {
        int iter = this.eventIter++;
        if ((iter %= this.eventLoops.length) < 0) {
            iter += this.eventLoops.length;
        }
        return this.eventLoops[iter];
    }

    @Override
    public void close() {
        for (NioEventLoop eventLoop : this.eventLoops) {
            eventLoop.execute(new Runnable(){

                @Override
                public void run() {
                    throw new NioEventLoop.CloseException();
                }
            });
        }
        for (NioEventLoop eventLoop : this.eventLoops) {
            try {
                eventLoop.thread.join();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

