/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.cdt;

import com.aerospike.client.Operation;
import com.aerospike.client.Value;
import com.aerospike.client.cdt.CDT;
import com.aerospike.client.cdt.ListOrder;
import com.aerospike.client.cdt.ListPolicy;
import com.aerospike.client.util.Packer;
import java.util.List;

public class ListOperation {
    private static final int SET_TYPE = 0;
    private static final int APPEND = 1;
    private static final int APPEND_ITEMS = 2;
    private static final int INSERT = 3;
    private static final int INSERT_ITEMS = 4;
    private static final int POP = 5;
    private static final int POP_RANGE = 6;
    private static final int REMOVE = 7;
    private static final int REMOVE_RANGE = 8;
    private static final int SET = 9;
    private static final int TRIM = 10;
    private static final int CLEAR = 11;
    private static final int INCREMENT = 12;
    private static final int SORT = 13;
    private static final int SIZE = 16;
    private static final int GET = 17;
    private static final int GET_RANGE = 18;
    private static final int GET_BY_INDEX = 19;
    private static final int GET_BY_RANK = 21;
    private static final int GET_BY_VALUE = 22;
    private static final int GET_BY_VALUE_LIST = 23;
    private static final int GET_BY_INDEX_RANGE = 24;
    private static final int GET_BY_VALUE_INTERVAL = 25;
    private static final int GET_BY_RANK_RANGE = 26;
    private static final int GET_BY_VALUE_REL_RANK_RANGE = 27;
    private static final int REMOVE_BY_INDEX = 32;
    private static final int REMOVE_BY_RANK = 34;
    private static final int REMOVE_BY_VALUE = 35;
    private static final int REMOVE_BY_VALUE_LIST = 36;
    private static final int REMOVE_BY_INDEX_RANGE = 37;
    private static final int REMOVE_BY_VALUE_INTERVAL = 38;
    private static final int REMOVE_BY_RANK_RANGE = 39;
    private static final int REMOVE_BY_VALUE_REL_RANK_RANGE = 40;

    public static Operation setOrder(String binName, ListOrder order) {
        return CDT.createOperation(0, Operation.Type.CDT_MODIFY, binName, order.attributes);
    }

    public static Operation append(String binName, Value value) {
        Packer packer = new Packer();
        packer.packRawShort(1);
        packer.packArrayBegin(1);
        value.pack(packer);
        return new Operation(Operation.Type.CDT_MODIFY, binName, Value.get(packer.toByteArray()));
    }

    public static Operation append(ListPolicy policy, String binName, Value value) {
        Packer packer = new Packer();
        packer.packRawShort(1);
        packer.packArrayBegin(3);
        value.pack(packer);
        packer.packInt(policy.attributes);
        packer.packInt(policy.flags);
        return new Operation(Operation.Type.CDT_MODIFY, binName, Value.get(packer.toByteArray()));
    }

    public static Operation appendItems(String binName, List<Value> list) {
        Packer packer = new Packer();
        packer.packRawShort(2);
        packer.packArrayBegin(1);
        packer.packValueList(list);
        return new Operation(Operation.Type.CDT_MODIFY, binName, Value.get(packer.toByteArray()));
    }

    public static Operation appendItems(ListPolicy policy, String binName, List<Value> list) {
        Packer packer = new Packer();
        packer.packRawShort(2);
        packer.packArrayBegin(3);
        packer.packValueList(list);
        packer.packInt(policy.attributes);
        packer.packInt(policy.flags);
        return new Operation(Operation.Type.CDT_MODIFY, binName, Value.get(packer.toByteArray()));
    }

    public static Operation insert(String binName, int index2, Value value) {
        return CDT.createOperation(3, Operation.Type.CDT_MODIFY, binName, index2, value);
    }

    public static Operation insert(ListPolicy policy, String binName, int index2, Value value) {
        return CDT.createOperation(3, Operation.Type.CDT_MODIFY, binName, index2, value, policy.flags);
    }

    public static Operation insertItems(String binName, int index2, List<Value> list) {
        Packer packer = new Packer();
        packer.packRawShort(4);
        packer.packArrayBegin(2);
        packer.packInt(index2);
        packer.packValueList(list);
        return new Operation(Operation.Type.CDT_MODIFY, binName, Value.get(packer.toByteArray()));
    }

    public static Operation insertItems(ListPolicy policy, String binName, int index2, List<Value> list) {
        Packer packer = new Packer();
        packer.packRawShort(4);
        packer.packArrayBegin(3);
        packer.packInt(index2);
        packer.packValueList(list);
        packer.packInt(policy.flags);
        return new Operation(Operation.Type.CDT_MODIFY, binName, Value.get(packer.toByteArray()));
    }

    public static Operation increment(String binName, int index2) {
        return CDT.createOperation(12, Operation.Type.CDT_MODIFY, binName, index2);
    }

    public static Operation increment(ListPolicy policy, String binName, int index2) {
        return CDT.createOperation(12, Operation.Type.CDT_MODIFY, binName, index2, Value.get(1), policy.attributes, policy.flags);
    }

    public static Operation increment(String binName, int index2, Value value) {
        return CDT.createOperation(12, Operation.Type.CDT_MODIFY, binName, index2, value);
    }

    public static Operation increment(ListPolicy policy, String binName, int index2, Value value) {
        return CDT.createOperation(12, Operation.Type.CDT_MODIFY, binName, index2, value, policy.attributes, policy.flags);
    }

    public static Operation pop(String binName, int index2) {
        return CDT.createOperation(5, Operation.Type.CDT_MODIFY, binName, index2);
    }

    public static Operation popRange(String binName, int index2, int count) {
        return CDT.createOperation(6, Operation.Type.CDT_MODIFY, binName, index2, count);
    }

    public static Operation popRange(String binName, int index2) {
        return CDT.createOperation(6, Operation.Type.CDT_MODIFY, binName, index2);
    }

    public static Operation remove(String binName, int index2) {
        return CDT.createOperation(7, Operation.Type.CDT_MODIFY, binName, index2);
    }

    public static Operation removeRange(String binName, int index2, int count) {
        return CDT.createOperation(8, Operation.Type.CDT_MODIFY, binName, index2, count);
    }

    public static Operation removeRange(String binName, int index2) {
        return CDT.createOperation(8, Operation.Type.CDT_MODIFY, binName, index2);
    }

    public static Operation set(String binName, int index2, Value value) {
        return CDT.createOperation(9, Operation.Type.CDT_MODIFY, binName, index2, value);
    }

    public static Operation set(ListPolicy policy, String binName, int index2, Value value) {
        return CDT.createOperation(9, Operation.Type.CDT_MODIFY, binName, index2, value, policy.flags);
    }

    public static Operation trim(String binName, int index2, int count) {
        return CDT.createOperation(10, Operation.Type.CDT_MODIFY, binName, index2, count);
    }

    public static Operation clear(String binName) {
        return CDT.createOperation(11, Operation.Type.CDT_MODIFY, binName);
    }

    public static Operation sort(String binName, int sortFlags) {
        return CDT.createOperation(13, Operation.Type.CDT_MODIFY, binName, sortFlags);
    }

    public static Operation removeByValue(String binName, Value value, int returnType) {
        return CDT.createOperation(35, Operation.Type.CDT_MODIFY, binName, returnType, value);
    }

    public static Operation removeByValueList(String binName, List<Value> values, int returnType) {
        return CDT.createOperation(36, Operation.Type.CDT_MODIFY, binName, returnType, values);
    }

    public static Operation removeByValueRange(String binName, Value valueBegin, Value valueEnd, int returnType) {
        return CDT.createRangeOperation(38, Operation.Type.CDT_MODIFY, binName, valueBegin, valueEnd, returnType);
    }

    public static Operation removeByValueRelativeRankRange(String binName, Value value, int rank, int returnType) {
        return CDT.createOperation(40, Operation.Type.CDT_MODIFY, binName, returnType, value, rank);
    }

    public static Operation removeByValueRelativeRankRange(String binName, Value value, int rank, int count, int returnType) {
        return CDT.createOperation(40, Operation.Type.CDT_MODIFY, binName, returnType, value, rank, count);
    }

    public static Operation removeByIndex(String binName, int index2, int returnType) {
        return CDT.createOperation(32, Operation.Type.CDT_MODIFY, binName, returnType, index2);
    }

    public static Operation removeByIndexRange(String binName, int index2, int returnType) {
        return CDT.createOperation(37, Operation.Type.CDT_MODIFY, binName, returnType, index2);
    }

    public static Operation removeByIndexRange(String binName, int index2, int count, int returnType) {
        return CDT.createOperation(37, Operation.Type.CDT_MODIFY, binName, returnType, index2, count);
    }

    public static Operation removeByRank(String binName, int rank, int returnType) {
        return CDT.createOperation(34, Operation.Type.CDT_MODIFY, binName, returnType, rank);
    }

    public static Operation removeByRankRange(String binName, int rank, int returnType) {
        return CDT.createOperation(39, Operation.Type.CDT_MODIFY, binName, returnType, rank);
    }

    public static Operation removeByRankRange(String binName, int rank, int count, int returnType) {
        return CDT.createOperation(39, Operation.Type.CDT_MODIFY, binName, returnType, rank, count);
    }

    public static Operation size(String binName) {
        return CDT.createOperation(16, Operation.Type.CDT_READ, binName);
    }

    public static Operation get(String binName, int index2) {
        return CDT.createOperation(17, Operation.Type.CDT_READ, binName, index2);
    }

    public static Operation getRange(String binName, int index2, int count) {
        return CDT.createOperation(18, Operation.Type.CDT_READ, binName, index2, count);
    }

    public static Operation getRange(String binName, int index2) {
        return CDT.createOperation(18, Operation.Type.CDT_READ, binName, index2);
    }

    public static Operation getByValue(String binName, Value value, int returnType) {
        return CDT.createOperation(22, Operation.Type.CDT_READ, binName, returnType, value);
    }

    public static Operation getByValueRange(String binName, Value valueBegin, Value valueEnd, int returnType) {
        return CDT.createRangeOperation(25, Operation.Type.CDT_READ, binName, valueBegin, valueEnd, returnType);
    }

    public static Operation getByValueList(String binName, List<Value> values, int returnType) {
        return CDT.createOperation(23, Operation.Type.CDT_READ, binName, returnType, values);
    }

    public static Operation getByValueRelativeRankRange(String binName, Value value, int rank, int returnType) {
        return CDT.createOperation(27, Operation.Type.CDT_READ, binName, returnType, value, rank);
    }

    public static Operation getByValueRelativeRankRange(String binName, Value value, int rank, int count, int returnType) {
        return CDT.createOperation(27, Operation.Type.CDT_READ, binName, returnType, value, rank, count);
    }

    public static Operation getByIndex(String binName, int index2, int returnType) {
        return CDT.createOperation(19, Operation.Type.CDT_READ, binName, returnType, index2);
    }

    public static Operation getByIndexRange(String binName, int index2, int returnType) {
        return CDT.createOperation(24, Operation.Type.CDT_READ, binName, returnType, index2);
    }

    public static Operation getByIndexRange(String binName, int index2, int count, int returnType) {
        return CDT.createOperation(24, Operation.Type.CDT_READ, binName, returnType, index2, count);
    }

    public static Operation getByRank(String binName, int rank, int returnType) {
        return CDT.createOperation(21, Operation.Type.CDT_READ, binName, returnType, rank);
    }

    public static Operation getByRankRange(String binName, int rank, int returnType) {
        return CDT.createOperation(26, Operation.Type.CDT_READ, binName, returnType, rank);
    }

    public static Operation getByRankRange(String binName, int rank, int count, int returnType) {
        return CDT.createOperation(26, Operation.Type.CDT_READ, binName, returnType, rank, count);
    }
}

