/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.cdt;

import com.aerospike.client.Operation;
import com.aerospike.client.Value;
import com.aerospike.client.cdt.CDT;
import com.aerospike.client.cdt.MapPolicy;
import com.aerospike.client.util.Packer;
import java.util.List;
import java.util.Map;

public class MapOperation {
    private static final int SET_TYPE = 64;
    protected static final int ADD = 65;
    protected static final int ADD_ITEMS = 66;
    protected static final int PUT = 67;
    protected static final int PUT_ITEMS = 68;
    protected static final int REPLACE = 69;
    protected static final int REPLACE_ITEMS = 70;
    private static final int INCREMENT = 73;
    private static final int DECREMENT = 74;
    private static final int CLEAR = 75;
    private static final int REMOVE_BY_KEY = 76;
    private static final int REMOVE_BY_INDEX = 77;
    private static final int REMOVE_BY_RANK = 79;
    private static final int REMOVE_BY_KEY_LIST = 81;
    private static final int REMOVE_BY_VALUE = 82;
    private static final int REMOVE_BY_VALUE_LIST = 83;
    private static final int REMOVE_BY_KEY_INTERVAL = 84;
    private static final int REMOVE_BY_INDEX_RANGE = 85;
    private static final int REMOVE_BY_VALUE_INTERVAL = 86;
    private static final int REMOVE_BY_RANK_RANGE = 87;
    private static final int REMOVE_BY_KEY_REL_INDEX_RANGE = 88;
    private static final int REMOVE_BY_VALUE_REL_RANK_RANGE = 89;
    private static final int SIZE = 96;
    private static final int GET_BY_KEY = 97;
    private static final int GET_BY_INDEX = 98;
    private static final int GET_BY_RANK = 100;
    private static final int GET_BY_VALUE = 102;
    private static final int GET_BY_KEY_INTERVAL = 103;
    private static final int GET_BY_INDEX_RANGE = 104;
    private static final int GET_BY_VALUE_INTERVAL = 105;
    private static final int GET_BY_RANK_RANGE = 106;
    private static final int GET_BY_KEY_LIST = 107;
    private static final int GET_BY_VALUE_LIST = 108;
    private static final int GET_BY_KEY_REL_INDEX_RANGE = 109;
    private static final int GET_BY_VALUE_REL_RANK_RANGE = 110;

    public static Operation setMapPolicy(MapPolicy policy, String binName) {
        return CDT.createOperation(64, Operation.Type.MAP_MODIFY, binName, policy.attributes);
    }

    public static Operation put(MapPolicy policy, String binName, Value key, Value value) {
        Packer packer = new Packer();
        if (policy.flags != 0) {
            packer.packRawShort(67);
            packer.packArrayBegin(4);
            key.pack(packer);
            value.pack(packer);
            packer.packInt(policy.attributes);
            packer.packInt(policy.flags);
        } else {
            packer.packRawShort(policy.itemCommand);
            if (policy.itemCommand == 69) {
                packer.packArrayBegin(2);
                key.pack(packer);
                value.pack(packer);
            } else {
                packer.packArrayBegin(3);
                key.pack(packer);
                value.pack(packer);
                packer.packInt(policy.attributes);
            }
        }
        return new Operation(Operation.Type.MAP_MODIFY, binName, Value.get(packer.toByteArray()));
    }

    public static Operation putItems(MapPolicy policy, String binName, Map<Value, Value> map) {
        Packer packer = new Packer();
        if (policy.flags != 0) {
            packer.packRawShort(68);
            packer.packArrayBegin(3);
            packer.packValueMap(map);
            packer.packInt(policy.attributes);
            packer.packInt(policy.flags);
        } else {
            packer.packRawShort(policy.itemsCommand);
            if (policy.itemsCommand == 70) {
                packer.packArrayBegin(1);
                packer.packValueMap(map);
            } else {
                packer.packArrayBegin(2);
                packer.packValueMap(map);
                packer.packInt(policy.attributes);
            }
        }
        return new Operation(Operation.Type.MAP_MODIFY, binName, Value.get(packer.toByteArray()));
    }

    public static Operation increment(MapPolicy policy, String binName, Value key, Value incr) {
        return CDT.createOperation(73, Operation.Type.MAP_MODIFY, binName, key, incr, policy.attributes);
    }

    public static Operation decrement(MapPolicy policy, String binName, Value key, Value decr) {
        return CDT.createOperation(74, Operation.Type.MAP_MODIFY, binName, key, decr, policy.attributes);
    }

    public static Operation clear(String binName) {
        return CDT.createOperation(75, Operation.Type.MAP_MODIFY, binName);
    }

    public static Operation removeByKey(String binName, Value key, int returnType) {
        return CDT.createOperation(76, Operation.Type.MAP_MODIFY, binName, returnType, key);
    }

    public static Operation removeByKeyList(String binName, List<Value> keys, int returnType) {
        return CDT.createOperation(81, Operation.Type.MAP_MODIFY, binName, returnType, keys);
    }

    public static Operation removeByKeyRange(String binName, Value keyBegin, Value keyEnd, int returnType) {
        return CDT.createRangeOperation(84, Operation.Type.MAP_MODIFY, binName, keyBegin, keyEnd, returnType);
    }

    public static Operation removeByKeyRelativeIndexRange(String binName, Value key, int index2, int returnType) {
        return CDT.createOperation(88, Operation.Type.MAP_MODIFY, binName, returnType, key, index2);
    }

    public static Operation removeByKeyRelativeIndexRange(String binName, Value key, int index2, int count, int returnType) {
        return CDT.createOperation(88, Operation.Type.MAP_MODIFY, binName, returnType, key, index2, count);
    }

    public static Operation removeByValue(String binName, Value value, int returnType) {
        return CDT.createOperation(82, Operation.Type.MAP_MODIFY, binName, returnType, value);
    }

    public static Operation removeByValueList(String binName, List<Value> values, int returnType) {
        return CDT.createOperation(83, Operation.Type.MAP_MODIFY, binName, returnType, values);
    }

    public static Operation removeByValueRange(String binName, Value valueBegin, Value valueEnd, int returnType) {
        return CDT.createRangeOperation(86, Operation.Type.MAP_MODIFY, binName, valueBegin, valueEnd, returnType);
    }

    public static Operation removeByValueRelativeRankRange(String binName, Value value, int rank, int returnType) {
        return CDT.createOperation(89, Operation.Type.MAP_MODIFY, binName, returnType, value, rank);
    }

    public static Operation removeByValueRelativeRankRange(String binName, Value value, int rank, int count, int returnType) {
        return CDT.createOperation(89, Operation.Type.MAP_MODIFY, binName, returnType, value, rank, count);
    }

    public static Operation removeByIndex(String binName, int index2, int returnType) {
        return CDT.createOperation(77, Operation.Type.MAP_MODIFY, binName, returnType, index2);
    }

    public static Operation removeByIndexRange(String binName, int index2, int returnType) {
        return CDT.createOperation(85, Operation.Type.MAP_MODIFY, binName, returnType, index2);
    }

    public static Operation removeByIndexRange(String binName, int index2, int count, int returnType) {
        return CDT.createOperation(85, Operation.Type.MAP_MODIFY, binName, returnType, index2, count);
    }

    public static Operation removeByRank(String binName, int rank, int returnType) {
        return CDT.createOperation(79, Operation.Type.MAP_MODIFY, binName, returnType, rank);
    }

    public static Operation removeByRankRange(String binName, int rank, int returnType) {
        return CDT.createOperation(87, Operation.Type.MAP_MODIFY, binName, returnType, rank);
    }

    public static Operation removeByRankRange(String binName, int rank, int count, int returnType) {
        return CDT.createOperation(87, Operation.Type.MAP_MODIFY, binName, returnType, rank, count);
    }

    public static Operation size(String binName) {
        return CDT.createOperation(96, Operation.Type.MAP_READ, binName);
    }

    public static Operation getByKey(String binName, Value key, int returnType) {
        return CDT.createOperation(97, Operation.Type.MAP_READ, binName, returnType, key);
    }

    public static Operation getByKeyRange(String binName, Value keyBegin, Value keyEnd, int returnType) {
        return CDT.createRangeOperation(103, Operation.Type.MAP_READ, binName, keyBegin, keyEnd, returnType);
    }

    public static Operation getByKeyList(String binName, List<Value> keys, int returnType) {
        return CDT.createOperation(107, Operation.Type.MAP_READ, binName, returnType, keys);
    }

    public static Operation getByKeyRelativeIndexRange(String binName, Value key, int index2, int returnType) {
        return CDT.createOperation(109, Operation.Type.MAP_READ, binName, returnType, key, index2);
    }

    public static Operation getByKeyRelativeIndexRange(String binName, Value key, int index2, int count, int returnType) {
        return CDT.createOperation(109, Operation.Type.MAP_READ, binName, returnType, key, index2, count);
    }

    public static Operation getByValue(String binName, Value value, int returnType) {
        return CDT.createOperation(102, Operation.Type.MAP_READ, binName, returnType, value);
    }

    public static Operation getByValueRange(String binName, Value valueBegin, Value valueEnd, int returnType) {
        return CDT.createRangeOperation(105, Operation.Type.MAP_READ, binName, valueBegin, valueEnd, returnType);
    }

    public static Operation getByValueList(String binName, List<Value> values, int returnType) {
        return CDT.createOperation(108, Operation.Type.MAP_READ, binName, returnType, values);
    }

    public static Operation getByValueRelativeRankRange(String binName, Value value, int rank, int returnType) {
        return CDT.createOperation(110, Operation.Type.MAP_READ, binName, returnType, value, rank);
    }

    public static Operation getByValueRelativeRankRange(String binName, Value value, int rank, int count, int returnType) {
        return CDT.createOperation(110, Operation.Type.MAP_READ, binName, returnType, value, rank, count);
    }

    public static Operation getByIndex(String binName, int index2, int returnType) {
        return CDT.createOperation(98, Operation.Type.MAP_READ, binName, returnType, index2);
    }

    public static Operation getByIndexRange(String binName, int index2, int returnType) {
        return CDT.createOperation(104, Operation.Type.MAP_READ, binName, returnType, index2);
    }

    public static Operation getByIndexRange(String binName, int index2, int count, int returnType) {
        return CDT.createOperation(104, Operation.Type.MAP_READ, binName, returnType, index2, count);
    }

    public static Operation getByRank(String binName, int rank, int returnType) {
        return CDT.createOperation(100, Operation.Type.MAP_READ, binName, returnType, rank);
    }

    public static Operation getByRankRange(String binName, int rank, int returnType) {
        return CDT.createOperation(106, Operation.Type.MAP_READ, binName, returnType, rank);
    }

    public static Operation getByRankRange(String binName, int rank, int count, int returnType) {
        return CDT.createOperation(106, Operation.Type.MAP_READ, binName, returnType, rank, count);
    }
}

