/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.cluster;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.Host;
import com.aerospike.client.Log;
import com.aerospike.client.Value;
import com.aerospike.client.admin.AdminCommand;
import com.aerospike.client.async.EventLoop;
import com.aerospike.client.async.EventLoops;
import com.aerospike.client.async.EventState;
import com.aerospike.client.cluster.ClusterStats;
import com.aerospike.client.cluster.Node;
import com.aerospike.client.cluster.NodeStats;
import com.aerospike.client.cluster.NodeValidator;
import com.aerospike.client.cluster.Partition;
import com.aerospike.client.cluster.Partitions;
import com.aerospike.client.cluster.Peers;
import com.aerospike.client.cluster.ThreadDaemonFactory;
import com.aerospike.client.command.Buffer;
import com.aerospike.client.policy.AuthMode;
import com.aerospike.client.policy.ClientPolicy;
import com.aerospike.client.policy.TlsPolicy;
import com.aerospike.client.util.Util;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReferenceArray;

public class Cluster
implements Runnable,
Closeable {
    private static final int MaxSocketIdleSecondLimit = 86400;
    protected final String clusterName;
    private volatile Host[] seeds;
    protected final HashMap<Host, Node> aliases;
    protected final HashMap<String, Node> nodesMap;
    private volatile Node[] nodes;
    public volatile HashMap<String, Partitions> partitionMap;
    protected final Map<String, String> ipMap;
    protected final TlsPolicy tlsPolicy;
    public final AuthMode authMode;
    protected final byte[] user;
    private byte[] password;
    private byte[] passwordHash;
    private final AtomicInteger nodeIndex;
    private final AtomicInteger replicaIndex;
    private final ExecutorService threadPool;
    public final EventLoops eventLoops;
    public final EventState[] eventState;
    public final long maxSocketIdleNanos;
    protected final int connectionQueueSize;
    protected final int connPoolsPerNode;
    public final int connectionTimeout;
    public final int loginTimeout;
    private final int tendInterval;
    private Thread tendThread;
    protected volatile boolean tendValid;
    private final boolean sharedThreadPool;
    protected boolean requestProleReplicas;
    protected final boolean useServicesAlternate;
    private boolean asyncComplete;

    public Cluster(ClientPolicy policy, Host[] hosts) throws AerospikeException {
        int i;
        this.clusterName = policy.clusterName;
        this.tlsPolicy = policy.tlsPolicy;
        this.authMode = policy.authMode;
        if (this.tlsPolicy != null) {
            boolean useClusterName = this.clusterName != null && this.clusterName.length() > 0;
            for (i = 0; i < hosts.length; ++i) {
                Host host = hosts[i];
                if (host.tlsName != null) continue;
                String tlsName = useClusterName ? this.clusterName : host.name;
                hosts[i] = new Host(host.name, tlsName, host.port);
            }
        } else if (this.authMode == AuthMode.EXTERNAL) {
            throw new AerospikeException("TLS is required for authentication mode: " + (Object)((Object)this.authMode));
        }
        this.seeds = hosts;
        if (policy.user != null && policy.user.length() > 0) {
            String pass;
            this.user = Buffer.stringToUtf8(policy.user);
            if (this.authMode != AuthMode.INTERNAL) {
                this.password = Buffer.stringToUtf8(policy.password);
            }
            if ((pass = policy.password) == null) {
                pass = "";
            }
            if (pass.length() != 60 || !pass.startsWith("$2a$")) {
                pass = AdminCommand.hashPassword(pass);
            }
            this.passwordHash = Buffer.stringToUtf8(pass);
        } else {
            this.user = null;
        }
        this.connectionQueueSize = policy.maxConnsPerNode;
        this.connPoolsPerNode = policy.connPoolsPerNode;
        this.connectionTimeout = policy.timeout;
        this.loginTimeout = policy.loginTimeout;
        this.maxSocketIdleNanos = TimeUnit.SECONDS.toNanos(policy.maxSocketIdle <= 86400 ? (long)policy.maxSocketIdle : 86400L);
        this.tendInterval = policy.tendInterval;
        this.ipMap = policy.ipMap;
        this.threadPool = policy.threadPool == null ? Executors.newCachedThreadPool(new ThreadDaemonFactory()) : policy.threadPool;
        this.sharedThreadPool = policy.sharedThreadPool;
        this.requestProleReplicas = policy.requestProleReplicas;
        this.useServicesAlternate = policy.useServicesAlternate;
        this.aliases = new HashMap();
        this.nodesMap = new HashMap();
        this.nodes = new Node[0];
        this.partitionMap = new HashMap();
        this.nodeIndex = new AtomicInteger();
        this.replicaIndex = new AtomicInteger();
        this.eventLoops = policy.eventLoops;
        if (this.eventLoops != null) {
            EventLoop[] loops = this.eventLoops.getArray();
            this.eventState = new EventState[loops.length];
            for (i = 0; i < loops.length; ++i) {
                this.eventState[i] = loops[i].createState();
            }
            if (policy.tlsPolicy != null) {
                this.eventLoops.initTlsContext(policy.tlsPolicy);
            }
        } else {
            this.eventState = null;
        }
        if (policy.forceSingleNode) {
            try {
                this.forceSingleNode();
            }
            catch (RuntimeException e) {
                this.close();
                throw e;
            }
        } else {
            this.initTendThread(policy.failIfNotConnected);
        }
    }

    public void forceSingleNode() {
        this.tendValid = true;
        this.tendThread = new Thread(this);
        Host seed = this.seeds[0];
        NodeValidator nv = new NodeValidator();
        HashMap<String, Node> nodesToAdd = new HashMap<String, Node>();
        try {
            nv.seedNodes(this, seed, nodesToAdd);
        }
        catch (Exception e) {
            throw new AerospikeException("Seed " + seed + " failed: " + e.getMessage(), (Throwable)e);
        }
        this.addNodes(nodesToAdd);
        Node node = this.nodes[0];
        Peers peers = new Peers(this.nodes.length + 16, 16);
        node.refreshPartitions(peers);
        for (Partitions partitions : this.partitionMap.values()) {
            for (AtomicReferenceArray<Node> nodeArray : partitions.replicas) {
                int max = nodeArray.length();
                for (int i = 0; i < max; ++i) {
                    nodeArray.set(i, node);
                }
            }
        }
    }

    public void initTendThread(boolean failIfNotConnected) throws AerospikeException {
        this.waitTillStabilized(failIfNotConnected);
        if (Log.debugEnabled()) {
            for (Host host : this.seeds) {
                Log.debug("Add seed " + host);
            }
        }
        ArrayList<Host> seedsToAdd = new ArrayList<Host>(this.nodes.length);
        for (Node node : this.nodes) {
            Host host = node.getHost();
            if (!this.findSeed(host)) {
                seedsToAdd.add(host);
            }
            if (Value.UseDoubleType && !node.hasDouble()) {
                if (Log.warnEnabled()) {
                    Log.warn("Some nodes don't support new double type.  Disabling.");
                }
                Value.UseDoubleType = false;
            }
            if (!this.requestProleReplicas || node.hasReplicasAll()) continue;
            if (Log.warnEnabled()) {
                Log.warn("Some nodes don't support 'replicas-all'.  Use 'replicas-master' for all nodes.");
            }
            this.requestProleReplicas = false;
        }
        if (seedsToAdd.size() > 0) {
            this.addSeeds(seedsToAdd.toArray(new Host[seedsToAdd.size()]));
        }
        this.tendValid = true;
        this.tendThread = new Thread(this);
        this.tendThread.setName("tend");
        this.tendThread.setDaemon(true);
        this.tendThread.start();
    }

    public final void addSeeds(Host[] hosts) {
        Host[] seedArray = new Host[this.seeds.length + hosts.length];
        int count = 0;
        for (Host seed : this.seeds) {
            seedArray[count++] = seed;
        }
        for (Host host : hosts) {
            if (Log.debugEnabled()) {
                Log.debug("Add seed " + host);
            }
            seedArray[count++] = host;
        }
        this.seeds = seedArray;
    }

    private final boolean findSeed(Host search) {
        for (Host seed : this.seeds) {
            if (!seed.equals(search)) continue;
            return true;
        }
        return false;
    }

    private final void waitTillStabilized(boolean failIfNotConnected) throws AerospikeException {
        int count = -1;
        for (int i = 0; i < 3; ++i) {
            this.tend(failIfNotConnected);
            if (count == this.nodes.length) {
                return;
            }
            Util.sleep(1L);
            count = this.nodes.length;
        }
        String message = "Cluster not stabilized after multiple tend attempts";
        if (failIfNotConnected) {
            throw new AerospikeException(message);
        }
        Log.warn(message);
    }

    @Override
    public final void run() {
        while (this.tendValid) {
            block3: {
                try {
                    this.tend(false);
                }
                catch (Exception e) {
                    if (!Log.warnEnabled()) break block3;
                    Log.warn("Cluster tend failed: " + Util.getErrorMessage(e));
                }
            }
            Util.sleep(this.tendInterval);
        }
    }

    private final void tend(boolean failIfNotConnected) throws AerospikeException {
        ArrayList<Node> removeList;
        if (this.nodes.length == 0) {
            this.seedNodes(failIfNotConnected);
        }
        Peers peers = new Peers(this.nodes.length + 16, 16);
        for (Node node : this.nodes) {
            node.referenceCount = 0;
            node.partitionChanged = false;
            if (node.hasPeers()) continue;
            peers.usePeers = false;
        }
        for (Node node : this.nodes) {
            node.refresh(peers);
        }
        if (peers.genChanged) {
            peers.refreshCount = 0;
            for (Node node : this.nodes) {
                node.refreshPeers(peers);
            }
        }
        for (Node node : this.nodes) {
            if (!node.partitionChanged) continue;
            node.refreshPartitions(peers);
        }
        if ((peers.genChanged || !peers.usePeers) && (removeList = this.findNodesToRemove(peers.refreshCount)).size() > 0) {
            this.removeNodes(removeList);
        }
        if (peers.nodes.size() > 0) {
            this.addNodes(peers.nodes);
        }
    }

    private final boolean seedNodes(boolean failIfNotConnected) throws AerospikeException {
        Host[] seedArray = this.seeds;
        Exception[] exceptions = null;
        HashMap<String, Node> nodesToAdd = new HashMap<String, Node>(seedArray.length + 16);
        for (int i = 0; i < seedArray.length; ++i) {
            Host seed = seedArray[i];
            try {
                NodeValidator nv = new NodeValidator();
                nv.seedNodes(this, seed, nodesToAdd);
                continue;
            }
            catch (Exception e) {
                if (failIfNotConnected) {
                    if (exceptions == null) {
                        exceptions = new Exception[seedArray.length];
                    }
                    exceptions[i] = e;
                    continue;
                }
                if (!Log.warnEnabled()) continue;
                Log.warn("Seed " + seed + " failed: " + Util.getErrorMessage(e));
            }
        }
        if (nodesToAdd.size() > 0) {
            this.addNodes(nodesToAdd);
            return true;
        }
        if (failIfNotConnected) {
            StringBuilder sb = new StringBuilder(500);
            sb.append("Failed to connect to host(s): ");
            sb.append(System.lineSeparator());
            for (int i = 0; i < seedArray.length; ++i) {
                Exception ex;
                sb.append(seedArray[i]);
                sb.append(' ');
                Exception exception = ex = exceptions == null ? null : exceptions[i];
                if (ex == null) continue;
                sb.append(ex.getMessage());
                sb.append(System.lineSeparator());
            }
            throw new AerospikeException.Connection(sb.toString());
        }
        return false;
    }

    protected Node createNode(NodeValidator nv) {
        return new Node(this, nv);
    }

    private final ArrayList<Node> findNodesToRemove(int refreshCount) {
        ArrayList<Node> removeList = new ArrayList<Node>();
        for (Node node : this.nodes) {
            if (!node.isActive()) {
                removeList.add(node);
                continue;
            }
            if (refreshCount == 0 && node.failures >= 5) {
                removeList.add(node);
                continue;
            }
            if (this.nodes.length <= 1 || refreshCount < 1 || node.referenceCount != 0) continue;
            if (node.failures == 0) {
                if (this.findNodeInPartitionMap(node)) continue;
                removeList.add(node);
                continue;
            }
            removeList.add(node);
        }
        return removeList;
    }

    private final boolean findNodeInPartitionMap(Node filter) {
        for (Partitions partitions : this.partitionMap.values()) {
            for (AtomicReferenceArray<Node> nodeArray : partitions.replicas) {
                int max = nodeArray.length();
                for (int i = 0; i < max; ++i) {
                    Node node = nodeArray.get(i);
                    if (node != filter) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private final void addNodes(HashMap<String, Node> nodesToAdd) {
        Node[] nodeArray = new Node[this.nodes.length + nodesToAdd.size()];
        int count = 0;
        for (Node node : this.nodes) {
            nodeArray[count++] = node;
        }
        for (Node node : nodesToAdd.values()) {
            if (Log.infoEnabled()) {
                Log.info("Add node " + node);
            }
            nodeArray[count++] = node;
            this.nodesMap.put(node.getName(), node);
            for (Host alias : node.aliases) {
                this.aliases.put(alias, node);
            }
        }
        this.nodes = nodeArray;
    }

    private final void removeNodes(List<Node> nodesToRemove) {
        for (Node node : nodesToRemove) {
            this.nodesMap.remove(node.getName());
            for (Host alias : node.aliases) {
                this.aliases.remove(alias);
            }
            node.close();
        }
        this.removeNodesCopy(nodesToRemove);
    }

    private final void removeNodesCopy(List<Node> nodesToRemove) {
        Node[] nodeArray = new Node[this.nodes.length - nodesToRemove.size()];
        int count = 0;
        for (Node node : this.nodes) {
            if (Cluster.findNode(node, nodesToRemove)) {
                if (!Log.infoEnabled()) continue;
                Log.info("Remove node " + node);
                continue;
            }
            nodeArray[count++] = node;
        }
        if (count < nodeArray.length) {
            if (Log.warnEnabled()) {
                Log.warn("Node remove mismatch. Expected " + nodeArray.length + " Received " + count);
            }
            Node[] nodeArray2 = new Node[count];
            System.arraycopy(nodeArray, 0, nodeArray2, 0, count);
            nodeArray = nodeArray2;
        }
        this.nodes = nodeArray;
    }

    private static final boolean findNode(Node search, List<Node> nodeList) {
        for (Node node : nodeList) {
            if (!node.equals(search)) continue;
            return true;
        }
        return false;
    }

    public final boolean isConnected() {
        Node[] nodeArray = this.nodes;
        if (nodeArray.length > 0 && this.tendValid) {
            for (Node node : nodeArray) {
                if (!node.active || node.failures >= 5) continue;
                return true;
            }
        }
        return false;
    }

    public final Node getMasterNode(Partition partition) throws AerospikeException.InvalidNode {
        HashMap<String, Partitions> map = this.partitionMap;
        Partitions partitions = map.get(partition.namespace);
        if (partitions == null) {
            throw new AerospikeException("Invalid namespace: " + partition.namespace);
        }
        Node node = partitions.replicas[0].get(partition.partitionId);
        if (node != null && node.isActive()) {
            return node;
        }
        Node[] nodeArray = this.nodes;
        throw new AerospikeException.InvalidNode(nodeArray.length, partition);
    }

    public final Node getMasterProlesNode(Partition partition) throws AerospikeException.InvalidNode {
        HashMap<String, Partitions> map = this.partitionMap;
        Partitions partitions = map.get(partition.namespace);
        if (partitions == null) {
            throw new AerospikeException("Invalid namespace: " + partition.namespace);
        }
        AtomicReferenceArray<Node>[] replicas = partitions.replicas;
        for (int i = 0; i < replicas.length; ++i) {
            int index2 = Math.abs(this.replicaIndex.getAndIncrement() % replicas.length);
            Node node = replicas[index2].get(partition.partitionId);
            if (node == null || !node.isActive()) continue;
            return node;
        }
        Node[] nodeArray = this.nodes;
        throw new AerospikeException.InvalidNode(nodeArray.length, partition);
    }

    public final Node getRandomNode() throws AerospikeException.InvalidNode {
        Node[] nodeArray = this.nodes;
        for (int i = 0; i < nodeArray.length; ++i) {
            int index2 = Math.abs(this.nodeIndex.getAndIncrement() % nodeArray.length);
            Node node = nodeArray[index2];
            if (!node.isActive()) continue;
            return node;
        }
        throw new AerospikeException.InvalidNode("Cluster is empty");
    }

    public final Node[] getNodes() {
        Node[] nodeArray = this.nodes;
        return nodeArray;
    }

    public final Node getNode(String nodeName) throws AerospikeException.InvalidNode {
        Node node = this.findNode(nodeName);
        if (node == null) {
            throw new AerospikeException.InvalidNode("Invalid node name: " + nodeName);
        }
        return node;
    }

    protected final Node findNode(String nodeName) {
        Node[] nodeArray;
        for (Node node : nodeArray = this.nodes) {
            if (!node.getName().equals(nodeName)) continue;
            return node;
        }
        return null;
    }

    public final ClusterStats getStats() {
        Node[] nodeArray = this.nodes;
        NodeStats[] nodeStats = new NodeStats[nodeArray.length];
        int count = 0;
        for (Node node : nodeArray) {
            nodeStats[count++] = new NodeStats(node);
        }
        int threadsInUse = 0;
        if (this.threadPool instanceof ThreadPoolExecutor) {
            ThreadPoolExecutor tpe = (ThreadPoolExecutor)this.threadPool;
            threadsInUse = tpe.getActiveCount();
        }
        return new ClusterStats(nodeStats, threadsInUse);
    }

    public final void interruptTendSleep() {
        this.tendThread.interrupt();
    }

    public final void printPartitionMap() {
        for (Map.Entry<String, Partitions> entry : this.partitionMap.entrySet()) {
            String namespace = entry.getKey();
            Partitions partitions = entry.getValue();
            AtomicReferenceArray<Node>[] replicas = partitions.replicas;
            for (int i = 0; i < replicas.length; ++i) {
                AtomicReferenceArray<Node> nodeArray = replicas[i];
                int max = nodeArray.length();
                for (int j = 0; j < max; ++j) {
                    Node node = nodeArray.get(j);
                    if (node == null) continue;
                    Log.info(namespace + ',' + i + ',' + j + ',' + node);
                }
            }
        }
    }

    public void changePassword(byte[] user, byte[] password, byte[] passwordHash) {
        if (this.user != null && Arrays.equals(user, this.user)) {
            this.passwordHash = passwordHash;
            if (this.authMode != AuthMode.INTERNAL) {
                this.password = password;
            }
        }
    }

    public final ExecutorService getThreadPool() {
        return this.threadPool;
    }

    public final byte[] getUser() {
        return this.user;
    }

    public final byte[] getPassword() {
        return this.password;
    }

    public final byte[] getPasswordHash() {
        return this.passwordHash;
    }

    @Override
    public void close() {
        if (!this.sharedThreadPool) {
            this.threadPool.shutdown();
        }
        this.tendValid = false;
        this.tendThread.interrupt();
        if (this.eventLoops == null) {
            Node[] nodeArray;
            for (Node node : nodeArray = this.nodes) {
                node.closeSyncConnections();
            }
        } else {
            final AtomicInteger eventLoopCount = new AtomicInteger(this.eventState.length);
            boolean inEventLoop = false;
            for (final EventState state : this.eventState) {
                if (state.eventLoop.inEventLoop()) {
                    inEventLoop = true;
                }
                state.eventLoop.execute(new Runnable(){

                    @Override
                    public void run() {
                        if (state.pending < 0) {
                            return;
                        }
                        if (state.pending > 0) {
                            state.eventLoop.schedule(this, 200L, TimeUnit.MILLISECONDS);
                            return;
                        }
                        Cluster.this.closeEventLoop(eventLoopCount, state);
                    }
                });
            }
            if (!inEventLoop) {
                this.waitAsyncComplete();
            }
        }
    }

    private final void closeEventLoop(AtomicInteger eventLoopCount, EventState state) {
        Node[] nodeArray;
        state.pending = -1;
        for (Node node : nodeArray = this.nodes) {
            node.closeAsyncConnections(state.index);
        }
        if (eventLoopCount.decrementAndGet() == 0) {
            for (Node node : nodeArray) {
                node.closeSyncConnections();
            }
            this.notifyAsyncComplete();
        }
    }

    private synchronized void waitAsyncComplete() {
        while (!this.asyncComplete) {
            try {
                super.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private synchronized void notifyAsyncComplete() {
        this.asyncComplete = true;
        super.notify();
    }
}

