/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.cluster;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.Host;
import com.aerospike.client.Info;
import com.aerospike.client.Log;
import com.aerospike.client.admin.AdminCommand;
import com.aerospike.client.async.AsyncConnection;
import com.aerospike.client.async.EventState;
import com.aerospike.client.cluster.Cluster;
import com.aerospike.client.cluster.Connection;
import com.aerospike.client.cluster.ConnectionStats;
import com.aerospike.client.cluster.NodeValidator;
import com.aerospike.client.cluster.PartitionParser;
import com.aerospike.client.cluster.Peer;
import com.aerospike.client.cluster.PeerParser;
import com.aerospike.client.cluster.Peers;
import com.aerospike.client.cluster.Pool;
import com.aerospike.client.policy.BatchPolicy;
import com.aerospike.client.util.ThreadLocalData;
import com.aerospike.client.util.Util;
import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

public class Node
implements Closeable {
    public static final int PARTITIONS = 4096;
    public static final int HAS_GEO = 1;
    public static final int HAS_DOUBLE = 2;
    public static final int HAS_BATCH_INDEX = 4;
    public static final int HAS_REPLICAS_ALL = 8;
    public static final int HAS_PEERS = 16;
    public static final int HAS_REPLICAS = 32;
    public static final int HAS_CLUSTER_STABLE = 64;
    protected final Cluster cluster;
    private final String name;
    private final Host host;
    protected final List<Host> aliases;
    protected final InetSocketAddress address;
    private final Pool[] connectionPools;
    private final AsyncPool[] asyncConnectionPools;
    private Connection tendConnection;
    private byte[] sessionToken;
    private long sessionExpiration;
    protected int connectionIter;
    protected int peersGeneration;
    protected int partitionGeneration;
    protected int peersCount;
    protected int referenceCount;
    protected int failures;
    private final int features;
    protected boolean partitionChanged;
    protected volatile boolean performLogin;
    protected volatile boolean active;

    public Node(Cluster cluster, NodeValidator nv) {
        int capacity;
        int i;
        this.cluster = cluster;
        this.name = nv.name;
        this.aliases = nv.aliases;
        this.host = nv.primaryHost;
        this.address = nv.primaryAddress;
        this.tendConnection = nv.primaryConn;
        this.sessionToken = nv.sessionToken;
        this.sessionExpiration = nv.sessionExpiration;
        this.features = nv.features;
        this.connectionPools = new Pool[cluster.connPoolsPerNode];
        int max = cluster.connectionQueueSize / cluster.connPoolsPerNode;
        int rem = cluster.connectionQueueSize - max * cluster.connPoolsPerNode;
        for (i = 0; i < this.connectionPools.length; ++i) {
            capacity = i < rem ? max + 1 : max;
            this.connectionPools[i] = new Pool(capacity);
        }
        if (cluster.eventState != null) {
            this.asyncConnectionPools = new AsyncPool[cluster.eventState.length];
            max = cluster.connectionQueueSize / this.asyncConnectionPools.length;
            rem = cluster.connectionQueueSize - max * this.asyncConnectionPools.length;
            for (i = 0; i < cluster.eventState.length; ++i) {
                capacity = i < rem ? max + 1 : max;
                this.asyncConnectionPools[i] = new AsyncPool(capacity);
            }
        } else {
            this.asyncConnectionPools = null;
        }
        this.peersGeneration = -1;
        this.partitionGeneration = -1;
        this.active = true;
    }

    /*
     * Unable to fully structure code
     */
    public final void refresh(Peers peers) {
        if (!this.active) {
            return;
        }
        try {
            if (this.tendConnection.isClosed()) {
                v0 = this.tendConnection = this.cluster.tlsPolicy != null && this.cluster.tlsPolicy.forLoginOnly == false ? new Connection(this.cluster.tlsPolicy, this.host.tlsName, this.address, this.cluster.connectionTimeout, this.cluster.maxSocketIdleNanos, null) : new Connection(this.address, this.cluster.connectionTimeout, this.cluster.maxSocketIdleNanos, null);
                if (this.cluster.user != null) {
                    try {
                        if (this.ensureLogin() || (command = new AdminCommand(ThreadLocalData.getBuffer())).authenticate(this.cluster, this.tendConnection, this.sessionToken)) ** GOTO lbl23
                        login = new AdminCommand.LoginCommand(this.cluster, this.tendConnection);
                        this.sessionToken = login.sessionToken;
                        this.sessionExpiration = login.sessionExpiration;
                    }
                    catch (AerospikeException ae) {
                        this.tendConnection.close();
                        throw ae;
                    }
                    catch (Exception e) {
                        this.tendConnection.close();
                        throw new AerospikeException(e);
                    }
                }
            } else if (this.cluster.user != null) {
                this.ensureLogin();
            }
lbl23:
            // 6 sources

            if (peers.usePeers) {
                infoMap = Info.request(this.tendConnection, new String[]{"node", "peers-generation", "partition-generation"});
                this.verifyNodeName(infoMap);
                this.verifyPeersGeneration(infoMap, peers);
                this.verifyPartitionGeneration(infoMap);
            } else {
                if (this.cluster.useServicesAlternate) {
                    v1 = new String[3];
                    v1[0] = "node";
                    v1[1] = "partition-generation";
                    v2 = v1;
                    v1[2] = "services-alternate";
                } else {
                    v3 = new String[3];
                    v3[0] = "node";
                    v3[1] = "partition-generation";
                    v2 = v3;
                    v3[2] = "services";
                }
                commands = v2;
                infoMap = Info.request(this.tendConnection, commands);
                this.verifyNodeName(infoMap);
                this.verifyPartitionGeneration(infoMap);
                this.addFriends(infoMap, peers);
            }
            ++peers.refreshCount;
            this.failures = 0;
        }
        catch (Exception e) {
            if (peers.usePeers) {
                peers.genChanged = true;
            }
            this.refreshFailed(e);
        }
    }

    private boolean ensureLogin() throws IOException {
        if (this.performLogin || this.sessionExpiration > 0L && System.nanoTime() >= this.sessionExpiration) {
            AdminCommand.LoginCommand login = new AdminCommand.LoginCommand(this.cluster, this.tendConnection);
            this.sessionToken = login.sessionToken;
            this.sessionExpiration = login.sessionExpiration;
            this.performLogin = false;
            return true;
        }
        return false;
    }

    public final void signalLogin() {
        if (!this.performLogin) {
            this.performLogin = true;
            this.cluster.interruptTendSleep();
        }
    }

    private final void verifyNodeName(HashMap<String, String> infoMap) {
        String infoName = infoMap.get("node");
        if (infoName == null || infoName.length() == 0) {
            throw new AerospikeException.Parse("Node name is empty");
        }
        if (!this.name.equals(infoName)) {
            this.active = false;
            throw new AerospikeException("Node name has changed. Old=" + this.name + " New=" + infoName);
        }
    }

    private final void verifyPeersGeneration(HashMap<String, String> infoMap, Peers peers) {
        String genString = infoMap.get("peers-generation");
        if (genString == null || genString.length() == 0) {
            throw new AerospikeException.Parse("peers-generation is empty");
        }
        int gen = Integer.parseInt(genString);
        if (this.peersGeneration != gen) {
            peers.genChanged = true;
        }
    }

    private final void verifyPartitionGeneration(HashMap<String, String> infoMap) {
        String genString = infoMap.get("partition-generation");
        if (genString == null || genString.length() == 0) {
            throw new AerospikeException.Parse("partition-generation is empty");
        }
        int gen = Integer.parseInt(genString);
        if (this.partitionGeneration != gen) {
            this.partitionChanged = true;
        }
    }

    private final void addFriends(HashMap<String, String> infoMap, Peers peers) throws AerospikeException {
        String command = this.cluster.useServicesAlternate ? "services-alternate" : "services";
        String friendString = infoMap.get(command);
        if (friendString == null || friendString.length() == 0) {
            this.peersCount = 0;
            return;
        }
        String[] friendNames = friendString.split(";");
        this.peersCount = friendNames.length;
        for (String friend : friendNames) {
            int port;
            Host host;
            Node node;
            String alternativeHost;
            String[] friendInfo = friend.split(":");
            String hostname = friendInfo[0];
            if (this.cluster.ipMap != null && (alternativeHost = this.cluster.ipMap.get(hostname)) != null) {
                hostname = alternativeHost;
            }
            if ((node = this.cluster.aliases.get(host = new Host(hostname, port = Integer.parseInt(friendInfo[1])))) == null) {
                if (peers.hosts.contains(host)) continue;
                this.prepareFriend(host, peers);
                continue;
            }
            ++node.referenceCount;
        }
    }

    private final boolean prepareFriend(Host host, Peers peers) {
        try {
            NodeValidator nv = new NodeValidator();
            nv.validateNode(this.cluster, host);
            Node node = peers.nodes.get(nv.name);
            if (node != null) {
                nv.primaryConn.close();
                peers.hosts.add(host);
                node.aliases.add(host);
                return true;
            }
            node = this.cluster.nodesMap.get(nv.name);
            if (node != null) {
                nv.primaryConn.close();
                peers.hosts.add(host);
                node.aliases.add(host);
                ++node.referenceCount;
                this.cluster.aliases.put(host, node);
                return true;
            }
            node = this.cluster.createNode(nv);
            peers.hosts.add(host);
            peers.nodes.put(nv.name, node);
            return true;
        }
        catch (Exception e) {
            if (Log.warnEnabled()) {
                Log.warn("Add node " + host + " failed: " + Util.getErrorMessage(e));
            }
            return false;
        }
    }

    protected final void refreshPeers(Peers peers) {
        if (this.failures > 0 || !this.active) {
            return;
        }
        try {
            if (Log.debugEnabled()) {
                Log.debug("Update peers for node " + this);
            }
            PeerParser parser = new PeerParser(this.cluster, this.tendConnection, peers.peers);
            this.peersCount = peers.peers.size();
            boolean peersValidated = true;
            for (Peer peer : peers.peers) {
                if (Node.findPeerNode(this.cluster, peers, peer.nodeName)) continue;
                boolean nodeValidated = false;
                for (Host host : peer.hosts) {
                    try {
                        NodeValidator nv = new NodeValidator();
                        nv.validateNode(this.cluster, host);
                        if (!peer.nodeName.equals(nv.name)) {
                            if (Log.warnEnabled()) {
                                Log.warn("Peer node " + peer.nodeName + " is different than actual node " + nv.name + " for host " + host);
                            }
                            if (Node.findPeerNode(this.cluster, peers, nv.name)) {
                                nv.primaryConn.close();
                                nodeValidated = true;
                                break;
                            }
                        }
                        Node node = this.cluster.createNode(nv);
                        peers.nodes.put(nv.name, node);
                        nodeValidated = true;
                        break;
                    }
                    catch (Exception e) {
                        if (!Log.warnEnabled()) continue;
                        Log.warn("Add node " + host + " failed: " + Util.getErrorMessage(e));
                    }
                }
                if (nodeValidated) continue;
                peersValidated = false;
            }
            if (peersValidated) {
                this.peersGeneration = parser.generation;
            }
            ++peers.refreshCount;
        }
        catch (Exception e) {
            this.refreshFailed(e);
        }
    }

    private static boolean findPeerNode(Cluster cluster, Peers peers, String nodeName) {
        Node node = cluster.nodesMap.get(nodeName);
        if (node != null) {
            ++node.referenceCount;
            return true;
        }
        node = peers.nodes.get(nodeName);
        if (node != null) {
            ++node.referenceCount;
            return true;
        }
        return false;
    }

    protected final void refreshPartitions(Peers peers) {
        if (this.failures > 0 || !this.active || this.peersCount == 0 && peers.refreshCount > 1) {
            return;
        }
        try {
            PartitionParser parser;
            if (Log.debugEnabled()) {
                Log.debug("Update partition map for node " + this);
            }
            if ((parser = new PartitionParser(this.tendConnection, this, this.cluster.partitionMap, 4096, this.cluster.requestProleReplicas)).isPartitionMapCopied()) {
                this.cluster.partitionMap = parser.getPartitionMap();
            }
            this.partitionGeneration = parser.getGeneration();
        }
        catch (Exception e) {
            this.refreshFailed(e);
        }
    }

    private final void refreshFailed(Exception e) {
        ++this.failures;
        if (!this.tendConnection.isClosed()) {
            this.tendConnection.close();
        }
        if (this.cluster.tendValid && Log.warnEnabled()) {
            Log.warn("Node " + this + " refresh failed: " + Util.getErrorMessage(e));
        }
    }

    public final Connection getConnection(int timeoutMillis) throws AerospikeException {
        boolean backward;
        int initialIndex;
        int max = this.cluster.connPoolsPerNode;
        if (max == 1) {
            initialIndex = 0;
            backward = false;
        } else {
            int iter;
            if ((initialIndex = (iter = this.connectionIter++) % max) < 0) {
                initialIndex += max;
            }
            backward = true;
        }
        Pool pool = this.connectionPools[initialIndex];
        int queueIndex = initialIndex;
        while (true) {
            Connection conn;
            if ((conn = pool.queue.poll()) != null) {
                if (conn.isValid()) {
                    try {
                        conn.setTimeout(timeoutMillis);
                        return conn;
                    }
                    catch (Exception e) {
                        this.closeConnection(conn);
                        throw new AerospikeException.Connection(e);
                    }
                }
                this.closeConnection(conn);
                continue;
            }
            if (pool.total.getAndIncrement() < pool.capacity) {
                try {
                    conn = this.cluster.tlsPolicy != null && !this.cluster.tlsPolicy.forLoginOnly ? new Connection(this.cluster.tlsPolicy, this.host.tlsName, this.address, timeoutMillis, this.cluster.maxSocketIdleNanos, pool) : new Connection(this.address, timeoutMillis, this.cluster.maxSocketIdleNanos, pool);
                }
                catch (RuntimeException re) {
                    pool.total.getAndDecrement();
                    throw re;
                }
                if (this.cluster.user != null) {
                    try {
                        AdminCommand command = new AdminCommand(ThreadLocalData.getBuffer());
                        if (!command.authenticate(this.cluster, conn, this.sessionToken)) {
                            this.signalLogin();
                            throw new AerospikeException("Authentication failed");
                        }
                    }
                    catch (AerospikeException ae) {
                        this.closeConnection(conn);
                        throw ae;
                    }
                    catch (Exception e) {
                        this.closeConnection(conn);
                        throw new AerospikeException(e);
                    }
                }
                return conn;
            }
            pool.total.getAndDecrement();
            if (backward) {
                if (queueIndex > 0) {
                    --queueIndex;
                } else {
                    queueIndex = initialIndex;
                    if (++queueIndex >= max) break;
                    backward = false;
                }
            } else if (++queueIndex >= max) break;
            pool = this.connectionPools[queueIndex];
        }
        throw new AerospikeException.Connection(-7, "Node " + this + " max connections " + this.cluster.connectionQueueSize + " would be exceeded.");
    }

    public final void putConnection(Connection conn) {
        conn.updateLastUsed();
        if (!this.active || !conn.pool.queue.offer(conn)) {
            this.closeConnection(conn);
        }
    }

    public final void closeConnection(Connection conn) {
        conn.pool.total.getAndDecrement();
        conn.close();
    }

    public final ConnectionStats getConnectionStats() {
        int inPool = 0;
        int inUse = 0;
        for (Pool pool : this.connectionPools) {
            int tmp = pool.queue.size();
            inPool += tmp;
            tmp = pool.total.get() - tmp;
            if (tmp < 0) {
                tmp = 0;
            }
            inUse += tmp;
        }
        return new ConnectionStats(inPool, inUse);
    }

    public final AsyncConnection getAsyncConnection(int index2, ByteBuffer byteBuffer) {
        AsyncConnection conn;
        AsyncPool pool = this.asyncConnectionPools[index2];
        ArrayDeque<AsyncConnection> queue = pool.queue;
        while ((conn = queue.pollFirst()) != null) {
            if (conn.isValid(byteBuffer)) {
                return conn;
            }
            this.closeAsyncConnection(conn, index2);
        }
        if (pool.total >= pool.capacity) {
            throw new AerospikeException.Connection(-7, "Node " + this + " event loop " + index2 + " max connections " + pool.capacity + " would be exceeded.");
        }
        ++pool.total;
        return null;
    }

    public final void putAsyncConnection(AsyncConnection conn, int index2) {
        this.asyncConnectionPools[index2].queue.addLast(conn);
    }

    public final void closeAsyncConnection(AsyncConnection conn, int index2) {
        --this.asyncConnectionPools[index2].total;
        conn.close();
    }

    public final void decrAsyncConnection(int index2) {
        --this.asyncConnectionPools[index2].total;
    }

    public final ConnectionStats getAsyncConnectionStats() {
        int inPool = 0;
        int inUse = 0;
        if (this.asyncConnectionPools != null) {
            for (AsyncPool pool : this.asyncConnectionPools) {
                int tmp = pool.queue.size();
                if (tmp < 0) {
                    tmp = 0;
                }
                inPool += tmp;
                if ((tmp = pool.total - tmp) < 0) {
                    tmp = 0;
                }
                inUse += tmp;
            }
        }
        return new ConnectionStats(inPool, inUse);
    }

    public final Host getHost() {
        return this.host;
    }

    public final boolean isActive() {
        return this.active;
    }

    public final String getName() {
        return this.name;
    }

    public final InetSocketAddress getAddress() {
        return this.address;
    }

    public final byte[] getSessionToken() {
        return this.sessionToken;
    }

    public final boolean useNewBatch(BatchPolicy policy) {
        return !policy.useBatchDirect && this.hasBatchIndex();
    }

    public final boolean hasBatchIndex() {
        return (this.features & 4) != 0;
    }

    public final boolean hasClusterStable() {
        return (this.features & 0x40) != 0;
    }

    public final boolean hasDouble() {
        return (this.features & 2) != 0;
    }

    public final boolean hasReplicas() {
        return (this.features & 0x20) != 0;
    }

    public final boolean hasReplicasAll() {
        return (this.features & 8) != 0;
    }

    public final boolean hasPeers() {
        return (this.features & 0x10) != 0;
    }

    public final String toString() {
        return this.name + ' ' + this.host;
    }

    public final int hashCode() {
        return this.name.hashCode();
    }

    public final boolean equals(Object obj) {
        Node other = (Node)obj;
        return this.name.equals(other.name);
    }

    @Override
    public final void close() {
        if (this.cluster.eventLoops == null) {
            this.closeSyncConnections();
        } else {
            final AtomicInteger eventLoopCount = new AtomicInteger(this.cluster.eventState.length);
            for (final EventState state : this.cluster.eventState) {
                state.eventLoop.execute(new Runnable(){

                    @Override
                    public void run() {
                        Node.this.closeConnections(eventLoopCount, state.index);
                    }
                });
            }
        }
    }

    public final void closeConnections(AtomicInteger eventLoopCount, int index2) {
        this.closeAsyncConnections(index2);
        if (eventLoopCount.decrementAndGet() == 0) {
            this.closeSyncConnections();
        }
    }

    public final void closeAsyncConnections(int index2) {
        AsyncConnection conn;
        AsyncPool pool = this.asyncConnectionPools[index2];
        while ((conn = pool.queue.poll()) != null) {
            conn.close();
        }
    }

    public final void closeSyncConnections() {
        this.active = false;
        Connection conn = this.tendConnection;
        conn.close();
        for (Pool pool : this.connectionPools) {
            while ((conn = pool.queue.poll()) != null) {
                conn.close();
            }
        }
    }

    private static final class AsyncPool {
        public final ArrayDeque<AsyncConnection> queue;
        public final int capacity;
        public int total;

        private AsyncPool(int capacity) {
            this.capacity = capacity;
            this.queue = new ArrayDeque(capacity);
        }
    }
}

