/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.command;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.cluster.Cluster;
import com.aerospike.client.cluster.Node;
import com.aerospike.client.command.MultiCommand;
import com.aerospike.client.policy.Policy;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

public final class Executor {
    private final Cluster cluster;
    private final Policy policy;
    private final List<ExecutorThread> threads;
    private final ExecutorService threadPool;
    private volatile Exception exception;
    private final AtomicBoolean done;
    private final AtomicInteger completedCount;
    private int maxConcurrentThreads;
    private boolean completed;

    public Executor(Cluster cluster, Policy policy, int capacity) {
        this.cluster = cluster;
        this.policy = policy;
        this.threads = new ArrayList<ExecutorThread>(capacity);
        this.threadPool = cluster.getThreadPool();
        this.done = new AtomicBoolean();
        this.completedCount = new AtomicInteger();
    }

    public void addCommand(Node node, MultiCommand command) {
        this.threads.add(new ExecutorThread(node, command));
    }

    public void execute(int maxConcurrent) throws AerospikeException {
        this.maxConcurrentThreads = maxConcurrent == 0 || maxConcurrent >= this.threads.size() ? this.threads.size() : maxConcurrent;
        for (int i = 0; i < this.maxConcurrentThreads; ++i) {
            this.threadPool.execute(this.threads.get(i));
        }
        this.waitTillComplete();
        if (this.exception != null) {
            if (this.exception instanceof AerospikeException) {
                throw (AerospikeException)this.exception;
            }
            throw new AerospikeException(this.exception);
        }
    }

    private void threadCompleted() {
        int finished = this.completedCount.incrementAndGet();
        if (finished < this.threads.size()) {
            int nextThread = finished + this.maxConcurrentThreads - 1;
            if (nextThread < this.threads.size() && !this.done.get()) {
                this.threadPool.execute(this.threads.get(nextThread));
            }
        } else if (this.done.compareAndSet(false, true)) {
            this.notifyCompleted();
        }
    }

    private void stopThreads(Exception cause) {
        if (this.done.compareAndSet(false, true)) {
            this.exception = cause;
            for (ExecutorThread thread : this.threads) {
                thread.stop();
            }
            this.notifyCompleted();
        }
    }

    private synchronized void waitTillComplete() {
        while (!this.completed) {
            try {
                super.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private synchronized void notifyCompleted() {
        this.completed = true;
        super.notify();
    }

    private final class ExecutorThread
    implements Runnable {
        private final Node node;
        private final MultiCommand command;

        public ExecutorThread(Node node, MultiCommand command) {
            this.node = node;
            this.command = command;
        }

        @Override
        public void run() {
            try {
                if (this.command.isValid()) {
                    this.command.execute(Executor.this.cluster, Executor.this.policy, this.node);
                }
                Executor.this.threadCompleted();
            }
            catch (Exception e) {
                Executor.this.stopThreads(e);
            }
        }

        public void stop() {
            this.command.stop();
        }
    }
}

