/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.command;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.Key;
import com.aerospike.client.Operation;
import com.aerospike.client.command.OperateArgs;
import com.aerospike.client.command.ReadCommand;
import com.aerospike.client.policy.WritePolicy;
import java.util.ArrayList;
import java.util.Map;

public final class OperateCommand
extends ReadCommand {
    private final Operation[] operations;
    private WritePolicy writePolicy;
    private OperateArgs args;

    public OperateCommand(Key key, Operation[] operations) {
        super(key);
        this.operations = operations;
    }

    public void setArgs(WritePolicy writePolicy, OperateArgs args) {
        this.writePolicy = writePolicy;
        this.args = args;
    }

    @Override
    protected void writeBuffer() {
        this.setOperate(this.writePolicy, this.key, this.operations, this.args);
    }

    @Override
    protected void handleNotFound(int resultCode) {
        if (this.args.hasWrite) {
            throw new AerospikeException(resultCode);
        }
    }

    @Override
    protected void addBin(Map<String, Object> bins, String name, Object value) {
        if (bins.containsKey(name)) {
            Object prev = bins.get(name);
            if (prev instanceof OpResults) {
                OpResults list = (OpResults)prev;
                list.add(value);
            } else {
                OpResults list = new OpResults();
                list.add(prev);
                list.add(value);
                bins.put(name, list);
            }
        } else {
            bins.put(name, value);
        }
    }

    private static class OpResults
    extends ArrayList<Object> {
        private static final long serialVersionUID = 1L;

        private OpResults() {
        }
    }
}

