/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.command;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.Key;
import com.aerospike.client.cluster.Cluster;
import com.aerospike.client.cluster.Connection;
import com.aerospike.client.cluster.Node;
import com.aerospike.client.cluster.Partition;
import com.aerospike.client.command.Buffer;
import com.aerospike.client.command.Command;
import com.aerospike.client.policy.Policy;
import com.aerospike.client.util.ThreadLocalData;
import com.aerospike.client.util.Util;
import java.io.IOException;
import java.net.SocketTimeoutException;
import java.util.concurrent.TimeUnit;

public abstract class SyncCommand
extends Command {
    public final void execute(Cluster cluster, Policy policy, Key key, Node node, boolean isRead) {
        boolean isClientTimeout;
        Partition partition = key != null ? new Partition(key) : null;
        AerospikeException exception = null;
        long deadline = 0L;
        int socketTimeout = policy.socketTimeout;
        int totalTimeout = policy.totalTimeout;
        int iteration = 0;
        int commandSentCounter = 0;
        if (totalTimeout > 0) {
            deadline = System.nanoTime() + TimeUnit.MILLISECONDS.toNanos(totalTimeout);
            if (socketTimeout == 0 || socketTimeout > totalTimeout) {
                socketTimeout = totalTimeout;
            }
        }
        while (true) {
            block20: {
                try {
                    if (partition != null) {
                        node = this.getNode(cluster, partition, policy.replica, isRead);
                    }
                    Connection conn = node.getConnection(socketTimeout);
                    try {
                        this.writeBuffer();
                        if (totalTimeout != policy.totalTimeout) {
                            Buffer.intToBytes(totalTimeout, this.dataBuffer, 22);
                        }
                        conn.write(this.dataBuffer, this.dataOffset);
                        ++commandSentCounter;
                        this.parseResult(conn);
                        node.putConnection(conn);
                        return;
                    }
                    catch (AerospikeException ae) {
                        if (ae.keepConnection()) {
                            node.putConnection(conn);
                        } else {
                            node.closeConnection(conn);
                        }
                        if (ae.getResultCode() == 9) {
                            exception = new AerospikeException.Timeout(policy, false);
                            isClientTimeout = false;
                            if (isRead) {
                                ++this.sequence;
                            }
                            break block20;
                        }
                        ae.setNode(node);
                        ae.setIteration(iteration + 1);
                        ae.setInDoubt(isRead, commandSentCounter);
                        throw ae;
                    }
                    catch (RuntimeException re) {
                        node.closeConnection(conn);
                        throw re;
                    }
                    catch (SocketTimeoutException ste) {
                        node.closeConnection(conn);
                        isClientTimeout = true;
                        if (isRead) {
                            ++this.sequence;
                        }
                    }
                    catch (IOException ioe) {
                        node.closeConnection(conn);
                        exception = new AerospikeException(ioe);
                        isClientTimeout = false;
                        ++this.sequence;
                    }
                }
                catch (AerospikeException.Connection ce) {
                    exception = ce;
                    isClientTimeout = false;
                    ++this.sequence;
                }
            }
            if (++iteration > policy.maxRetries) break;
            if (policy.totalTimeout > 0) {
                long remaining = deadline - System.nanoTime() - TimeUnit.MILLISECONDS.toNanos(policy.sleepBetweenRetries);
                if (remaining <= 0L) break;
                if ((remaining = TimeUnit.NANOSECONDS.toMillis(remaining)) < (long)totalTimeout && socketTimeout > (totalTimeout = (int)remaining)) {
                    socketTimeout = totalTimeout;
                }
            }
            if (isClientTimeout || policy.sleepBetweenRetries <= 0) continue;
            Util.sleep(policy.sleepBetweenRetries);
        }
        if (isClientTimeout) {
            exception = new AerospikeException.Timeout(policy, true);
        }
        exception.setNode(node);
        exception.setIteration(iteration);
        exception.setInDoubt(isRead, commandSentCounter);
        throw exception;
    }

    @Override
    protected final void sizeBuffer() {
        this.dataBuffer = ThreadLocalData.getBuffer();
        if (this.dataOffset > this.dataBuffer.length) {
            this.dataBuffer = ThreadLocalData.resizeBuffer(this.dataOffset);
        }
    }

    protected final void sizeBuffer(int size) {
        if (size > this.dataBuffer.length) {
            this.dataBuffer = ThreadLocalData.resizeBuffer(size);
        }
    }

    protected final void emptySocket(Connection conn) throws IOException {
        byte headerLength;
        long sz = Buffer.bytesToLong(this.dataBuffer, 0);
        int receiveSize = (int)(sz & 0xFFFFFFFFFFFFL) - (headerLength = this.dataBuffer[8]);
        if (receiveSize > 0) {
            this.sizeBuffer(receiveSize);
            conn.readFully(this.dataBuffer, receiveSize);
        }
    }

    protected abstract void writeBuffer();

    protected abstract void parseResult(Connection var1) throws AerospikeException, IOException;
}

