/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.async;

import com.aerospike.client.async.AsyncConnection;
import io.netty.channel.socket.SocketChannel;
import java.nio.ByteBuffer;

public final class NettyConnection
implements AsyncConnection {
    final SocketChannel channel;
    private final long maxSocketIdle;
    private long lastUsed;

    public NettyConnection(SocketChannel channel, long maxSocketIdle) {
        this.channel = channel;
        this.maxSocketIdle = maxSocketIdle;
    }

    @Override
    public boolean isValid(ByteBuffer notUsed) {
        return System.nanoTime() - this.lastUsed <= this.maxSocketIdle && this.channel.isActive();
    }

    @Override
    public boolean isCurrent() {
        return System.nanoTime() - this.lastUsed <= this.maxSocketIdle;
    }

    void updateLastUsed() {
        this.lastUsed = System.nanoTime();
    }

    @Override
    public void close() {
        this.channel.close();
    }
}

