/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.async;

import com.aerospike.client.Log;
import com.aerospike.client.async.AsyncCommand;
import com.aerospike.client.async.AsyncConnector;
import com.aerospike.client.async.EventLoopBase;
import com.aerospike.client.async.EventPolicy;
import com.aerospike.client.async.NettyCommand;
import com.aerospike.client.async.NettyConnector;
import com.aerospike.client.async.NettyEventLoops;
import com.aerospike.client.async.ScheduleTask;
import com.aerospike.client.cluster.Cluster;
import com.aerospike.client.cluster.Node;
import com.aerospike.client.util.Util;
import io.netty.channel.EventLoop;
import java.util.concurrent.TimeUnit;

public final class NettyEventLoop
extends EventLoopBase {
    final EventLoop eventLoop;
    final NettyEventLoops parent;

    public NettyEventLoop(EventPolicy policy, EventLoop eventLoop, NettyEventLoops parent, int index2) {
        super(policy, index2);
        this.eventLoop = eventLoop;
        this.parent = parent;
    }

    public EventLoop get() {
        return this.eventLoop;
    }

    @Override
    public void execute(Cluster cluster, AsyncCommand command) {
        new NettyCommand(this, cluster, command);
    }

    @Override
    public void execute(Runnable command) {
        this.eventLoop.execute(command);
    }

    @Override
    public void executeBatchRetry(Runnable other, AsyncCommand command, long deadline) {
        new NettyCommand((NettyCommand)other, command, deadline);
    }

    @Override
    public void schedule(Runnable command, long delay, TimeUnit unit) {
        this.eventLoop.schedule(command, delay, unit);
    }

    @Override
    public void schedule(ScheduleTask task, long delay, TimeUnit unit) {
        this.eventLoop.schedule((Runnable)task, delay, unit);
    }

    @Override
    public AsyncConnector createConnector(Cluster cluster, Node node, AsyncConnector.Listener listener) {
        return new NettyConnector(this, cluster, node, listener);
    }

    @Override
    public boolean inEventLoop() {
        return this.eventLoop.inEventLoop();
    }

    final void tryDelayQueue() {
        if (this.maxCommandsInProcess > 0 && !this.usingDelayQueue) {
            this.executeFromDelayQueue();
        }
    }

    final void executeFromDelayQueue() {
        this.usingDelayQueue = true;
        try {
            NettyCommand cmd;
            while (this.pending < this.maxCommandsInProcess && (cmd = (NettyCommand)this.delayQueue.pollFirst()) != null) {
                if (cmd.state == 10) continue;
                cmd.executeCommandFromDelayQueue();
            }
        }
        catch (Exception e) {
            Log.error("Unexpected async error: " + Util.getErrorMessage(e));
        }
        finally {
            this.usingDelayQueue = false;
        }
    }
}

