/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.async;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.async.AsyncCommand;
import com.aerospike.client.async.EventState;
import com.aerospike.client.async.HashedWheelTimer;
import com.aerospike.client.async.NettyCommand;
import com.aerospike.client.async.NettyConnection;
import com.aerospike.client.async.NettyEventLoop;
import com.aerospike.client.async.TimerTask;
import com.aerospike.client.cluster.Node;
import com.aerospike.client.command.Buffer;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelPipeline;
import java.util.concurrent.TimeUnit;

public final class NettyRecover
implements TimerTask {
    private final NettyEventLoop eventLoop;
    private final Node node;
    private final EventState eventState;
    private final NettyConnection conn;
    private final HashedWheelTimer.HashedWheelTimeout timeoutTask;
    private final byte[] dataBuffer;
    private int offset;
    private int length;
    private int state;
    private final boolean isSingle;
    private final boolean checkReturnCode;
    private boolean isLastGroup;

    public NettyRecover(NettyCommand cmd) {
        AsyncCommand a = cmd.command;
        this.eventLoop = cmd.eventLoop;
        this.node = cmd.node;
        this.eventState = cmd.eventState;
        this.conn = cmd.conn;
        this.dataBuffer = a.dataBuffer;
        this.offset = a.dataOffset;
        this.length = a.receiveSize;
        if (cmd.state == 5) {
            this.state = 8;
            this.isSingle = true;
            this.checkReturnCode = true;
        } else if (cmd.state == 6) {
            this.state = 9;
            this.isSingle = true;
            this.checkReturnCode = true;
            if (this.offset >= 2 && this.dataBuffer[1] != 0) {
                this.timeoutTask = null;
                this.abort(false);
                return;
            }
        } else {
            this.state = cmd.state;
            this.isSingle = a.isSingle;
            this.checkReturnCode = false;
        }
        ++this.eventState.pending;
        ++this.eventLoop.pending;
        ChannelPipeline p = this.conn.channel.pipeline();
        p.removeLast();
        p.addLast(new ChannelHandler[]{new InboundHandler(this)});
        this.timeoutTask = this.eventLoop.timer.addTimeout(this, System.nanoTime() + TimeUnit.MILLISECONDS.toNanos(a.policy.timeoutDelay));
    }

    @Override
    public final void timeout() {
        if (this.state == 10) {
            return;
        }
        this.abort(false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void drain(ByteBuf byteBuffer) {
        try {
            switch (this.state) {
                case 8: {
                    if (this.isSingle) {
                        this.drainSingleHeader(byteBuffer);
                        return;
                    }
                    this.drainMultiHeader(byteBuffer);
                    return;
                }
                case 9: {
                    if (this.isSingle) {
                        this.drainSingleBody(byteBuffer);
                        return;
                    }
                    if (!this.drainMultiBody(byteBuffer)) {
                        return;
                    }
                    this.drainMultiHeader(byteBuffer);
                    return;
                }
            }
            return;
        }
        finally {
            byteBuffer.release();
        }
    }

    private final void drainSingleHeader(ByteBuf byteBuffer) {
        int readableBytes = byteBuffer.readableBytes();
        int dataSize = this.offset + readableBytes;
        if (dataSize < 8) {
            byteBuffer.readBytes(this.dataBuffer, this.offset, readableBytes);
            this.offset = dataSize;
            return;
        }
        dataSize = 8 - this.offset;
        byteBuffer.readBytes(this.dataBuffer, this.offset, dataSize);
        readableBytes -= dataSize;
        this.length = (int)(Buffer.bytesToLong(this.dataBuffer, 0) & 0xFFFFFFFFFFFFL);
        this.state = 9;
        this.offset = 0;
        this.drainSingleBody(byteBuffer);
    }

    private final void drainSingleBody(ByteBuf byteBuffer) {
        int readableBytes = byteBuffer.readableBytes();
        if (this.checkReturnCode && this.offset < 2 && this.offset + readableBytes >= 2) {
            int len = 2 - this.offset;
            byteBuffer.readBytes(this.dataBuffer, 0, len);
            readableBytes -= len;
            this.offset += len;
            byte resultCode = this.dataBuffer[len - 1];
            if (resultCode != 0) {
                this.abort(false);
                return;
            }
            if (readableBytes <= 0) {
                return;
            }
        }
        byteBuffer.skipBytes(readableBytes);
        this.offset += readableBytes;
        if (this.offset >= this.length) {
            this.recover();
        }
    }

    private final void drainMultiHeader(ByteBuf byteBuffer) {
        int readableBytes = byteBuffer.readableBytes();
        while (true) {
            boolean compressed;
            int dataSize;
            if ((dataSize = this.offset + readableBytes) < 8) {
                byteBuffer.readBytes(this.dataBuffer, this.offset, readableBytes);
                this.offset = dataSize;
                return;
            }
            dataSize = 8 - this.offset;
            byteBuffer.readBytes(this.dataBuffer, this.offset, dataSize);
            readableBytes -= dataSize;
            long proto = Buffer.bytesToLong(this.dataBuffer, 0);
            this.length = (int)(proto & 0xFFFFFFFFFFFFL);
            if (this.length == 0) {
                this.offset = 0;
                continue;
            }
            boolean bl = compressed = (proto >> 48 & 0xFFL) == 4L;
            if (compressed) {
                throw new AerospikeException("Recovering connections with compressed multi-record data is not supported");
            }
            this.state = 9;
            this.offset = 0;
            if (readableBytes <= 0) {
                return;
            }
            if (!this.drainMultiBody(byteBuffer)) {
                return;
            }
            readableBytes = byteBuffer.readableBytes();
        }
    }

    private final boolean drainMultiBody(ByteBuf byteBuffer) {
        int needBytes;
        int readableBytes = byteBuffer.readableBytes();
        if (this.offset < 4 && this.offset + readableBytes >= 4) {
            int len = 4 - this.offset;
            byteBuffer.readBytes(this.dataBuffer, 0, len);
            readableBytes -= len;
            this.offset += len;
            byte info3 = this.dataBuffer[len - 1];
            if ((info3 & 1) != 0) {
                this.isLastGroup = true;
            }
            if (readableBytes <= 0) {
                return false;
            }
        }
        int dataSize = readableBytes >= (needBytes = this.length - this.offset) ? needBytes : readableBytes;
        byteBuffer.skipBytes(dataSize);
        this.offset += dataSize;
        if (this.offset < this.length) {
            return false;
        }
        if (this.isLastGroup) {
            this.recover();
            return false;
        }
        this.state = 8;
        this.offset = 0;
        return true;
    }

    private final void recover() {
        ChannelPipeline p = this.conn.channel.pipeline();
        p.removeLast();
        p.addLast(new ChannelHandler[]{new NettyCommand.InboundHandler()});
        this.conn.channel.config().setAutoRead(false);
        this.conn.updateLastUsed();
        this.node.putAsyncConnection(this.conn, this.eventLoop.index);
        this.close(true);
    }

    private final void abort(boolean cancelTimeout) {
        this.node.closeAsyncConnection(this.conn, this.eventLoop.index);
        this.close(cancelTimeout);
    }

    private final void close(boolean cancelTimeout) {
        if (cancelTimeout) {
            this.timeoutTask.cancel();
        }
        if (this.dataBuffer.length <= 131072) {
            this.eventLoop.bufferQueue.addLast(this.dataBuffer);
        }
        this.state = 10;
        --this.eventState.pending;
        --this.eventLoop.pending;
        this.eventLoop.tryDelayQueue();
    }

    private static class InboundHandler
    extends ChannelInboundHandlerAdapter {
        private final NettyRecover command;

        public InboundHandler(NettyRecover command) {
            this.command = command;
        }

        public void channelRead(ChannelHandlerContext ctx, Object msg) {
            this.command.drain((ByteBuf)msg);
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
            this.command.abort(true);
        }
    }
}

