/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.async;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.Log;
import com.aerospike.client.admin.AdminCommand;
import com.aerospike.client.async.AsyncCommand;
import com.aerospike.client.async.EventState;
import com.aerospike.client.async.HashedWheelTimer;
import com.aerospike.client.async.INioCommand;
import com.aerospike.client.async.NioConnection;
import com.aerospike.client.async.NioEventLoop;
import com.aerospike.client.async.NioRecover;
import com.aerospike.client.async.TimerTask;
import com.aerospike.client.cluster.Cluster;
import com.aerospike.client.cluster.Node;
import com.aerospike.client.command.Command;
import com.aerospike.client.util.Util;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.util.concurrent.TimeUnit;

public final class NioCommand
implements INioCommand,
Runnable,
TimerTask {
    final NioEventLoop eventLoop;
    final Cluster cluster;
    final AsyncCommand command;
    final EventState eventState;
    Node node;
    NioConnection conn;
    ByteBuffer byteBuffer;
    HashedWheelTimer.HashedWheelTimeout timeoutTask;
    long totalDeadline;
    int state;
    int iteration;
    int commandSentCounter;
    final boolean hasTotalTimeout;
    boolean usingSocketTimeout;
    boolean eventReceived;

    public NioCommand(NioEventLoop eventLoop, Cluster cluster, AsyncCommand command) {
        this.eventLoop = eventLoop;
        this.cluster = cluster;
        this.eventState = cluster.eventState[eventLoop.index];
        this.command = command;
        command.bufferQueue = eventLoop.bufferQueue;
        boolean bl = this.hasTotalTimeout = command.totalTimeout > 0;
        if (eventLoop.thread == Thread.currentThread() && this.eventState.errors < 5) {
            this.run();
        } else {
            if (this.hasTotalTimeout) {
                this.totalDeadline = System.nanoTime() + TimeUnit.MILLISECONDS.toNanos(command.totalTimeout);
            }
            this.state = 1;
            eventLoop.execute(this);
        }
    }

    public NioCommand(NioCommand other, AsyncCommand command, long deadline) {
        this.eventLoop = other.eventLoop;
        this.cluster = other.cluster;
        this.command = command;
        this.eventState = other.eventState;
        this.totalDeadline = other.totalDeadline;
        this.iteration = other.iteration;
        this.commandSentCounter = other.commandSentCounter;
        this.hasTotalTimeout = other.hasTotalTimeout;
        this.usingSocketTimeout = other.usingSocketTimeout;
        command.bufferQueue = this.eventLoop.bufferQueue;
        if (this.eventState.pending++ == -1) {
            this.eventState.pending = -1;
            ++this.eventState.errors;
            this.state = 10;
            this.notifyFailure(new AerospikeException("Cluster has been closed"));
            return;
        }
        if (deadline > 0L) {
            this.timeoutTask = this.eventLoop.timer.addTimeout(this, deadline);
        }
        if (this.eventLoop.maxCommandsInProcess > 0) {
            this.eventLoop.executeFromDelayQueue();
            if (this.eventLoop.pending >= this.eventLoop.maxCommandsInProcess) {
                if (this.eventLoop.maxCommandsInQueue > 0 && this.eventLoop.delayQueue.size() >= this.eventLoop.maxCommandsInQueue) {
                    this.queueError(new AerospikeException.AsyncQueueFull());
                    return;
                }
                this.eventLoop.delayQueue.addLast(this);
                this.state = 2;
                return;
            }
        }
        ++this.eventLoop.pending;
        this.executeCommand();
    }

    @Override
    public void run() {
        if (this.eventState.pending++ == -1) {
            this.eventState.pending = -1;
            ++this.eventState.errors;
            this.state = 10;
            this.notifyFailure(new AerospikeException("Cluster has been closed"));
            return;
        }
        long currentTime = 0L;
        if (this.hasTotalTimeout) {
            currentTime = System.nanoTime();
            if (this.state == 1) {
                if (currentTime >= this.totalDeadline) {
                    this.queueError(new AerospikeException.Timeout(this.command.policy, true));
                    return;
                }
            } else {
                this.totalDeadline = currentTime + TimeUnit.MILLISECONDS.toNanos(this.command.totalTimeout);
            }
        }
        if (this.eventLoop.maxCommandsInProcess > 0) {
            this.eventLoop.executeFromDelayQueue();
            if (this.eventLoop.pending >= this.eventLoop.maxCommandsInProcess) {
                if (this.eventLoop.maxCommandsInQueue > 0 && this.eventLoop.delayQueue.size() >= this.eventLoop.maxCommandsInQueue) {
                    this.queueError(new AerospikeException.AsyncQueueFull());
                    return;
                }
                this.eventLoop.delayQueue.addLast(this);
                if (this.hasTotalTimeout) {
                    this.timeoutTask = this.eventLoop.timer.addTimeout(this, this.totalDeadline);
                }
                this.state = 2;
                return;
            }
        }
        if (this.hasTotalTimeout) {
            long deadline;
            if (this.command.socketTimeout > 0) {
                deadline = currentTime + TimeUnit.MILLISECONDS.toNanos(this.command.socketTimeout);
                if (deadline < this.totalDeadline) {
                    this.usingSocketTimeout = true;
                } else {
                    deadline = this.totalDeadline;
                }
            } else {
                deadline = this.totalDeadline;
            }
            this.timeoutTask = this.eventLoop.timer.addTimeout(this, deadline);
        } else if (this.command.socketTimeout > 0) {
            this.usingSocketTimeout = true;
            this.timeoutTask = this.eventLoop.timer.addTimeout(this, System.nanoTime() + TimeUnit.MILLISECONDS.toNanos(this.command.socketTimeout));
        }
        ++this.eventLoop.pending;
        this.executeCommand();
    }

    private final void queueError(AerospikeException ae) {
        --this.eventState.pending;
        ++this.eventState.errors;
        this.state = 10;
        this.notifyFailure(ae);
    }

    final void executeCommandFromDelayQueue() {
        if (this.command.socketTimeout > 0) {
            long socketDeadline = System.nanoTime() + TimeUnit.MILLISECONDS.toNanos(this.command.socketTimeout);
            if (this.hasTotalTimeout) {
                if (socketDeadline < this.totalDeadline) {
                    this.timeoutTask.cancel();
                    this.usingSocketTimeout = true;
                    this.eventLoop.timer.restoreTimeout(this.timeoutTask, socketDeadline);
                }
            } else {
                this.usingSocketTimeout = true;
                this.timeoutTask = this.eventLoop.timer.addTimeout(this, socketDeadline);
            }
        }
        ++this.eventLoop.pending;
        this.executeCommand();
    }

    protected final void executeCommand() {
        this.state = 3;
        ++this.iteration;
        try {
            this.node = this.command.getNode(this.cluster);
            this.byteBuffer = this.eventLoop.getByteBuffer();
            this.conn = (NioConnection)this.node.getAsyncConnection(this.eventLoop.index, this.byteBuffer);
            if (this.conn != null) {
                this.conn.attach(this);
                this.writeCommand();
                return;
            }
            try {
                this.conn = new NioConnection(this.node.getAddress(), this.cluster.maxSocketIdleNanos);
                this.node.connectionOpened(this.eventLoop.index);
            }
            catch (Exception e) {
                this.node.decrAsyncConnection(this.eventLoop.index);
                throw e;
            }
            this.state = this.cluster.getUser() != null ? 4 : 7;
            this.conn.registerConnect(this.eventLoop, this);
            this.eventState.errors = 0;
        }
        catch (AerospikeException.Connection ac) {
            ++this.eventState.errors;
            this.onNetworkError(ac, true);
        }
        catch (IOException ioe) {
            ++this.eventState.errors;
            this.onNetworkError(new AerospikeException.Connection(ioe), true);
        }
        catch (Exception e) {
            ++this.eventState.errors;
            this.fail();
            this.notifyFailure(new AerospikeException(e));
            this.eventLoop.tryDelayQueue();
        }
    }

    @Override
    public void processEvent(SelectionKey key) {
        try {
            int ops = key.readyOps();
            if ((ops & 1) != 0) {
                this.read();
            } else if ((ops & 4) != 0) {
                this.write();
            } else if ((ops & 8) != 0) {
                this.finishConnect();
            }
        }
        catch (AerospikeException.Connection ac) {
            this.onNetworkError(ac, false);
        }
        catch (AerospikeException ae) {
            if (ae.getResultCode() == 9) {
                this.onServerTimeout();
            } else {
                this.onApplicationError(ae);
            }
        }
        catch (IOException ioe) {
            this.onNetworkError(new AerospikeException.Connection(ioe), false);
        }
        catch (Exception e) {
            this.onApplicationError(new AerospikeException(e));
        }
    }

    protected final void finishConnect() throws IOException {
        this.conn.finishConnect();
        if (this.state == 4) {
            this.writeAuth();
        } else {
            this.writeCommand();
        }
    }

    private final void writeAuth() throws IOException {
        this.command.initBuffer();
        AdminCommand admin = new AdminCommand(this.command.dataBuffer);
        this.command.dataOffset = admin.setAuthenticate(this.cluster, this.node.getSessionToken());
        this.byteBuffer.clear();
        this.byteBuffer.put(this.command.dataBuffer, 0, this.command.dataOffset);
        this.byteBuffer.flip();
        this.command.putBuffer();
        if (this.conn.write(this.byteBuffer)) {
            this.byteBuffer.clear();
            this.byteBuffer.limit(8);
            this.state = 5;
            this.eventReceived = false;
            this.conn.registerRead();
        } else {
            this.state = 4;
            this.conn.registerWrite();
        }
    }

    private final void writeCommand() throws IOException {
        this.command.writeBuffer();
        if (this.command.dataOffset > this.byteBuffer.capacity()) {
            this.byteBuffer = NioEventLoop.createByteBuffer(this.command.dataOffset);
        }
        this.byteBuffer.clear();
        this.byteBuffer.put(this.command.dataBuffer, 0, this.command.dataOffset);
        this.byteBuffer.flip();
        this.command.putBuffer();
        if (this.conn.write(this.byteBuffer)) {
            this.byteBuffer.clear();
            this.byteBuffer.limit(8);
            this.state = 8;
            ++this.commandSentCounter;
            this.eventReceived = false;
            this.conn.registerRead();
        } else {
            this.state = 7;
            this.conn.registerWrite();
        }
    }

    protected final void write() throws IOException {
        if (this.conn.write(this.byteBuffer)) {
            this.byteBuffer.clear();
            this.byteBuffer.limit(8);
            if (this.state == 7) {
                this.state = 8;
                ++this.commandSentCounter;
            } else {
                this.state = 5;
            }
            this.eventReceived = false;
            this.conn.registerRead();
        }
    }

    protected final void read() throws IOException {
        this.eventReceived = true;
        if (!this.conn.read(this.byteBuffer)) {
            return;
        }
        switch (this.state) {
            case 5: {
                this.readAuthHeader();
                if (!this.conn.read(this.byteBuffer)) {
                    return;
                }
            }
            case 6: {
                this.readAuthBody();
                this.writeCommand();
                break;
            }
            case 8: {
                if (this.command.isSingle) {
                    this.readSingleHeader();
                    break;
                }
                this.readMultiHeader();
                break;
            }
            case 9: {
                if (this.command.isSingle) {
                    this.readSingleBody();
                    break;
                }
                this.readMultiBody();
            }
        }
    }

    private final void readAuthHeader() {
        this.byteBuffer.position(0);
        this.command.receiveSize = (int)(this.byteBuffer.getLong() & 0xFFFFFFFFFFFFL);
        if (this.command.receiveSize < 2 || this.command.receiveSize > this.byteBuffer.capacity()) {
            throw new AerospikeException.Parse("Invalid auth receive size: " + this.command.receiveSize);
        }
        this.byteBuffer.clear();
        this.byteBuffer.limit(this.command.receiveSize);
        this.state = 6;
    }

    private final void readAuthBody() {
        int resultCode = this.byteBuffer.get(1) & 0xFF;
        if (resultCode != 0 && resultCode != 52) {
            this.node.signalLogin();
            throw new AerospikeException(resultCode);
        }
    }

    private final void readSingleHeader() throws IOException {
        this.byteBuffer.position(0);
        int receiveSize = this.command.parseProto(this.byteBuffer.getLong());
        if (receiveSize <= this.byteBuffer.capacity()) {
            this.byteBuffer.clear();
        } else {
            this.byteBuffer = NioEventLoop.createByteBuffer(receiveSize);
        }
        this.byteBuffer.limit(receiveSize);
        this.state = 9;
        if (this.conn.read(this.byteBuffer)) {
            this.readSingleBody();
        }
    }

    private final void readSingleBody() {
        this.command.sizeBuffer(this.command.receiveSize);
        this.byteBuffer.position(0);
        this.byteBuffer.get(this.command.dataBuffer, 0, this.command.receiveSize);
        this.conn.updateLastUsed();
        this.command.parseCommandResult();
        this.command.putBuffer();
        this.finish();
    }

    private final void readMultiHeader() throws IOException {
        if (!this.command.valid) {
            throw new AerospikeException.QueryTerminated();
        }
        if (!this.parseGroupHeader()) {
            return;
        }
        if (!this.conn.read(this.byteBuffer)) {
            return;
        }
        this.readMultiBody();
    }

    private final void readMultiBody() throws IOException {
        if (!this.command.valid) {
            throw new AerospikeException.QueryTerminated();
        }
        if (!this.parseGroupBody()) {
            return;
        }
        if (!this.conn.read(this.byteBuffer)) {
            return;
        }
        if (!this.parseGroupHeader()) {
            return;
        }
        if (this.command.receiveSize == 22) {
            if (!this.conn.read(this.byteBuffer)) {
                return;
            }
            this.parseGroupBody();
        }
    }

    private final boolean parseGroupHeader() {
        this.byteBuffer.position(0);
        int receiveSize = this.command.parseProto(this.byteBuffer.getLong());
        if (receiveSize <= 0) {
            this.byteBuffer.clear();
            this.byteBuffer.limit(8);
            this.state = 8;
            return false;
        }
        this.command.sizeBuffer(receiveSize);
        this.command.dataOffset = 0;
        this.byteBuffer.clear();
        if (receiveSize < this.byteBuffer.capacity()) {
            this.byteBuffer.limit(receiveSize);
        }
        this.state = 9;
        return true;
    }

    private final boolean parseGroupBody() throws IOException {
        do {
            this.byteBuffer.position(0);
            this.byteBuffer.get(this.command.dataBuffer, this.command.dataOffset, this.byteBuffer.limit());
            this.command.dataOffset += this.byteBuffer.limit();
            this.byteBuffer.clear();
            if (this.command.dataOffset >= this.command.receiveSize) {
                this.conn.updateLastUsed();
                if (this.command.parseCommandResult()) {
                    this.finish();
                    return false;
                }
                this.byteBuffer.limit(8);
                this.command.dataOffset = 0;
                this.state = 8;
                return true;
            }
            int remaining = this.command.receiveSize - this.command.dataOffset;
            if (remaining >= this.byteBuffer.capacity()) continue;
            this.byteBuffer.limit(remaining);
        } while (this.conn.read(this.byteBuffer));
        return false;
    }

    @Override
    public final void timeout() {
        if (this.state == 10) {
            return;
        }
        long currentTime = 0L;
        if (this.hasTotalTimeout) {
            currentTime = System.nanoTime();
            if (currentTime >= this.totalDeadline) {
                this.totalTimeout();
                return;
            }
            if (this.usingSocketTimeout && this.eventReceived) {
                this.eventReceived = false;
                long deadline = currentTime + TimeUnit.MILLISECONDS.toNanos(this.command.socketTimeout);
                if (deadline >= this.totalDeadline) {
                    deadline = this.totalDeadline;
                    this.usingSocketTimeout = false;
                }
                this.eventLoop.timer.restoreTimeout(this.timeoutTask, deadline);
                return;
            }
        } else if (this.eventReceived) {
            this.eventReceived = false;
            long socketDeadline = System.nanoTime() + TimeUnit.MILLISECONDS.toNanos(this.command.socketTimeout);
            this.eventLoop.timer.restoreTimeout(this.timeoutTask, socketDeadline);
            return;
        }
        if (this.iteration > this.command.maxRetries) {
            this.totalTimeout();
            return;
        }
        this.recoverConnection();
        long timeout = TimeUnit.MILLISECONDS.toNanos(this.command.socketTimeout);
        if (this.hasTotalTimeout) {
            long remaining = this.totalDeadline - currentTime;
            if (remaining <= timeout) {
                timeout = remaining;
                this.usingSocketTimeout = false;
            }
        } else {
            currentTime = System.nanoTime();
        }
        long deadline = currentTime + timeout;
        if (!this.command.prepareRetry(true) && this.command.retryBatch(this, deadline)) {
            this.timeoutTask = null;
            this.close();
            return;
        }
        this.eventLoop.timer.restoreTimeout(this.timeoutTask, deadline);
        this.executeCommand();
    }

    private final void totalTimeout() {
        AerospikeException.Timeout ae = new AerospikeException.Timeout(this.command.policy, true);
        if (this.state == 2) {
            this.closeFromDelayQueue();
            this.notifyFailure(ae);
            return;
        }
        this.recoverConnection();
        this.timeoutTask = null;
        this.close();
        this.notifyFailure(ae);
        this.eventLoop.tryDelayQueue();
    }

    private final void recoverConnection() {
        if (this.command.policy.timeoutDelay > 0 && (this.state == 8 || this.state == 9 || this.state == 5 || this.state == 6)) {
            new NioRecover(this);
        } else {
            this.closeConnection();
            if (this.byteBuffer != null) {
                this.eventLoop.putByteBuffer(this.byteBuffer);
            }
        }
        this.byteBuffer = null;
    }

    protected final void finish() {
        this.complete();
        try {
            this.command.onSuccess();
        }
        catch (Exception e) {
            Log.error("onSuccess() error: " + Util.getErrorMessage(e));
        }
        this.eventLoop.tryDelayQueue();
    }

    protected final void onNetworkError(AerospikeException ae, boolean queueCommand) {
        this.closeConnection();
        this.retry(ae, queueCommand);
    }

    protected final void onServerTimeout() {
        this.conn.unregister();
        this.node.putAsyncConnection(this.conn, this.eventLoop.index);
        AerospikeException.Timeout ae = new AerospikeException.Timeout(this.command.policy, false);
        this.retry((AerospikeException)ae, false);
    }

    private final void retry(final AerospikeException ae, boolean queueCommand) {
        if (this.iteration > this.command.maxRetries) {
            this.close();
            this.notifyFailure(ae);
            this.eventLoop.tryDelayQueue();
            return;
        }
        long currentTime = 0L;
        if (this.hasTotalTimeout && (currentTime = System.nanoTime()) >= this.totalDeadline) {
            this.close();
            this.notifyFailure(ae);
            this.eventLoop.tryDelayQueue();
            return;
        }
        long deadline = this.totalDeadline;
        if (this.usingSocketTimeout) {
            this.timeoutTask.cancel();
            long timeout = TimeUnit.MILLISECONDS.toNanos(this.command.socketTimeout);
            if (this.hasTotalTimeout) {
                long remaining = this.totalDeadline - currentTime;
                if (remaining <= timeout) {
                    timeout = remaining;
                    this.usingSocketTimeout = false;
                }
            } else {
                currentTime = System.nanoTime();
            }
            deadline = currentTime + timeout;
        }
        if (queueCommand) {
            final long d = deadline;
            this.eventLoop.execute(new Runnable(){

                @Override
                public void run() {
                    if (NioCommand.this.state == 10) {
                        return;
                    }
                    NioCommand.this.retry(ae, d);
                }
            });
        } else {
            this.retry(ae, deadline);
        }
    }

    private final void retry(AerospikeException ae, long deadline) {
        if (!this.command.prepareRetry(ae.getResultCode() != -8) && this.command.retryBatch(this, deadline)) {
            this.close();
            return;
        }
        if (this.usingSocketTimeout) {
            this.eventLoop.timer.restoreTimeout(this.timeoutTask, deadline);
        }
        this.executeCommand();
    }

    protected final void onApplicationError(AerospikeException ae) {
        if (ae.keepConnection()) {
            this.complete();
        } else {
            this.fail();
        }
        this.notifyFailure(ae);
        this.eventLoop.tryDelayQueue();
    }

    private final void notifyFailure(AerospikeException ae) {
        try {
            ae.setNode(this.node);
            ae.setPolicy(this.command.policy);
            ae.setIteration(this.iteration);
            ae.setInDoubt(this.command.isWrite(), this.commandSentCounter);
            if (Log.debugEnabled()) {
                Command.LogPolicy(this.command.policy);
            }
            this.command.onFailure(ae);
        }
        catch (Exception e) {
            Log.error("onFailure() error: " + Util.getErrorMessage(e));
        }
    }

    private final void complete() {
        this.conn.unregister();
        this.node.putAsyncConnection(this.conn, this.eventLoop.index);
        this.close();
    }

    private final void fail() {
        this.closeConnection();
        this.close();
    }

    private final void closeConnection() {
        if (this.conn != null) {
            this.node.closeAsyncConnection(this.conn, this.eventLoop.index);
            this.conn = null;
        }
    }

    private final void closeFromDelayQueue() {
        if (this.byteBuffer != null) {
            this.eventLoop.putByteBuffer(this.byteBuffer);
        }
        this.command.putBuffer();
        this.state = 10;
        --this.eventState.pending;
    }

    private final void close() {
        if (this.timeoutTask != null) {
            this.timeoutTask.cancel();
        }
        if (this.byteBuffer != null) {
            this.eventLoop.putByteBuffer(this.byteBuffer);
        }
        this.command.putBuffer();
        this.state = 10;
        --this.eventState.pending;
        --this.eventLoop.pending;
    }
}

