/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.cluster;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.Key;
import com.aerospike.client.cluster.Cluster;
import com.aerospike.client.cluster.Node;
import com.aerospike.client.cluster.Partitions;
import com.aerospike.client.command.Buffer;
import com.aerospike.client.policy.Policy;
import com.aerospike.client.policy.Replica;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicReferenceArray;

public final class Partition {
    private final Partitions partitions;
    private final String namespace;
    private final Replica replica;
    private final int partitionId;
    private int sequence;
    private final boolean linearize;

    public static Partition write(Cluster cluster, Policy policy, Key key) {
        HashMap<String, Partitions> map = cluster.partitionMap;
        Partitions partitions = map.get(key.namespace);
        if (partitions == null) {
            throw new AerospikeException.InvalidNamespace(key.namespace, map.size());
        }
        return new Partition(partitions, key, policy.replica, false);
    }

    public static Partition read(Cluster cluster, Policy policy, Key key) {
        boolean linearize;
        Replica replica;
        HashMap<String, Partitions> map = cluster.partitionMap;
        Partitions partitions = map.get(key.namespace);
        if (partitions == null) {
            throw new AerospikeException.InvalidNamespace(key.namespace, map.size());
        }
        if (partitions.scMode) {
            switch (policy.readModeSC) {
                case SESSION: {
                    replica = Replica.MASTER;
                    linearize = false;
                    break;
                }
                case LINEARIZE: {
                    replica = policy.replica == Replica.PREFER_RACK ? Replica.SEQUENCE : policy.replica;
                    linearize = true;
                    break;
                }
                default: {
                    replica = policy.replica;
                    linearize = false;
                    break;
                }
            }
        } else {
            replica = policy.replica;
            linearize = false;
        }
        return new Partition(partitions, key, replica, linearize);
    }

    public static Replica getReplicaSC(Policy policy) {
        switch (policy.readModeSC) {
            case SESSION: {
                return Replica.MASTER;
            }
            case LINEARIZE: {
                return policy.replica == Replica.PREFER_RACK ? Replica.SEQUENCE : policy.replica;
            }
        }
        return policy.replica;
    }

    public static Node getNodeBatchRead(Cluster cluster, Key key, Replica replica, Replica replicaSC, int sequence, int sequenceSC) {
        HashMap<String, Partitions> map = cluster.partitionMap;
        Partitions partitions = map.get(key.namespace);
        if (partitions == null) {
            throw new AerospikeException.InvalidNamespace(key.namespace, map.size());
        }
        if (partitions.scMode) {
            replica = replicaSC;
            sequence = sequenceSC;
        }
        Partition p = new Partition(partitions, key, replica, false);
        p.sequence = sequence;
        return p.getNodeRead(cluster);
    }

    private Partition(Partitions partitions, Key key, Replica replica, boolean linearize) {
        this.partitions = partitions;
        this.namespace = key.namespace;
        this.replica = replica;
        this.linearize = linearize;
        this.partitionId = Partition.getPartitionId(key.digest);
    }

    public static int getPartitionId(byte[] digest) {
        return (Buffer.littleBytesToInt(digest, 0) & 0xFFFF) % 4096;
    }

    public Node getNodeRead(Cluster cluster) {
        switch (this.replica) {
            default: {
                return this.getSequenceNode(cluster);
            }
            case PREFER_RACK: {
                return this.getRackNode(cluster);
            }
            case MASTER: {
                return this.getMasterNode(cluster);
            }
            case MASTER_PROLES: {
                return this.getMasterProlesNode(cluster);
            }
            case RANDOM: 
        }
        return cluster.getRandomNode();
    }

    public Node getNodeWrite(Cluster cluster) {
        switch (this.replica) {
            default: {
                return this.getSequenceNode(cluster);
            }
            case MASTER: 
            case MASTER_PROLES: 
            case RANDOM: 
        }
        return this.getMasterNode(cluster);
    }

    public void prepareRetryRead(boolean timeout) {
        if (!timeout || !this.linearize) {
            ++this.sequence;
        }
    }

    public void prepareRetryWrite(boolean timeout) {
        if (!timeout) {
            ++this.sequence;
        }
    }

    private Node getSequenceNode(Cluster cluster) {
        AtomicReferenceArray<Node>[] replicas = this.partitions.replicas;
        for (int i = 0; i < replicas.length; ++i) {
            int index2 = Math.abs(this.sequence % replicas.length);
            Node node = replicas[index2].get(this.partitionId);
            if (node != null && node.isActive()) {
                return node;
            }
            ++this.sequence;
        }
        Node[] nodeArray = cluster.getNodes();
        throw new AerospikeException.InvalidNode(nodeArray.length, this);
    }

    private Node getRackNode(Cluster cluster) {
        AtomicReferenceArray<Node>[] replicas = this.partitions.replicas;
        Node fallback = null;
        boolean retry = this.sequence > 0;
        for (int i = 1; i <= replicas.length; ++i) {
            int index2 = Math.abs(this.sequence % replicas.length);
            Node node = replicas[index2].get(this.partitionId);
            if (node != null && node.isActive()) {
                if (retry && fallback != null && i == replicas.length) {
                    return fallback;
                }
                if (node.hasRack(this.namespace, cluster.rackId)) {
                    return node;
                }
                if (fallback == null) {
                    fallback = node;
                }
            }
            ++this.sequence;
        }
        if (fallback != null) {
            return fallback;
        }
        Node[] nodeArray = cluster.getNodes();
        throw new AerospikeException.InvalidNode(nodeArray.length, this);
    }

    private Node getMasterNode(Cluster cluster) {
        Node node = this.partitions.replicas[0].get(this.partitionId);
        if (node != null && node.isActive()) {
            return node;
        }
        Node[] nodeArray = cluster.getNodes();
        throw new AerospikeException.InvalidNode(nodeArray.length, this);
    }

    private Node getMasterProlesNode(Cluster cluster) {
        AtomicReferenceArray<Node>[] replicas = this.partitions.replicas;
        for (int i = 0; i < replicas.length; ++i) {
            int index2 = Math.abs(cluster.replicaIndex.getAndIncrement() % replicas.length);
            Node node = replicas[index2].get(this.partitionId);
            if (node == null || !node.isActive()) continue;
            return node;
        }
        Node[] nodeArray = cluster.getNodes();
        throw new AerospikeException.InvalidNode(nodeArray.length, this);
    }

    public String toString() {
        return this.namespace + ':' + this.partitionId;
    }

    public int hashCode() {
        int prime = 31;
        int result = 31 + this.namespace.hashCode();
        result = 31 * result + this.partitionId;
        return result;
    }

    public boolean equals(Object obj) {
        Partition other = (Partition)obj;
        return this.namespace.equals(other.namespace) && this.partitionId == other.partitionId;
    }
}

